/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.owlsmx;

import de.dfki.s2m2de.MatchingEngine;
import de.dfki.s2m2de.MatchingSetup;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import de.dfki.s2m2de.owlsmx.OWLSMXFactory;
import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewGenerationException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;

public class OWLSMX
extends MatchingEngine {
    protected PelletReasoner pellet;

    protected OWLSMX(ServiceRegistry serviceRegistry, MatchingSetup setup, PelletReasoner pellet) {
        super(serviceRegistry, setup);
        this.pellet = pellet;
    }

    public void registerServices(URL descriptionUrl) {
        try {
            Set<URI> services = this.serviceRegistry.registerServices(descriptionUrl);
            for (URI service : services) {
                ServiceView serviceView = this.serviceRegistry.getViewOnService(service, OWLSMXFactory.getOWLSM0ViewExtractor());
                for (ServiceComponent component : serviceView.getComponents("input")) {
                    if (!component.hasCharacteristic(ConceptIdentifier.class)) continue;
                    this.pellet.processClass(component.castTo(ConceptIdentifier.class).toURI());
                }
                for (ServiceComponent component : serviceView.getComponents("output")) {
                    if (!component.hasCharacteristic(ConceptIdentifier.class)) continue;
                    this.pellet.processClass(component.castTo(ConceptIdentifier.class).toURI());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ViewGenerationException e) {
            e.printStackTrace();
        }
    }
}

