/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.owlsmx;

import de.dfki.isem.ParameterDefinitionExtractor;
import de.dfki.s2m2de.MatchingSetup;
import de.dfki.s2m2de.expression.Average;
import de.dfki.s2m2de.expression.CachedExpression;
import de.dfki.s2m2de.expression.Concatenation;
import de.dfki.s2m2de.expression.Conjunction;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.FixedValue;
import de.dfki.s2m2de.expression.ForallExists;
import de.dfki.s2m2de.expression.GreaterEquals;
import de.dfki.s2m2de.expression.Inverse;
import de.dfki.s2m2de.expression.ServiceConceptsFilter;
import de.dfki.s2m2de.expression.ServiceLevelConceptsEvaluation;
import de.dfki.s2m2de.expression.ServiceLevelLiteralsEvaluation;
import de.dfki.s2m2de.expression.True;
import de.dfki.s2m2de.inference.dl.DLReasoner;
import de.dfki.s2m2de.inference.dl.NotSupportedException;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import de.dfki.s2m2de.inference.dl.pellet.StructuralConceptSimilarity;
import de.dfki.s2m2de.owlsmx.OWLSMX;
import de.dfki.s2m2de.owlsmx.SignatureStructureEvaluation;
import de.dfki.s2m2de.ranking.CombinedRankingOrder;
import de.dfki.s2m2de.ranking.RankByCategory;
import de.dfki.s2m2de.ranking.RankDescending;
import de.dfki.s2m2de.ranking.RankingOrder;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.owls.OWLSExtractor;
import de.dfki.s2m2de.service.owls.OWLSRegistry;
import de.dfki.s2m2de.textsim.LossOfInformation;
import de.dfki.s2m2de.textsim.TextSimilarityMeasure;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class OWLSMXFactory {
    private static final OWLSExtractor m0ViewExtractor = new OWLSExtractor();
    private static final OWLSExtractor mxViewExtractor = new ParameterDefinitionExtractor();

    private OWLSMXFactory() {
    }

    public static OWLSExtractor getOWLSM0ViewExtractor() {
        return m0ViewExtractor;
    }

    public static OWLSExtractor getOWLSMXViewExtractor() {
        return mxViewExtractor;
    }

    public static List<Expression<ServiceView, Boolean>> createOWLSM0Filters(DLReasoner reasoner) throws NotSupportedException {
        LinkedList<Expression<ServiceView, Boolean>> filters = new LinkedList<Expression<ServiceView, Boolean>>();
        ServiceConceptsFilter inputExact = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new Inverse<Collection<URI>, Boolean>(new ForallExists<URI>(reasoner.getConceptEquivalence())), "input");
        ServiceConceptsFilter outputExact = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new ForallExists<URI>(reasoner.getConceptEquivalence()), "output");
        Conjunction<ServiceView> exactFilter = new Conjunction<ServiceView>(inputExact, outputExact);
        filters.add(exactFilter);
        CachedExpression<ServiceView, Boolean> inputSubsumes = new CachedExpression<ServiceView, Boolean>(new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new Inverse<Collection<URI>, Boolean>(new ForallExists<URI>(reasoner.getConceptSubsumption())), "input"));
        ServiceConceptsFilter outputPlugin = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new ForallExists<URI>(reasoner.getLeastGenericConcept()), "output");
        Conjunction<ServiceView> pluginFilter = new Conjunction<ServiceView>(inputSubsumes, outputPlugin);
        filters.add(pluginFilter);
        ServiceConceptsFilter outputSubsumes = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new ForallExists<URI>(reasoner.getConceptSubsumption()), "output");
        Conjunction<ServiceView> subsumesFilter = new Conjunction<ServiceView>(inputSubsumes, outputSubsumes);
        filters.add(subsumesFilter);
        ServiceConceptsFilter outputSubsumedBy = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new ForallExists<URI>(reasoner.getLeastSpecificConcept()), "output");
        Conjunction<ServiceView> subsumedByFilter = new Conjunction<ServiceView>(inputSubsumes, outputSubsumedBy);
        filters.add(subsumedByFilter);
        filters.add(new True());
        return filters;
    }

    public static Expression<ServiceView, Double> createStructuralFilter(PelletReasoner pellet) {
        return new Average<ServiceView>(new ServiceLevelConceptsEvaluation<Double>(new Inverse<Collection<URI>, Double>(new SignatureStructureEvaluation(new StructuralConceptSimilarity(pellet))), "input"), new ServiceLevelConceptsEvaluation<Double>(new SignatureStructureEvaluation(new StructuralConceptSimilarity(pellet)), "output"));
    }

    public static MatchingSetup createOWLSM0Setup(DLReasoner reasoner) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> filters = OWLSMXFactory.createOWLSM0Filters(reasoner);
        RankByCategory rankingOrder = new RankByCategory(filters);
        MatchingSetup setup = new MatchingSetup(m0ViewExtractor, new HashSet<Expression<ServiceView, Boolean>>(filters), rankingOrder);
        return setup;
    }

    public static MatchingSetup createStructureMatchingSetup(PelletReasoner pellet) {
        Expression<ServiceView, Double> filter = OWLSMXFactory.createStructuralFilter(pellet);
        RankDescending rankingOrder = new RankDescending(filter);
        MatchingSetup setup = new MatchingSetup(m0ViewExtractor, Collections.singleton(filter), rankingOrder);
        return setup;
    }

    public static MatchingSetup createOWLSMX2Setup(DLReasoner reasoner, TextSimilarityMeasure textSimMeasure) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> m0Filters = OWLSMXFactory.createOWLSM0Filters(reasoner);
        CachedExpression<ServiceView, Double> textSim = new CachedExpression<ServiceView, Double>(new Average(new ServiceLevelLiteralsEvaluation<Double>(new Concatenation<Double>(textSimMeasure), "inputDef"), new ServiceLevelLiteralsEvaluation<Double>(new Concatenation<Double>(textSimMeasure), "outputDef")));
        CachedExpression textSimPart = new CachedExpression(new GreaterEquals(textSim, new FixedValue(0.5)));
        LinkedList<Expression<ServiceView, Boolean>> mxFilters = new LinkedList<Expression<ServiceView, Boolean>>();
        int i = 0;
        while (i < 4) {
            mxFilters.add(new Conjunction<ServiceView>(m0Filters.get(i), textSimPart));
            ++i;
        }
        mxFilters.add(textSimPart);
        mxFilters.add(m0Filters.get(4));
        LinkedList<RankingOrder> basicOrders = new LinkedList<RankingOrder>();
        basicOrders.add(new RankByCategory(mxFilters));
        basicOrders.add(new RankDescending(textSim));
        CombinedRankingOrder rankingOrder = new CombinedRankingOrder(basicOrders);
        HashSet<Expression<ServiceView, Boolean>> features = new HashSet<Expression<ServiceView, Boolean>>(mxFilters);
        features.add(textSim);
        MatchingSetup setup = new MatchingSetup(mxViewExtractor, features, rankingOrder);
        return setup;
    }

    public static OWLSMX createOWLSM0() {
        try {
            PelletReasoner reasoner = new PelletReasoner();
            OWLSRegistry registry = new OWLSRegistry();
            MatchingSetup setup = OWLSMXFactory.createOWLSM0Setup(reasoner);
            return new OWLSMX(registry, setup, reasoner);
        }
        catch (NotSupportedException e) {
            return null;
        }
    }

    public static OWLSMX createStructuralMatcher() {
        PelletReasoner reasoner = new PelletReasoner();
        OWLSRegistry registry = new OWLSRegistry();
        MatchingSetup setup = OWLSMXFactory.createStructureMatchingSetup(reasoner);
        return new OWLSMX(registry, setup, reasoner);
    }

    public static OWLSMX createOWLSMX2(TextSimilarityMeasure textSimMeasure) {
        try {
            PelletReasoner reasoner = new PelletReasoner();
            OWLSRegistry registry = new OWLSRegistry();
            MatchingSetup setup = OWLSMXFactory.createOWLSMX2Setup(reasoner, textSimMeasure);
            return new OWLSMX(registry, setup, reasoner);
        }
        catch (NotSupportedException e) {
            return null;
        }
    }

    public static OWLSMX createOWLSMX2M1() {
        return OWLSMXFactory.createOWLSMX2(new LossOfInformation());
    }
}

