/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.owlsmx;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.inference.dl.pellet.StructuralConceptSimilarity;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureStructureEvaluation
extends AbstractExpression<Collection<URI>, Double> {
    protected StructuralConceptSimilarity conceptStructSim;
    protected double gamma = 0.5;

    public SignatureStructureEvaluation(StructuralConceptSimilarity conceptStructSim) {
        this.conceptStructSim = conceptStructSim;
    }

    public SignatureStructureEvaluation(StructuralConceptSimilarity conceptStructSim, double gamma) {
        this.conceptStructSim = conceptStructSim;
        this.gamma = gamma;
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.conceptStructSim);
        return result;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("signaturestructure");
        elem.setAttribute("gamma", "" + this.gamma);
        parentElem.appendChild(elem);
        this.conceptStructSim.decompile(targetDoc, elem);
    }

    @Override
    public Double evaluate(Collection<URI> entities1, Collection<URI> entities2) throws ExpressionEvaluationException {
        double conceptSim = 1.0;
        if (entities1.size() > 0) {
            double sum = 0.0;
            for (URI a : entities1) {
                double maxSim = 0.0;
                for (URI b : entities2) {
                    double sim = (Double)this.conceptStructSim.evaluate(a, b);
                    if (!(sim > maxSim)) continue;
                    maxSim = sim;
                }
                sum += maxSim;
            }
            conceptSim = sum / (double)entities1.size();
        }
        if (this.gamma == 1.0) {
            return conceptSim;
        }
        int maxSize = Math.max(entities1.size(), entities2.size());
        double sigSim = 1.0;
        if (maxSize != 0) {
            sigSim = 1.0 - (double)Math.abs(entities1.size() - entities2.size()) / (double)maxSize;
        }
        return this.gamma * conceptSim + (1.0 - this.gamma) * sigSim;
    }
}

