/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service;

import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class CachingServiceRegistry
extends ServiceRegistry {
    protected HashMap<URI, URL> sources = new HashMap();
    protected HashMap<URI, ServiceView> serviceCache = new HashMap();
    protected ViewExtractor cachedFrom = null;

    @Override
    protected void removeService(URI serviceUri) {
        this.sources.remove(serviceUri);
        this.serviceCache.remove(serviceUri);
    }

    @Override
    public URL getSource(URI serviceUri) {
        return this.sources.get(serviceUri);
    }

    @Override
    public Set<URI> getRegisteredServices() {
        return this.sources.keySet();
    }

    @Override
    public ServiceView getViewOnService(URI serviceUri, ViewExtractor viewExtractor) throws ViewGenerationException {
        URL sourceDocument = this.sources.get(serviceUri);
        if (sourceDocument == null) {
            throw new ViewGenerationException("Unable to extract view on " + serviceUri.toString() + ". Service not registered.");
        }
        if (viewExtractor.equals(this.cachedFrom)) {
            if (this.serviceCache.containsKey(serviceUri)) {
                return this.serviceCache.get(serviceUri);
            }
            ServiceView view = viewExtractor.extract(serviceUri, sourceDocument);
            this.serviceCache.put(serviceUri, view);
            return view;
        }
        this.serviceCache.clear();
        this.cachedFrom = viewExtractor;
        ServiceView view = viewExtractor.extract(serviceUri, sourceDocument);
        this.serviceCache.put(serviceUri, view);
        return view;
    }

    public void prepareCache(ViewExtractor viewExtractor) throws ViewGenerationException {
        if (viewExtractor.equals(this.cachedFrom)) {
            for (Map.Entry<URI, URL> entry : this.sources.entrySet()) {
                URI serviceUri = entry.getKey();
                if (this.serviceCache.containsKey(serviceUri)) continue;
                ServiceView view = viewExtractor.extract(serviceUri, entry.getValue());
                this.serviceCache.put(serviceUri, view);
            }
        } else {
            this.serviceCache.clear();
            this.cachedFrom = viewExtractor;
            for (Map.Entry<URI, URL> entry : this.sources.entrySet()) {
                URI serviceUri = entry.getKey();
                ServiceView view = viewExtractor.extract(serviceUri, entry.getValue());
                this.serviceCache.put(serviceUri, view);
            }
        }
    }
}

