/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service;

import de.dfki.s2m2de.service.RegistryEventHandler;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.mindswap.exceptions.NotImplementedException;

public abstract class ServiceRegistry {
    private Map<String, RegistryEventHandler> registrationEventHandlers = new HashMap<String, RegistryEventHandler>();
    private Map<String, RegistryEventHandler> deregistrationEventHandlers = new HashMap<String, RegistryEventHandler>();

    public void addEventHandler(String id, RegistryEventHandler eventHandler, Event type) throws IllegalArgumentException {
        if (this.registrationEventHandlers.containsKey(id) || this.deregistrationEventHandlers.containsKey(id)) {
            throw new IllegalArgumentException("Unable to register event handler. Event handler ID already in use.");
        }
        switch (type) {
            case REGISTRATION: {
                this.registrationEventHandlers.put(id, eventHandler);
                break;
            }
            case DEREGISTRATION: {
                this.deregistrationEventHandlers.put(id, eventHandler);
                break;
            }
            default: {
                throw new NotImplementedException("Event type not implemented.");
            }
        }
    }

    public boolean removeEventHandler(String id) {
        if (this.registrationEventHandlers.containsKey(id)) {
            this.registrationEventHandlers.remove(id);
            return true;
        }
        if (this.deregistrationEventHandlers.containsKey(id)) {
            this.deregistrationEventHandlers.remove(id);
            return true;
        }
        return false;
    }

    public abstract Set<URI> getRegisteredServices();

    public final Set<URI> registerServices(URL descriptionUrl) throws IOException {
        Set<URI> serviceUris = this.addServices(descriptionUrl);
        for (RegistryEventHandler eventHandler : this.registrationEventHandlers.values()) {
            for (URI serviceUri : serviceUris) {
                eventHandler.handle(serviceUri);
            }
        }
        return serviceUris;
    }

    protected abstract Set<URI> addServices(URL var1) throws IOException;

    public final void deregisterService(URI serviceUri) {
        for (RegistryEventHandler eventHandler : this.deregistrationEventHandlers.values()) {
            eventHandler.handle(serviceUri);
        }
        this.removeService(serviceUri);
    }

    protected abstract void removeService(URI var1);

    public abstract URL getSource(URI var1);

    public abstract ServiceView getViewOnService(URI var1, ViewExtractor var2) throws ViewGenerationException;

    public static enum Event {
        REGISTRATION,
        DEREGISTRATION;

    }
}

