/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service;

import de.dfki.s2m2de.service.ServiceComponent;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class ServiceView
extends HashMap<String, Collection<ServiceComponent>>
implements Comparable<ServiceView> {
    private static final long serialVersionUID = 1L;
    protected URI serviceUri;

    public ServiceView(URI serviceUri) {
        this.serviceUri = serviceUri;
    }

    public void addComponent(String type, ServiceComponent component) {
        if (!this.containsKey(type)) {
            LinkedList<ServiceComponent> components = new LinkedList<ServiceComponent>();
            components.add(component);
            this.put(type, components);
        } else {
            ((Collection)this.get(type)).add(component);
        }
    }

    public Collection<ServiceComponent> getComponents(String type) {
        if (!this.containsKey(type)) {
            return new LinkedList<ServiceComponent>();
        }
        return (Collection)this.get(type);
    }

    public void mergeWith(ServiceView anotherView) {
        for (Map.Entry entry : anotherView.entrySet()) {
            for (ServiceComponent component : (Collection)entry.getValue()) {
                this.addComponent((String)entry.getKey(), component);
            }
        }
    }

    public URI getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public String toString() {
        String str = "<" + this.serviceUri.toString() + ">:";
        for (String key : this.keySet()) {
            Collection collection = (Collection)this.get(key);
            str = String.valueOf(str) + "\n" + key + ": [ ";
            for (ServiceComponent component : collection) {
                str = String.valueOf(str) + component.toString() + " ";
            }
            str = String.valueOf(str) + "]";
        }
        return str;
    }

    @Override
    public int compareTo(ServiceView anotherView) {
        if (anotherView == null) {
            return Integer.MAX_VALUE;
        }
        return this.serviceUri.compareTo(anotherView.getServiceUri());
    }
}

