/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service.owls;

import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.PlainTextContent;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.Specification;
import de.dfki.s2m2de.service.SpecificationParsingException;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import de.dfki.s2m2de.service.pddl.PDDLExpression;
import de.dfki.s2m2de.service.pddl.PDDXMLExpression;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;

public class OWLSExtractor
implements ViewExtractor {
    protected OWLKnowledgeBase owlKnowledgeBase = OWLFactory.createKB();

    public OWLSExtractor() {
        this.owlKnowledgeBase.getReader().getCache().setLocalCacheDirectory("cache");
    }

    @Override
    public ServiceView extract(URI serviceUri, URL documentUrl) throws ViewGenerationException {
        try {
            OWLDataValue exprBody;
            URI documentUri = documentUrl.toURI();
            this.owlKnowledgeBase.readAllServices(documentUri);
            ServiceView resultView = new ServiceView(serviceUri);
            Service service = this.owlKnowledgeBase.getService(serviceUri);
            Profile profile = service.getProfile();
            for (Input input : profile.getInputs()) {
                resultView.addComponent("input", new ConceptIdentifier("input", input.getParamType().getURI()));
            }
            for (Output output : profile.getOutputs()) {
                resultView.addComponent("output", new ConceptIdentifier("output", output.getParamType().getURI()));
            }
            try {
                OWLIndividualList preconditions = service.getProcess().getProperties(this.owlKnowledgeBase.createObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Process.owl#hasPrecondition")));
                for (OWLIndividual condition : preconditions) {
                    exprBody = condition.getProperty(this.owlKnowledgeBase.createDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/generic/Expression.owl#expressionBody")));
                    try {
                        resultView.addComponent("precondition", new Specification<PDDLExpression>("precondition", PDDLExpression.create(exprBody.getLexicalValue())));
                    }
                    catch (SpecificationParsingException e) {
                        try {
                            resultView.addComponent("precondition", new Specification<PDDLExpression>("precondition", PDDXMLExpression.create(exprBody.getLexicalValue())));
                        }
                        catch (SpecificationParsingException e1) {
                            System.err.println("Unsupported precondition expression found: " + exprBody.getLexicalValue());
                        }
                    }
                }
            }
            catch (NullPointerException preconditions) {
                // empty catch block
            }
            try {
                OWLIndividualList effects = service.getProcess().getResult().getProperties(this.owlKnowledgeBase.createObjectProperty(URI.create("http://www.daml.org/services/owl-s/1.1/Process.owl#hasEffect")));
                for (OWLIndividual expression : effects) {
                    exprBody = expression.getProperty(this.owlKnowledgeBase.createDataProperty(URI.create("http://www.daml.org/services/owl-s/1.1/generic/Expression.owl#expressionBody")));
                    try {
                        resultView.addComponent("effect", new Specification<PDDLExpression>("effect", PDDLExpression.create(exprBody.getLexicalValue())));
                    }
                    catch (SpecificationParsingException e) {
                        try {
                            resultView.addComponent("effect", new Specification<PDDLExpression>("effect", PDDXMLExpression.create(exprBody.getLexicalValue())));
                        }
                        catch (SpecificationParsingException e1) {
                            System.err.println("Unsupported effect expression found: " + exprBody.getLexicalValue());
                        }
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            resultView.addComponent("description", new PlainTextContent("description", profile.getTextDescription()));
            this.owlKnowledgeBase.unload(documentUri);
            return resultView;
        }
        catch (IOException e) {
            throw new ViewGenerationException("Unable to extract inputs/outputs of service " + serviceUri + " from " + documentUrl + ".", e);
        }
        catch (URISyntaxException e) {
            throw new ViewGenerationException("Unable to extract inputs/outputs of service " + serviceUri + " from " + documentUrl + ".", e);
        }
        catch (Exception e) {
            throw new ViewGenerationException("Unable to extract inputs/outputs of service " + serviceUri + " from " + documentUrl + ".", e);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Invalid number of arguments.");
            System.exit(1);
        }
        try {
            URI serviceUri = URI.create(args[0]);
            URL documentUrl = new URL(args[1]);
            OWLSExtractor extractor = new OWLSExtractor();
            ServiceView serviceView = extractor.extract(serviceUri, documentUrl);
            System.out.println(serviceView.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

