/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service.owls;

import de.dfki.s2m2de.service.CachingServiceRegistry;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owls.service.Service;

public class OWLSRegistry
extends CachingServiceRegistry {
    protected OWLKnowledgeBase owlKnowledgeBase = OWLFactory.createKB();

    public OWLSRegistry() {
        this.owlKnowledgeBase.getReader().getCache().setLocalCacheDirectory("cache");
    }

    @Override
    protected Set<URI> addServices(URL descriptionUrl) throws IOException {
        try {
            URI descriptionUri = descriptionUrl.toURI();
            List services = this.owlKnowledgeBase.readAllServices(descriptionUri);
            HashSet<URI> result = new HashSet<URI>();
            for (Service service : services) {
                URI serviceUri = service.getURI();
                this.sources.put(serviceUri, descriptionUrl);
                result.add(serviceUri);
            }
            this.owlKnowledgeBase.unload(descriptionUri);
            return result;
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to load services from " + descriptionUrl.toString() + ".", e);
        }
    }
}

