/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.service.pddl;

import de.dfki.s2m2de.service.SpecificationExpression;
import de.dfki.s2m2de.service.SpecificationParsingException;
import de.dfki.s2m2de.service.pddl.Atom;
import de.dfki.s2m2de.service.pddl.Conjunction;
import de.dfki.s2m2de.service.pddl.Disjunction;
import de.dfki.s2m2de.service.pddl.Negation;
import java.util.HashSet;
import java.util.LinkedList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import uk.ac.bham.cs.zas.pddl.antlr.PddlLexer;
import uk.ac.bham.cs.zas.pddl.antlr.PddlParser;

public abstract class PDDLExpression
implements SpecificationExpression {
    @Override
    public String getLanguage() {
        return "PDDL";
    }

    public static PDDLExpression create(String exprString) throws SpecificationParsingException {
        PddlLexer lexer = new PddlLexer((CharStream)new ANTLRStringStream(exprString));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PddlParser parser = new PddlParser((TokenStream)tokens);
        try {
            PddlParser.goalDesc_return expr = parser.goalDesc();
            CommonTree tree = (CommonTree)expr.getTree();
            return PDDLExpression.parseTree((Tree)tree);
        }
        catch (RecognitionException e) {
            throw new SpecificationParsingException(e);
        }
    }

    private static PDDLExpression parseTree(Tree tree) throws SpecificationParsingException {
        switch (tree.getType()) {
            case 34: {
                LinkedList<String> params = new LinkedList<String>();
                int i = 1;
                while (i < tree.getChildCount()) {
                    params.add(tree.getChild(i).getText().substring(1));
                    ++i;
                }
                return new Atom(tree.getChild(0).getText(), params);
            }
            case 22: {
                HashSet<PDDLExpression> subExpr = new HashSet<PDDLExpression>();
                int i = 0;
                while (i < tree.getChildCount()) {
                    subExpr.add(PDDLExpression.parseTree(tree.getChild(i)));
                    ++i;
                }
                return new Conjunction(subExpr);
            }
            case 23: {
                HashSet<PDDLExpression> subExpr = new HashSet<PDDLExpression>();
                int i = 0;
                while (i < tree.getChildCount()) {
                    subExpr.add(PDDLExpression.parseTree(tree.getChild(i)));
                    ++i;
                }
                return new Disjunction(subExpr);
            }
            case 24: {
                return new Negation(PDDLExpression.parseTree(tree.getChild(0)));
            }
        }
        System.out.println("Ingored " + tree.toString());
        throw new SpecificationParsingException("Element not supported: " + tree.getText());
    }

    public abstract boolean isCNF();

    public static void main(String[] args) {
        String exprString = "<and></and>";
        try {
            PDDLExpression pddl = PDDLExpression.create(exprString);
            System.out.println(pddl.toString());
        }
        catch (SpecificationParsingException e) {
            e.printStackTrace();
        }
    }
}

