/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.textsim;

import de.dfki.s2m2de.textsim.StopWordRemover;
import de.dfki.s2m2de.textsim.TextSimilarityMeasure;
import java.util.HashSet;
import org.tartarus.stemmer.Stemmer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LossOfInformation
extends TextSimilarityMeasure {
    @Override
    public Double evaluate(String requestText, String offerText) {
        Stemmer stemmer;
        String[] requestTerms = StopWordRemover.removeStopWords(requestText).split(" ");
        String[] offerTerms = StopWordRemover.removeStopWords(offerText).split(" ");
        HashSet<String> requestSet = new HashSet<String>();
        HashSet<String> offerSet = new HashSet<String>();
        int i = 0;
        while (i < requestTerms.length) {
            stemmer = new Stemmer();
            stemmer.add(requestTerms[i].toCharArray(), requestTerms[i].length());
            stemmer.stem();
            requestSet.add(stemmer.toString());
            ++i;
        }
        i = 0;
        while (i < offerTerms.length) {
            stemmer = new Stemmer();
            stemmer.add(offerTerms[i].toCharArray(), offerTerms[i].length());
            stemmer.stem();
            offerSet.add(stemmer.toString());
            ++i;
        }
        int unionSize = requestSet.size();
        int intersectionSize = 0;
        for (String term : offerSet) {
            if (requestSet.contains(term)) {
                ++intersectionSize;
                continue;
            }
            ++unionSize;
        }
        return 1.0 - (double)(unionSize - intersectionSize) / (double)(requestSet.size() + offerSet.size());
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("lossofinformation");
        parentElem.appendChild(elem);
    }

    public static void main(String[] args) {
        String text1 = "A test is a way of checking something to see if it is true or if it works. If something can be tested, it is testable.";
        String text2 = "Turing test a procedure to test whether a computer is capable of humanlike thought.";
        LossOfInformation sim = new LossOfInformation();
        System.out.println("LOI similarity (text1 <-> text2): " + sim.evaluate(text1, text2));
        System.out.println("LOI similarity (text2 <-> text1): " + sim.evaluate(text2, text1));
        System.out.println("LOI similarity (text1 <-> text1): " + sim.evaluate(text1, text1));
    }
}

