/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.textsim.lucene;

import de.dfki.s2m2de.textsim.Index;
import de.dfki.s2m2de.textsim.IndexException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;

public class LuceneMemoryIndex
implements Index {
    public static final String ID = "id";
    public static final String CONTENT = "content";
    protected IndexWriter luceneIndex;
    protected IndexReader luceneReader;
    protected RAMDirectory ramDirectory;
    protected Analyzer analyzer;
    protected Term idTermTemplate;
    protected Term contentTermTemplate;

    public LuceneMemoryIndex() throws IndexException {
        try {
            this.ramDirectory = new RAMDirectory();
            Vector<String> stopwords = new Vector<String>(Arrays.asList(StandardAnalyzer.STOP_WORDS));
            stopwords.add("subclassof");
            stopwords.add("objectallvaluesfrom");
            stopwords.add("dataallvaluesfrom");
            stopwords.add("objectsomevaluesfrom");
            stopwords.add("datasomevaluesfrom");
            stopwords.add("objectintersectionof");
            stopwords.add("objectunionof");
            stopwords.add("equivalentclasses");
            stopwords.add("disjointclasses");
            stopwords.add("inverseobjectproperties");
            stopwords.add("transitiveobjectproperty");
            stopwords.add("objectpropertyrange");
            stopwords.add("objectpropertydomain");
            stopwords.add("datapropertydomain");
            stopwords.add("datapropertyrange");
            stopwords.add("objecthasvalue");
            stopwords.add("datamaxcardinality");
            stopwords.add("datamincardinality");
            stopwords.add("objectmincardinality");
            stopwords.add("objectmaxcardinality");
            stopwords.add("differentindividuals");
            stopwords.add("objectoneof");
            stopwords.add("objectexactcardinality");
            stopwords.add("dataexactcardinality");
            this.analyzer = new StandardAnalyzer(stopwords.toArray(new String[0]));
            this.luceneIndex = new IndexWriter((Directory)this.ramDirectory, this.analyzer, true);
            this.luceneReader = IndexReader.open((Directory)this.ramDirectory);
            this.idTermTemplate = new Term(ID, "");
            this.contentTermTemplate = new Term(CONTENT, "");
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
            throw new IndexException("Unable to create term index.", e);
        }
        catch (LockObtainFailedException e) {
            e.printStackTrace();
            throw new IndexException("Unable to create term index.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IndexException("Unable to create term index.", e);
        }
    }

    @Override
    public void addDocument(String id, String content) throws IndexException {
        if (this.containsDocument(id)) {
            return;
        }
        Document document = new Document();
        document.add((Fieldable)new Field(ID, id, Field.Store.YES, Field.Index.UN_TOKENIZED));
        document.add((Fieldable)new Field(CONTENT, content, Field.Store.YES, Field.Index.TOKENIZED));
        try {
            this.luceneIndex.addDocument(document);
            this.refreshReader();
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
            throw new IndexException("Could not add document " + id + " to term index.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IndexException("Could not add document " + id + " to term index.", e);
        }
    }

    @Override
    public boolean containsDocument(String id) throws IndexException {
        Term term = this.idTermTemplate.createTerm(id);
        try {
            return this.luceneReader.termDocs(term).next();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IndexException("Unable to check document containment.", e);
        }
    }

    @Override
    public int getDocumentFrequency(String queryTerm) throws IndexException {
        try {
            Term term = this.contentTermTemplate.createTerm(queryTerm);
            return this.luceneReader.docFreq(term);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IndexException("Unable to get df for term " + queryTerm + ".", e);
        }
    }

    @Override
    public boolean removeDocument(String id) throws IndexException {
        try {
            Term term = this.idTermTemplate.createTerm(id);
            this.luceneIndex.deleteDocuments(term);
            this.refreshReader();
            return true;
        }
        catch (CorruptIndexException e) {
            e.printStackTrace();
            throw new IndexException("Unable to remove document " + id + " from index.", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IndexException("Unable to remove document " + id + " from index.", e);
        }
    }

    @Override
    public int getNumberOfDocuments() throws IndexException {
        return this.luceneReader.numDocs();
    }

    @Override
    public Vector<String> tokenize(String text) throws IndexException {
        try {
            StringReader reader = new StringReader(text);
            Vector<String> result = new Vector<String>();
            TokenStream tokenStream = this.analyzer.reusableTokenStream(CONTENT, (Reader)reader);
            Token token = tokenStream.next();
            while (token != null) {
                result.add(new String(token.termBuffer(), 0, token.termLength()));
                token = tokenStream.next();
            }
            return result;
        }
        catch (IOException e) {
            throw new IndexException("Unable to tokenize text.", e);
        }
    }

    private void refreshReader() {
        try {
            this.luceneIndex.flush();
            IndexReader newReader = this.luceneReader.reopen();
            if (newReader != this.luceneReader) {
                this.luceneReader.close();
            }
            this.luceneReader = newReader;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            LuceneMemoryIndex index = new LuceneMemoryIndex();
            index.addDocument("1", "A test is a way of checking something to see if it is true, or false, or if it is edible or not. If something can be tested, or finishes the tests correctly, it is testable.");
            index.addDocument("2", "The Turing test is a test to see if a computer can trick a person into believing that the computer is a person too. Alan Turing thought that if a human couldn't tell the difference between another human and the computer, then that computer must be as intelligent as a human.");
            index.addDocument("3", "Computer science is the science of how to treat information. There are many different areas in computer science. Some of the areas consider problems in a more abstract way. Some areas need special machines, called computers. A computer programmer will often need math, science, and logic in order to make and use computers.");
            System.out.println("Number of documents: " + index.getNumberOfDocuments());
            if (index.containsDocument("3")) {
                System.out.println("Contains document 3: true");
            } else {
                System.out.println("Contains document 3: false");
            }
            if (index.containsDocument("4")) {
                System.out.println("Contains document 4: true");
            } else {
                System.out.println("Contains document 4: false");
            }
            System.out.println("Term test: df=" + index.getDocumentFrequency("test"));
            System.out.println("Term turing: df=" + index.getDocumentFrequency("turing"));
            index.removeDocument("3");
            System.out.println("Removed document 3...");
            if (index.containsDocument("3")) {
                System.out.println("Contains document 3: true");
            } else {
                System.out.println("Contains document 3: false");
            }
            System.out.println("Number of documents: " + index.getNumberOfDocuments());
            System.out.println("Tokenize text: ");
            System.out.println("A test is a way of checking something to see if it is true, or false, or if it is edible or not. If something can be tested, or finishes the tests correctly, it is testable.");
            System.out.println("---");
            Vector<String> tokens = index.tokenize("A test is a way of checking something to see if it is true, or false, or if it is edible or not. If something can be tested, or finishes the tests correctly, it is testable.");
            for (String token : tokens) {
                System.out.print(String.valueOf(token) + " ");
            }
            System.out.println();
        }
        catch (IndexException e) {
            e.printStackTrace();
        }
    }
}

