/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseUnionDatatype
extends BaseDatatype
implements UnionDatatype {
    protected Set<Datatype> members;

    BaseUnionDatatype(ATermAppl name, Datatype[] members) {
        super(name);
        this.members = SetUtils.create((Object[])members);
    }

    BaseUnionDatatype(ATermAppl name, Set<Datatype> members) {
        super(name);
        this.members = members;
    }

    BaseUnionDatatype(Datatype[] members) {
        super(null);
        this.members = SetUtils.create((Object[])members);
    }

    BaseUnionDatatype(Set<Datatype> members) {
        super(null);
        this.members = members;
    }

    @Override
    public Set<Datatype> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public int size() {
        int size = 0;
        for (Datatype dt : this.members) {
            if ((size += dt.size()) >= 0) continue;
            return Integer.MAX_VALUE;
        }
        return size;
    }

    @Override
    public boolean contains(Object value) {
        for (Datatype dt : this.members) {
            if (!dt.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object value, AtomicDatatype datatype) {
        for (Datatype dt : this.members) {
            if (dt instanceof AtomicDatatype && !datatype.getPrimitiveType().equals(((AtomicDatatype)dt).getPrimitiveType()) || !dt.contains(value, datatype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(String value, String datatypeURI) {
        Datatype dt;
        Object obj = null;
        Iterator<Datatype> i$ = this.members.iterator();
        while (i$.hasNext() && (obj = (dt = i$.next()).getValue(value, datatypeURI)) == null) {
        }
        return obj;
    }

    @Override
    public Datatype singleton(Object value) {
        Datatype datatype = null;
        for (Datatype dt : this.members) {
            if (dt.contains(value) && (datatype = dt.singleton(value)) != null) break;
        }
        return datatype;
    }

    @Override
    public ATermAppl getValue(int n) {
        for (Datatype dt : this.members) {
            int dtSize = dt.size();
            if (dtSize == -1 || n < dtSize) {
                return dt.getValue(n);
            }
            n -= dt.size();
        }
        throw new InternalReasonerException("No values for this datatype");
    }

    public String toString() {
        return "UnionDatatype " + this.members;
    }
}

