/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.XSD;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueData;
import org.mindswap.owls.process.execution.DefaultProcessMonitor;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.utils.URIUtils;

public class CreateComplexProcess {
    OWLKnowledgeBase kb;
    OWLOntology ont;
    SWRLFactory swrl;
    Process BookFinder;
    Process BNPrice;
    Process AmazonPrice;
    OWLDataType xsdString;
    OWLDataType xsdFloat;
    OWLClass Price;
    OWLDataProperty amount;
    CompositeProcess ComparePricesProcess;
    Input CP_AmazonPrice;
    Input CP_BNPrice;
    Output CP_Bookstore;
    Output CP_OutputPrice;

    private URI uri(String localName) {
        return URIUtils.createURI(ExampleURIs.FIND_CHEAPER_BOOK, localName);
    }

    private Service createService() throws Exception {
        Service service = this.ont.createService(this.uri("TestService"));
        CompositeProcess process = this.createProcess();
        Profile profile = this.createProfile(process);
        Grounding grounding = this.createGrounding(process);
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        return service;
    }

    private Profile createProfile(Process process) {
        Profile profile = this.ont.createProfile(this.uri("TestProfile"));
        profile.setLabel("Cheaper Book Finder");
        profile.setTextDescription("Find the price of book in Amazon and Barnes & Nobles and return the cheaper price");
        int i = 0;
        while (i < process.getInputs().size()) {
            Input input = (Input)process.getInputs().get(i);
            profile.addInput(input);
            ++i;
        }
        i = 0;
        while (i < process.getOutputs().size()) {
            Output output = (Output)process.getOutputs().get(i);
            profile.addOutput(output);
            ++i;
        }
        return profile;
    }

    private Grounding createGrounding(CompositeProcess process) {
        Grounding grounding = this.ont.createGrounding(this.uri("TestGrounding"));
        OWLIndividualList<Process> list = process.getComposedOf().getAllProcesses(false);
        int i = 0;
        while (i < list.size()) {
            Process pc = (Process)list.get(i);
            if (pc instanceof AtomicProcess) {
                grounding.addGrounding(((AtomicProcess)pc).getGrounding());
            }
            ++i;
        }
        return grounding;
    }

    private CompositeProcess createProcess() {
        CompositeProcess process = this.ont.createCompositeProcess(this.uri("TestProcess"));
        Input inputBookName = process.createInput(this.uri("BookName"), this.xsdString);
        Output outputBookstore = process.createOutput(this.uri("Bookstore"), this.xsdString);
        Output outputBookPrice = process.createOutput(this.uri("BookPrice"), this.Price);
        Sequence sequence = this.ont.createSequence();
        process.setComposedOf(sequence);
        Perform FindBookInfo = this.ont.createPerform(this.uri("FindBookInfo"));
        FindBookInfo.setProcess(this.BookFinder);
        FindBookInfo.addBinding(this.BookFinder.getInput(), OWLS_1_1.Process.TheParentPerform, inputBookName);
        sequence.addComponent(FindBookInfo);
        SplitJoin split = this.ont.createSplitJoin();
        Perform FindAmazonPrice = this.ont.createPerform(this.uri("FindAmazonPrice"));
        FindAmazonPrice.setProcess(this.AmazonPrice);
        FindAmazonPrice.addBinding(this.AmazonPrice.getInput(), FindBookInfo, this.BookFinder.getOutput());
        split.addComponent(FindAmazonPrice);
        Perform FindBNPrice = this.ont.createPerform(this.uri("FindBNPrice"));
        FindBNPrice.setProcess(this.BNPrice);
        FindBNPrice.addBinding(this.BNPrice.getInput(), FindBookInfo, this.BookFinder.getOutput());
        split.addComponent(FindBNPrice);
        sequence.addComponent(split);
        CompositeProcess ComparePricesProcess = this.createComparePricesProcess();
        Perform ComparePrices = this.ont.createPerform(this.uri("ComparePrices"));
        ComparePrices.setProcess(ComparePricesProcess);
        ComparePrices.addBinding(this.CP_AmazonPrice, FindAmazonPrice, this.AmazonPrice.getOutput());
        ComparePrices.addBinding(this.CP_BNPrice, FindBNPrice, this.BNPrice.getOutput());
        sequence.addComponent(ComparePrices);
        Result result = process.createResult();
        result.addBinding(outputBookstore, ComparePrices, this.CP_Bookstore);
        result.addBinding(outputBookPrice, ComparePrices, this.CP_OutputPrice);
        return process;
    }

    private CompositeProcess createComparePricesProcess() {
        CompositeProcess ComparePricesProcess = this.ont.createCompositeProcess(this.uri("ComparePricesProcess"));
        this.CP_AmazonPrice = ComparePricesProcess.createInput(this.uri("CP_AmazonPrice"), this.Price);
        this.CP_BNPrice = ComparePricesProcess.createInput(this.uri("CP_BNPrice"), this.Price);
        Local CP_AmazonPriceAmount = ComparePricesProcess.createLocal(this.uri("CP_AmazonPriceAmount"), this.xsdFloat);
        Local CP_BNPriceAmount = ComparePricesProcess.createLocal(this.uri("CP_BNPriceAmount"), this.xsdFloat);
        this.CP_OutputPrice = ComparePricesProcess.createOutput(this.uri("CP_OutputPrice"), this.Price);
        this.CP_Bookstore = ComparePricesProcess.createOutput(this.uri("CP_Bookstore"), this.xsdString);
        Condition precondition1 = this.ont.createSWRLCondition();
        DataPropertyAtom atom1 = this.swrl.createDataPropertyAtom(this.amount, this.CP_AmazonPrice, CP_AmazonPriceAmount);
        AtomList list1 = this.swrl.createList(atom1);
        precondition1.setBody(list1);
        ComparePricesProcess.addCondition(precondition1);
        Condition precondition2 = this.ont.createSWRLCondition();
        DataPropertyAtom atom2 = this.swrl.createDataPropertyAtom(this.amount, this.CP_BNPrice, CP_BNPriceAmount);
        AtomList list2 = this.swrl.createList(atom2);
        precondition2.setBody(list2);
        ComparePricesProcess.addCondition(precondition2);
        IfThenElse ifThenElse = this.ont.createIfThenElse();
        ComparePricesProcess.setComposedOf(ifThenElse);
        Condition condition = this.ont.createSWRLCondition();
        BuiltinAtom atom = this.swrl.createLessThan(CP_BNPriceAmount.castTo(SWRLDataObject.class), CP_AmazonPriceAmount.castTo(SWRLDataObject.class));
        AtomList list = this.swrl.createList(atom);
        condition.setBody(list);
        ifThenElse.setCondition(condition);
        ifThenElse.setThen(this.createProduceSequence("BN", this.CP_BNPrice));
        ifThenElse.setElse(this.createProduceSequence("Amazon", this.CP_AmazonPrice));
        return ComparePricesProcess;
    }

    private Sequence createProduceSequence(String bookstore, Input price) {
        Produce producePrice = this.ont.createProduce(this.uri("Produce" + bookstore + "Price"));
        producePrice.addBinding(this.CP_OutputPrice, OWLS_1_1.Process.TheParentPerform, price);
        Produce produceName = this.ont.createProduce(this.uri("Produce" + bookstore + "Name"));
        OutputBinding binding = this.ont.createOutputBinding();
        binding.setParameter(this.CP_Bookstore);
        ValueData valueData = this.ont.createValueData(this.ont.createDataValue(bookstore), binding);
        binding.setValue(valueData);
        produceName.addBinding(binding);
        Sequence sequence = this.ont.createSequence();
        sequence.addComponent(producePrice);
        sequence.addComponent(produceName);
        return sequence;
    }

    public void run() throws Exception {
        this.kb = OWLFactory.createKB();
        this.ont = this.kb.createOntology(null, null, true);
        this.swrl = SWRLFactoryCreator.createFactory();
        this.BookFinder = this.kb.readService(ExampleURIs.BOOK_FINDER.toString()).getProcess();
        this.BNPrice = this.kb.readService(ExampleURIs.BN_BOOK_PRICE.toString()).getProcess();
        this.AmazonPrice = this.kb.readService(ExampleURIs.AMAZON_BOOK_PRICE.toString()).getProcess();
        this.ont.addImport(this.BookFinder.getOntology());
        this.ont.addImport(this.BNPrice.getOntology());
        this.ont.addImport(this.AmazonPrice.getOntology());
        this.xsdString = this.kb.getDataType(XSD.string);
        this.xsdFloat = this.kb.getDataType(XSD.xsdFloat);
        this.Price = this.kb.getClass(URIUtils.createURI(URI.create("http://xibalba234.cs.unibas.ch:8080/owl/concepts.owl#"), "Price"));
        this.amount = this.kb.getDataProperty(URIUtils.createURI(URI.create("http://xibalba234.cs.unibas.ch:8080/owl/concepts.owl#"), "amount"));
        Service s = this.createService();
        this.ont.write(System.out, ExampleURIs.FIND_CHEAPER_BOOK);
        System.out.println();
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        exec.addMonitor(new DefaultProcessMonitor());
        Process process = s.getProcess();
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue(process.getInput(), this.kb.createDataValue("City of Glass"));
        ValueMap<Output, OWLValue> outputs = exec.execute(process, inputs, this.kb);
        String bookstore = outputs.getStringValue(process.getOutput("Bookstore"));
        OWLIndividual price = outputs.getIndividualValue(process.getOutput("BookPrice"));
        System.out.println("Cheaper price found in " + bookstore);
        System.out.println("Price is $" + price.getProperty(this.amount));
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CreateComplexProcess test = new CreateComplexProcess();
        test.run();
    }
}

