/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSequence {
    public static final URI baseURI = URI.create("http://www.example.org/BookPrice.owl#");
    OWLOntology ont;

    Service createSequenceService(List<Service> services) {
        Service service = this.ont.createService(URIUtils.createURI(baseURI, "BookService"));
        CompositeProcess process = this.ont.createCompositeProcess(URIUtils.createURI(baseURI, "BookProcess"));
        Profile profile = this.ont.createProfile(URIUtils.createURI(baseURI, "BookProfile"));
        Grounding grounding = this.ont.createGrounding(URIUtils.createURI(baseURI, "BookGrounding"));
        System.out.println(this.ont.getKB().getServices());
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        this.createSequenceProcess(process, services);
        this.createProfile(profile, process);
        OWLIndividualList<Process> list = process.getComposedOf().getAllProcesses(false);
        for (Process pc : list) {
            AtomicGrounding<?> ag;
            if (!(pc instanceof AtomicProcess) || (ag = ((AtomicProcess)pc).getGrounding()) == null) continue;
            grounding.addGrounding(ag);
        }
        profile.setLabel(this.createLabel(services));
        profile.setTextDescription(profile.getLabel());
        service.setProfile(profile);
        service.setProcess(process);
        service.setGrounding(grounding);
        return service;
    }

    String createLabel(List<Service> services) {
        String label = "[";
        int i = 0;
        while (i < services.size()) {
            Service s = services.get(i);
            if (i > 0) {
                label = String.valueOf(label) + " + ";
            }
            label = String.valueOf(label) + s.getLabel();
            ++i;
        }
        label = String.valueOf(label) + "]";
        return label;
    }

    Profile createProfile(Profile profile, Process process) {
        for (Input input : process.getInputs()) {
            profile.addInput(input);
        }
        for (Output output : process.getOutputs()) {
            profile.addOutput(output);
        }
        return profile;
    }

    CompositeProcess createSequenceProcess(CompositeProcess compositeProcess, List<Service> services) {
        boolean createOutput;
        Input input;
        Sequence sequence = this.ont.createSequence();
        compositeProcess.setComposedOf(sequence);
        Perform[] performs = new Perform[services.size()];
        int i = 0;
        while (i < services.size()) {
            Service s = services.get(i);
            Process p = s.getProcess();
            performs[i] = this.ont.createPerform();
            performs[i].setProcess(p);
            sequence.addComponent(performs[i]);
            if (i > 0) {
                Perform prevPerform = performs[i - 1];
                input = (Input)p.getInputs().get(0);
                Output output = (Output)prevPerform.getProcess().getOutputs().get(0);
                performs[i].addBinding(input, prevPerform, output);
            }
            ++i;
        }
        Perform firstPerform = performs[0];
        Perform lastPerform = performs[services.size() - 1];
        boolean createInput = firstPerform.getProcess().getInputs().size() > 0;
        boolean bl = createOutput = lastPerform.getProcess().getOutputs().size() > 0;
        if (createInput) {
            input = (Input)firstPerform.getProcess().getInputs().get(0);
            Input newInput = this.ont.createInput(URIUtils.createURI(baseURI, "TestInput"));
            newInput.setLabel(input.getLabel());
            newInput.setParamType(input.getParamType());
            newInput.setProcess(compositeProcess);
            performs[0].addBinding(input, OWLS_1_1.Process.TheParentPerform, newInput);
        }
        if (createOutput) {
            Output output = (Output)lastPerform.getProcess().getOutputs().get(0);
            Output newOutput = this.ont.createOutput(URIUtils.createURI(baseURI, "TestOutput"));
            newOutput.setLabel(output.toPrettyString());
            newOutput.setParamType(output.getParamType());
            newOutput.setProcess(compositeProcess);
            Result result = this.ont.createResult();
            result.addBinding(newOutput, lastPerform, output);
            compositeProcess.setResult(result);
        }
        return compositeProcess;
    }

    public void runTest() throws Exception {
        OWLKnowledgeBase kb = OWLFactory.createKB();
        this.ont = kb.createOntology(null, null, true);
        ProcessExecutionEngine exec = OWLSFactory.createExecutionEngine();
        Service s1 = kb.readService(ExampleURIs.BOOK_FINDER);
        Service s2 = kb.readService(ExampleURIs.BN_BOOK_PRICE);
        ArrayList<Service> services = new ArrayList<Service>();
        services.add(s1);
        services.add(s2);
        Service s = this.createSequenceService(services);
        this.ont.write(System.out, baseURI);
        System.out.println();
        Process process = s.getProcess();
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        inputs.setValue((Input)process.getInputs().get(0), kb.createDataValue("City of Glass"));
        System.out.print("Executing...");
        ValueMap<Output, OWLValue> outputs = exec.execute(process, inputs, kb);
        System.out.println("done");
        OWLIndividual outValue = outputs.getIndividualValue(process.getOutput());
        System.out.println("Book Price = ");
        System.out.println(Utils.formatRDF(outValue.toRDF(true, true)));
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CreateSequence test = new CreateSequence();
        test.runTest();
    }
}

