/*
 * Decompiled with CFR 0.152.
 */
package examples;

import examples.ExampleURIs;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLType;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.service.Service;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matchmaker {
    final OWLKnowledgeBase kb = OWLFactory.createKB();

    public Matchmaker() {
        this.kb.setReasoner("Pellet");
    }

    public void addOntology(URI ont) throws IOException {
        System.out.println("Reading " + ont);
        this.kb.read(ont);
    }

    public List<ValueMap> findServices(boolean getProducers) {
        String hasParameter = getProducers ? "process:hasOutput" : "process:hasInput";
        String queryString = "SELECT * WHERE \t   (?process rdf:type process:Process)\t   (?process " + hasParameter + " ?param)" + "USING " + "      process FOR <" + "http://www.daml.org/services/owl-s/1.1/Process.owl#" + ">";
        return this.kb.query(queryString);
    }

    public List<ValueMap> findOutputs() {
        return this.findServices(true);
    }

    public List<ValueMap> findInputs() {
        return this.findServices(false);
    }

    public int getMatchType(OWLType outputType, OWLType inputType) {
        if (outputType.isEquivalent(inputType)) {
            return 0;
        }
        if (outputType.isSubTypeOf(inputType)) {
            return 1;
        }
        if (inputType.isSubTypeOf(outputType)) {
            return 2;
        }
        return 3;
    }

    public List<Match> displayAllMatches() {
        ArrayList<Match> matches = new ArrayList<Match>();
        System.out.println("Computing matches...");
        List<ValueMap> producers = this.findOutputs();
        List<ValueMap> consumers = this.findInputs();
        for (ValueMap producer : producers) {
            Output output = producer.getIndividualValue("param").castTo(Output.class);
            OWLType outputType = output.getParamType();
            for (ValueMap consumer : consumers) {
                Input input = consumer.getIndividualValue("param").castTo(Input.class);
                OWLType inputType = input.getParamType();
                int matchType = this.getMatchType(outputType, inputType);
                if (matchType == 3) continue;
                matches.add(new Match(matchType, output, input));
            }
        }
        return matches;
    }

    public static void printIterator(Iterator<Match> i) {
        if (i.hasNext()) {
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
        System.out.println();
    }

    public void run() throws IOException {
        Matchmaker matchmaker = new Matchmaker();
        matchmaker.addOntology(ExampleURIs.BN_BOOK_PRICE);
        matchmaker.addOntology(ExampleURIs.BOOK_FINDER);
        matchmaker.addOntology(ExampleURIs.CURRENCY_CONVERTER);
        matchmaker.addOntology(ExampleURIs.DICTIONARY);
        matchmaker.addOntology(ExampleURIs.ZIP_CODE_FINDER);
        matchmaker.addOntology(ExampleURIs.FIND_LAT_LONG);
        matchmaker.addOntology(ExampleURIs.BABELFISH_TRANSLATOR);
        long time = System.currentTimeMillis();
        List<Match> matches = matchmaker.displayAllMatches();
        System.out.println();
        System.out.println("Matches:");
        Matchmaker.printIterator(matches.iterator());
        System.out.println("Computation of matches took " + (System.currentTimeMillis() - time) + "ms");
    }

    public static void main(String[] args) throws IOException {
        Matchmaker test = new Matchmaker();
        test.run();
    }

    public static class Match {
        public static final String[] MATCHES = new String[]{"EXACT", "SUBSUME", "RELAXED", "FAIL"};
        public static final int EXACT = 0;
        public static final int SUBSUME = 1;
        public static final int RELAXED = 2;
        public static final int FAIL = 3;
        int matchType;
        boolean listMatch;
        Service outputService;
        Output output;
        Service inputService;
        Input input;

        public Match(int matchType, Output output, Input input) {
            this.matchType = matchType;
            this.outputService = output.getService();
            this.output = output;
            this.inputService = input.getService();
            this.input = input;
        }

        public String toString() {
            String str = "";
            str = String.valueOf(str) + MATCHES[this.matchType] + " ";
            if (this.listMatch) {
                str = String.valueOf(str) + ".LIST";
            }
            str = String.valueOf(str) + this.outputService.getLocalName() + "." + this.output.getLocalName();
            str = String.valueOf(str) + " -> ";
            str = String.valueOf(str) + this.inputService.getLocalName() + "." + this.input.getLocalName();
            return str;
        }
    }
}

