/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.pellet.jena.PelletReasoner;
import org.mindswap.utils.URIUtils;

public class QuickTest {
    private final OWLKnowledgeBase kb = OWLFactory.createKB();

    public static void main(String[] args) {
        QuickTest test = new QuickTest();
        test.OWL2Java();
    }

    public QuickTest() {
        this.kb.setReasoner("Pellet");
        PelletReasoner r = (PelletReasoner)this.kb.getReasoner();
        r.setDerivationLogging(false);
        this.kb.getReader().getCache().setLocalCacheDirectory("e://workspaces//NExT//Ontologies//ont_cache");
        this.kb.getReader().getCache().setForced(true);
    }

    private void OWL2Java() {
        try {
            OWLOntology ont = this.kb.read(URI.create("http://www.w3.org/2001/sw/WebOnt/guide-src/wine.owl#"));
            OWLIndividual ind = ont.getIndividual(URIUtils.createURI("http://www.w3.org/2001/sw/WebOnt/guide-src/wine.owl##ChateauDeMeursaultMeursault"));
            Map<OWLProperty, List<OWLValue>> props = ind.getProperties();
            String userDir = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator");
            System.out.println(userDir);
            File javaFile = new File(String.valueOf(userDir) + "TempOWLClass.java");
            if (javaFile.exists()) {
                javaFile.delete();
            }
            javaFile.createNewFile();
            FileWriter writer = new FileWriter(javaFile);
            writer.write("public class TempOWLClass {\n");
            for (OWLProperty prop : props.keySet()) {
                String type = this.getJavaType(prop);
                String value = "";
                if (prop instanceof OWLDataProperty) {
                    value = ind.getProperty((OWLDataProperty)prop).getLexicalValue();
                }
                writer.write("public " + type + " " + prop.getLocalName() + " = " + value + ";");
            }
            writer.write("\tpublic void printIt(String it) {\n");
            writer.write("\t\tSystem.out.println(it);\n");
            writer.write("\t}\n");
            writer.write("}\n");
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getJavaType(OWLProperty prop) {
        return null;
    }
}

