/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import impl.jena.OWLConverters;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.jena.OWLReaderImpl;
import impl.jena.OWLWriterImpl;
import impl.jena.RDQLParser;
import impl.owl.CastingList;
import impl.owl.OWLIndividualListImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.OWLWriter;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.query.ABoxQueryParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaOWLFactory
implements OWLFactory.Interface {
    private final Map<String, Reasoner> reasoners = new HashMap<String, Reasoner>();
    private OWLKnowledgeBase kb;

    public JenaOWLFactory() {
        this.reasoners.put("RDFS", ReasonerRegistry.getRDFSReasoner());
        this.reasoners.put("RDFS-Simple", ReasonerRegistry.getRDFSSimpleReasoner());
        this.reasoners.put("Transitive", ReasonerRegistry.getTransitiveReasoner());
        this.reasoners.put("OWL", ReasonerRegistry.getOWLReasoner());
        this.reasoners.put("OWL-Mini", ReasonerRegistry.getOWLMiniReasoner());
        this.reasoners.put("OWL-Micro", ReasonerRegistry.getOWLMicroReasoner());
        PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.NONE;
        this.reasoners.put("Pellet", PelletReasonerFactory.theInstance().create());
    }

    public Map<String, Reasoner> getReasoners() {
        return Collections.unmodifiableMap(this.reasoners);
    }

    public Reasoner getReasoner(String reasonerName) {
        return this.reasoners.get(reasonerName);
    }

    @Override
    public OWLReader createReader() {
        return new OWLReaderImpl();
    }

    @Override
    public OWLWriter createWriter() {
        return new OWLWriterImpl();
    }

    private OWLKnowledgeBase getKB() {
        if (this.kb == null) {
            this.kb = this.createKB();
            this.kb.setAutoTranslate(false);
        }
        return this.kb;
    }

    @Override
    public OWLOntology createOntology(URI uri) {
        return this.getKB().createOntology(uri, null, true);
    }

    @Override
    public OWLKnowledgeBase createKB() {
        return new OWLKnowledgeBaseImpl();
    }

    @Override
    public <T extends OWLValue> List<T> createValueList() {
        return new ArrayList();
    }

    @Override
    public <T extends OWLIndividual> OWLIndividualList<T> createIndividualList() {
        return new OWLIndividualListImpl();
    }

    @Override
    public ABoxQueryParser createRDQLParser(OWLModel model) {
        return new RDQLParser(model);
    }

    @Override
    public void registerConverters() {
        OWLConverters.registerConverters();
    }

    @Override
    public <T extends OWLIndividual> OWLIndividualList<T> castList(OWLIndividualList<?> list, Class<T> castTarget) {
        assert (list != null && castTarget != null) : "Illegal: list and/or cast target parameter was null.";
        OWLIndividualList<T> result = this.createIndividualList();
        for (OWLIndividual individual : list) {
            OWLIndividual element = (OWLIndividual)individual.castTo(castTarget);
            result.add(element);
        }
        return result;
    }

    @Override
    public <T extends OWLIndividual> CastingList<T> wrapList(OWLIndividualList<?> list, Class<T> castTarget) {
        return new CastingList<T>(list, castTarget);
    }
}

