/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import impl.jena.OWLDataValueImpl;
import impl.owl.OWLObjectImpl;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLEntity;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.RDFS;
import org.mindswap.utils.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLEntityImpl
extends OWLObjectImpl
implements OWLEntity {
    protected final Resource resource;
    protected OWLKnowledgeBase kb;
    protected OWLOntology ontology;

    public OWLEntityImpl(OWLOntology ontology, Resource resource) {
        this.resource = resource;
        this.ontology = ontology;
        this.kb = ontology.getKB();
    }

    @Override
    public OWLKnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public boolean isAnon() {
        return this.resource.isAnon();
    }

    @Override
    public URI getURI() {
        if (this.isAnon()) {
            return null;
        }
        return URI.create(this.resource.getURI());
    }

    @Override
    public String getLocalName() {
        if (this.isAnon()) {
            return null;
        }
        return URIUtils.getLocalName(this.resource.getURI());
    }

    @Override
    public String getQName() {
        if (this.isAnon()) {
            return null;
        }
        return this.kb.getQNames().shortForm(this.resource.getURI());
    }

    @Override
    public String getNamespace() {
        return this.resource.getNameSpace();
    }

    @Override
    public String getLabel() {
        OWLDataValue value = this.getAnnotation(RDFS.label);
        return value == null ? null : value.getLexicalValue();
    }

    @Override
    public String getLabel(String lang) {
        OWLDataValue value = this.getAnnotation(RDFS.label, lang);
        return value == null ? null : value.getLexicalValue();
    }

    @Override
    public List<OWLDataValue> getLabels() {
        return this.getAnnotations(RDFS.label);
    }

    @Override
    public void setLabel(String label) {
        this.setAnnotation(RDFS.label, label);
    }

    @Override
    public void setLabel(String label, String lang) {
        this.setAnnotation(RDFS.label, label, lang);
    }

    @Override
    public OWLDataValue getAnnotation(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValue(prop);
    }

    @Override
    public List<OWLDataValue> getAnnotations(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValues(prop);
    }

    @Override
    public OWLDataValue getAnnotation(URI propURI, String lang) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        return this.getDataValue(prop, lang);
    }

    @Override
    public void addAnnotation(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.resource.addProperty(prop, (RDFNode)((Literal)value.getImplementation()));
    }

    @Override
    public void addAnnotation(URI propURI, String value) {
        this.addAnnotation(propURI, value, "");
    }

    @Override
    public void addAnnotation(URI propURI, String value, String lang) {
        this.addAnnotation(propURI, this.kb.createDataValue(value, lang));
    }

    @Override
    public void setAnnotation(URI propURI, OWLDataValue value) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.removeDataValues(prop, value.getLanguage());
        this.resource.addProperty(prop, (RDFNode)((Literal)value.getImplementation()));
    }

    @Override
    public void setAnnotation(URI propURI, String value) {
        this.setAnnotation(propURI, value, "");
    }

    @Override
    public void setAnnotation(URI propURI, String value, String lang) {
        this.setAnnotation(propURI, this.kb.createDataValue(value, lang));
    }

    protected List<OWLDataValue> getDataValues(Property prop) {
        List<OWLDataValue> list = OWLFactory.createValueList();
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            list.add(new OWLDataValueImpl(literal));
        }
        return list;
    }

    protected OWLDataValue getDataValue(Property prop) {
        OWLDataValue value = null;
        Iterator<String> it = OWLConfig.getDefaultLanguages().iterator();
        while (value == null && it.hasNext()) {
            value = this.getDataValue(prop, it.next());
        }
        return value;
    }

    protected OWLDataValue getDataValue(Property prop, String lang) {
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            if (lang == null) {
                return new OWLDataValueImpl(literal);
            }
            if (!lang.equals(literal.getLanguage())) continue;
            return new OWLDataValueImpl(literal);
        }
        return null;
    }

    protected void removeDataValues(Property prop, String lang) {
        StmtIterator i = this.resource.listProperties(prop);
        while (i.hasNext()) {
            RDFNode node = i.nextStatement().getObject();
            if (!(node instanceof Literal)) continue;
            Literal literal = (Literal)node;
            if (lang == null) {
                i.remove();
                continue;
            }
            if (!lang.equals(literal.getLanguage())) continue;
            i.remove();
        }
    }

    @Override
    public String toString() {
        URI uri = this.getURI();
        return uri == null ? "Anonymous (" + this.getAnonID() + ")" : uri.toString();
    }

    @Override
    public String toPrettyString() {
        String value = this.getLabel();
        if (value == null) {
            URI uri = this.getURI();
            value = uri == null ? "Anonymous (" + this.getAnonID() + ")" : (this.kb == null ? uri.toString() : this.kb.getQNames().shortForm(uri));
        }
        return value;
    }

    @Override
    public void removeAnnotations(URI propURI) {
        Property prop = ResourceFactory.createProperty((String)propURI.toString());
        this.resource.removeAll(prop);
    }

    public Resource getImplementation() {
        return this.resource;
    }

    @Override
    public Object getAnonID() {
        return this.resource.getId();
    }
}

