/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLObjectPropertyImpl;
import impl.jena.OWLOntologyImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLReader;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.OWLSFactory;
import org.mindswap.owls.OWLSVersionTranslator;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.utils.QNameProvider;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLKnowledgeBaseImpl
extends OWLModelImpl
implements OWLKnowledgeBase {
    private static final Logger logger = LoggerFactory.getLogger(OWLKnowledgeBaseImpl.class);
    private static final URI URN_DUMMY_ONTOLOGY = URI.create("urn:owl-s-api:baseOntology");
    protected Set<OWLOntology> ontologies;
    protected Set<OWLOntology> notImported;
    private final Map<URI, OWLOntology> uriMap;
    private final Map<OWLOntology, Set<OWLOntology>> importDependencies;
    private final QNameProvider qnames;
    private OWLReader reader;
    private boolean autoConsistency;
    private OWLSVersionTranslator translator;
    private OWLKnowledgeBase translationSource;

    public OWLKnowledgeBaseImpl() {
        super(ModelFactory.createDefaultModel());
        this.setAutoTranslate(false);
        this.setAutoConsistency(false);
        this.translationSource = this;
        this.ontologies = new HashSet<OWLOntology>();
        this.uriMap = new HashMap<URI, OWLOntology>();
        this.importDependencies = new HashMap<OWLOntology, Set<OWLOntology>>();
        this.notImported = new HashSet<OWLOntology>();
        this.reader = OWLFactory.createReader();
        this.qnames = new QNameProvider();
        Model model = this.getImplementation().getBaseModel();
        OWLOntologyImpl ontology = new OWLOntologyImpl(this, URN_DUMMY_ONTOLOGY, null, model);
        this.ontologies.add(ontology);
        this.setBaseOntology(ontology);
    }

    @Override
    public Set<OWLOntology> getOntologies(boolean all) {
        if (all) {
            return new HashSet<OWLOntology>(this.ontologies);
        }
        return new HashSet<OWLOntology>(this.notImported);
    }

    @Override
    public OWLOntology getOntology(URI uri) {
        return this.uriMap.get(uri);
    }

    @Override
    public OWLOntology createOntology(URI uri, URI fileURI, boolean load) {
        return this.createOntology(uri, fileURI, load, ModelFactory.createDefaultModel());
    }

    @Override
    public OWLOntology createOntology(URI uri, URI fileURI, boolean load, Object implementation) {
        OWLOntologyImpl ont = new OWLOntologyImpl(this, uri, fileURI, (Model)implementation);
        if (load) {
            return this.load(ont, true);
        }
        return ont;
    }

    @Override
    public OWLOntology load(OWLOntology ont, boolean withImports) {
        OWLOntology loadedOnt = this.internalLoad(ont, withImports);
        this.notImported.add(loadedOnt);
        if (this.getAutoConsistency() && !this.isConsistent()) {
            logger.warn("Rejecting to load {} because it causes the KB to be inconsistent!", (Object)ont);
            this.unload(loadedOnt);
            loadedOnt = null;
        }
        return loadedOnt;
    }

    protected OWLOntology internalLoad(OWLOntology ont, boolean withImports) {
        OWLOntology loadedOnt = ont;
        URI uri = loadedOnt.getURI();
        if (uri != null && this.uriMap.containsKey(uri)) {
            return this.uriMap.get(uri);
        }
        if (this.getAutoTranslate()) {
            loadedOnt = this.translator.translate(ont);
            if (this.translationSource == this) {
                this.translationSource = OWLFactory.createKB();
                this.translationSource.setAutoTranslate(false);
            }
            this.translationSource.load(loadedOnt.getTranslationSource(), true);
        }
        Model model = ((OntModel)loadedOnt.getImplementation()).getBaseModel();
        loadedOnt = new OWLOntologyImpl(this, uri, loadedOnt.getFileURI(), model);
        this.ontModel.addSubModel(model);
        if (uri != null) {
            this.uriMap.put(uri, loadedOnt);
        }
        this.ontologies.add(loadedOnt);
        if (withImports) {
            for (OWLOntology imported : ont.getImports(true)) {
                OWLOntology loadedImport = this.internalLoad(imported, withImports);
                loadedOnt.addImport(loadedImport);
                if (this.notImported.contains(loadedImport)) continue;
                Set<OWLOntology> importees = this.importDependencies.get(loadedImport);
                if (importees == null) {
                    importees = new HashSet<OWLOntology>();
                    this.importDependencies.put(loadedImport, importees);
                }
                importees.add(loadedOnt);
            }
        }
        return loadedOnt;
    }

    @Override
    public void unload(URI uri) {
        OWLOntology ont = this.getOntology(uri = URIUtils.standardURI(uri));
        if (ont != null) {
            this.unload(ont);
        } else {
            logger.debug("Could not unlog ontology {} because it was not found in KB.", (Object)uri);
        }
    }

    @Override
    public void unload(OWLOntology ontology) {
        URI uri = ontology.getURI();
        boolean removed = this.ontologies.remove(ontology);
        if (!removed) {
            String msg = ontology + " is not in the KB";
            if (uri != null && this.uriMap.containsKey(uri)) {
                msg = String.valueOf(msg) + " but there is another ontology with the same URI in the KB";
            }
            msg = String.valueOf(msg) + "!";
            throw new IllegalArgumentException(msg);
        }
        if (uri != null) {
            this.uriMap.remove(uri);
        }
        this.notImported.remove(ontology);
        Model m = ((OntModel)ontology.getImplementation()).getBaseModel();
        this.ontModel.removeSubModel(m);
        for (OWLOntology importOnt : ontology.getImports(true)) {
            Set<OWLOntology> importees = this.importDependencies.get(importOnt);
            if (importees == null) continue;
            importees.remove(ontology);
            if (!importees.isEmpty()) continue;
            this.importDependencies.remove(importOnt);
            this.unload(importOnt);
        }
    }

    @Override
    public OWLOntology read(String uri) throws IOException, URISyntaxException {
        return this.reader.read(this, new URI(uri));
    }

    @Override
    public OWLOntology read(URI uri) throws IOException {
        return this.reader.read(this, uri);
    }

    @Override
    public OWLOntology read(Reader in, URI baseURI) throws IOException {
        return this.reader.read((OWLKnowledgeBase)this, in, baseURI);
    }

    @Override
    public OWLOntology read(InputStream in, URI baseURI) throws IOException {
        return this.reader.read((OWLKnowledgeBase)this, in, baseURI);
    }

    @Override
    public OWLReader getReader() {
        return this.reader;
    }

    @Override
    public QNameProvider getQNames() {
        return this.qnames;
    }

    @Override
    protected OWLDataValue wrapDataValue(Literal l, OWLOntology ont) {
        return new OWLDataValueImpl(l);
    }

    @Override
    protected OWLIndividual wrapIndividual(Resource r, OWLOntology ont) {
        if (ont != null && ((OntModel)ont.getImplementation()).containsResource((RDFNode)r)) {
            return new OWLIndividualImpl(ont, r);
        }
        for (OWLOntology element : this.ontologies) {
            ont = element;
            if (!((OntModel)ont.getImplementation()).containsResource((RDFNode)r)) continue;
            return new OWLIndividualImpl(ont, r);
        }
        return new OWLIndividualImpl(this.baseOntology, r);
    }

    @Override
    protected OWLClass wrapClass(Resource r, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLClassImpl(ont, r);
    }

    @Override
    protected OWLObjectProperty wrapObjectProperty(Property p, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLObjectPropertyImpl(ont, p);
    }

    @Override
    protected OWLDataProperty wrapDataProperty(Property p, OWLOntology ont) {
        if (ont == null) {
            ont = this.baseOntology;
        }
        return new OWLDataPropertyImpl(ont, p);
    }

    @Override
    public OWLClass createClass(URI uri) {
        return this.baseOntology.createClass(uri);
    }

    @Override
    public OWLDataType createDataType(URI dataTypeURI) {
        return this.baseOntology.createDataType(dataTypeURI);
    }

    @Override
    public OWLObjectProperty createObjectProperty(URI uri) {
        return this.baseOntology.createObjectProperty(uri);
    }

    @Override
    public OWLDataProperty createDataProperty(URI uri) {
        return this.baseOntology.createDataProperty(uri);
    }

    @Override
    public OWLIndividual createIndividual(URI uri) {
        return this.baseOntology.createIndividual(uri);
    }

    @Override
    public OWLIndividual createInstance(OWLClass c) {
        return this.baseOntology.createInstance(c);
    }

    @Override
    public OWLIndividual createInstance(OWLClass c, URI uri) {
        return this.baseOntology.createInstance(c, uri);
    }

    @Override
    public OWLDataValue createDataValue(String value) {
        return this.baseOntology.createDataValue(value);
    }

    @Override
    public OWLDataValue createDataValue(String value, String language) {
        return this.baseOntology.createDataValue(value, language);
    }

    @Override
    public OWLDataValue createDataValue(Object value, URI datatypeURI) {
        return this.baseOntology.createDataValue(value, datatypeURI);
    }

    @Override
    public OWLDataValue createDataValue(Object value) {
        return this.baseOntology.createDataValue(value);
    }

    @Override
    public OWLReader setReader(OWLReader newReader) {
        OWLReader old = this.reader;
        this.reader = newReader;
        return old;
    }

    @Override
    public void refresh() {
        this.ontModel.rebind();
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    @Override
    public void removeProperties(OWLIndividual ind, OWLProperty prop) {
        this.baseOntology.removeProperties(ind, prop);
    }

    @Override
    public void removeProperty(OWLIndividual theInd, OWLProperty theProp, OWLValue theValue) {
        this.baseOntology.removeProperty(theInd, theProp, theValue);
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.baseOntology.addProperty(ind, prop, value);
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.baseOntology.setProperty(ind, prop, value);
    }

    @Override
    public void addType(OWLIndividual ind, OWLClass c) {
        this.baseOntology.addType(ind, c);
    }

    @Override
    public void removeTypes(OWLIndividual ind) {
        this.baseOntology.removeTypes(ind);
    }

    @Override
    public void removeIndividuals(OWLIndividual ind, boolean recursive) {
        this.baseOntology.removeIndividuals(ind, recursive);
    }

    @Override
    public boolean getAutoConsistency() {
        return this.autoConsistency;
    }

    @Override
    public void setAutoConsistency(boolean auto) {
        this.autoConsistency = auto;
    }

    @Override
    public boolean getAutoTranslate() {
        return this.translator != null;
    }

    @Override
    public void setAutoTranslate(boolean auto) {
        this.translator = auto ? OWLSFactory.createVersionTranslator() : null;
    }

    @Override
    public OWLKnowledgeBase getTranslationSource() {
        return this.translationSource;
    }

    @Override
    public Service readService(String uri) throws IOException, URISyntaxException {
        return this.readService(new URI(uri));
    }

    @Override
    public Service readService(URI uri) throws IOException {
        List<Service> list = this.readAllServices(uri);
        return this.getCorrectService(list, uri);
    }

    @Override
    public Service readService(Reader in, URI baseURI) throws IOException {
        List<Service> list = this.readAllServices(in, baseURI);
        return this.getCorrectService(list, baseURI);
    }

    @Override
    public Service readService(InputStream in, URI baseURI) throws IOException {
        List<Service> list = this.readAllServices(in, baseURI);
        return this.getCorrectService(list, baseURI);
    }

    @Override
    public List<Service> readAllServices(String uri) throws IOException, URISyntaxException {
        return this.readAllServices(new URI(uri));
    }

    @Override
    public List<Service> readAllServices(URI uri) throws IOException {
        OWLOntology ont = this.read(uri);
        return ont == null ? null : this.getServices();
    }

    @Override
    public List<Service> readAllServices(Reader in, URI baseURI) throws IOException {
        OWLOntology ont = this.read(in, baseURI);
        return ont == null ? null : this.getServices();
    }

    @Override
    public List<Service> readAllServices(InputStream in, URI baseURI) throws IOException {
        OWLOntology ont = this.read(in, baseURI);
        return ont == null ? null : this.getServices();
    }

    @Override
    public List<Service> getServices() {
        OWLIndividualList inds = OWLFactory.createIndividualList();
        inds.addAll(this.getInstances(OWLS_1_1.Service.Service));
        for (OWLClass serviceClass : this.getSubClasses(OWLS_1_1.Service.Service, false)) {
            inds.addAll(this.getInstances(serviceClass));
        }
        return OWLFactory.wrapList(inds, Service.class);
    }

    private Service getCorrectService(List<Service> list, URI uri) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        boolean strictSearch = false;
        String patternUri = uri.toString();
        int fragmentSignPos = uri.toString().lastIndexOf("#");
        if (fragmentSignPos > -1) {
            if (fragmentSignPos + 1 != patternUri.length()) {
                strictSearch = true;
            }
            patternUri = patternUri.substring(0, patternUri.length() - 1);
        }
        for (Service service : list) {
            if (strictSearch && service.getURI().equals(uri)) {
                return service;
            }
            if (strictSearch || service.getURI().toString().indexOf(patternUri) == -1) continue;
            return service;
        }
        return list.get(0);
    }

    @Override
    public OWLIndividual parseLiteral(String literal) {
        return this.getBaseOntology().parseLiteral(literal);
    }

    @Override
    public List<OWLIndividual> getNonLanguageIndividuals() {
        ArrayList<OWLIndividual> list = new ArrayList<OWLIndividual>();
        for (OWLOntology ont : this.ontologies) {
            list.addAll(ont.getNonLanguageIndividuals());
        }
        return list;
    }

    @Override
    public List<OWLClass> getNonLanguageClasses() {
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            list.addAll(ont.getNonLanguageClasses());
        }
        return list;
    }

    @Override
    public List<OWLDataProperty> getNonLanguageDataProperties() {
        ArrayList<OWLDataProperty> list = new ArrayList<OWLDataProperty>();
        for (OWLOntology ont : this.ontologies) {
            list.addAll(ont.getNonLanguageDataProperties());
        }
        return list;
    }

    @Override
    public List<OWLObjectProperty> getNonLanguageObjectProperties() {
        ArrayList<OWLObjectProperty> list = new ArrayList<OWLObjectProperty>();
        for (OWLOntology ont : this.ontologies) {
            list.addAll(ont.getNonLanguageObjectProperties());
        }
        return list;
    }

    @Override
    public Set<OWLClass> getClasses() {
        TreeSet<OWLClass> set = new TreeSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            set.addAll(ont.getClasses());
        }
        return set;
    }
}

