/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import impl.jena.OWLClassImpl;
import impl.jena.OWLDataPropertyImpl;
import impl.jena.OWLDataTypeImpl;
import impl.jena.OWLDataValueImpl;
import impl.jena.OWLIndividualImpl;
import impl.jena.OWLModelImpl;
import impl.jena.OWLObjectPropertyImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.owls.service.Service;
import org.mindswap.owls.vocabulary.MoreGroundings;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.owls.vocabulary.OWLS_Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyImpl
extends OWLModelImpl
implements OWLOntology {
    private static final Logger logger = LoggerFactory.getLogger(OWLOntologyImpl.class);
    private final OWLKnowledgeBase kb;
    private URI uri;
    private URI fileURI;
    private final Map<URI, OWLOntology> imports;
    private OWLOntology sourceOntology;
    private Set<String> owlsNamespaces;

    public OWLOntologyImpl(OWLKnowledgeBase kb, URI uri, URI fileURI, Model jenaModel) {
        super(jenaModel);
        super.setBaseOntology(this);
        this.uri = uri;
        this.fileURI = fileURI;
        this.kb = kb;
        this.imports = new HashMap<URI, OWLOntology>();
        this.sourceOntology = this;
    }

    @Override
    public OWLKnowledgeBase getKB() {
        return this.kb;
    }

    @Override
    public Set<OWLOntology> getImports(boolean direct) {
        if (direct) {
            return new HashSet<OWLOntology>(this.imports.values());
        }
        LinkedHashSet<OWLOntology> importsClosure = new LinkedHashSet<OWLOntology>();
        ArrayList<OWLOntology> orderedList = new ArrayList<OWLOntology>();
        orderedList.add(this);
        int i = 0;
        while (i < orderedList.size()) {
            OWLOntology ont = (OWLOntology)orderedList.get(i);
            if (!importsClosure.contains(ont)) {
                importsClosure.add(ont);
                for (OWLOntology imported : ont.getImports(direct)) {
                    if (importsClosure.contains(imported)) continue;
                    orderedList.add(imported);
                }
            }
            ++i;
        }
        return importsClosure;
    }

    @Override
    public void addImport(OWLOntology ontology) {
        URI fileUri = ontology.getFileURI();
        if (fileUri != null && !this.imports.containsKey(fileUri)) {
            this.imports.put(fileUri, ontology);
        }
    }

    @Override
    public void addImports(Set<OWLOntology> theImports) {
        for (OWLOntology aOnt : theImports) {
            this.addImport(aOnt);
        }
    }

    @Override
    public OWLClass createClass(URI classURI) {
        OWLClass c = this.getClass(classURI);
        if (c == null) {
            Resource r = this.asResource(classURI);
            this.ontModel.add(r, RDF.type, (RDFNode)OWL.Class);
            this.kb.refresh();
            c = new OWLClassImpl(this, r);
        }
        return c;
    }

    @Override
    public OWLDataType createDataType(URI dataTypeURI) {
        OWLDataType t = this.getDataType(dataTypeURI);
        if (t == null) {
            t = new OWLDataTypeImpl(this, dataTypeURI);
        }
        return t;
    }

    @Override
    public OWLObjectProperty createObjectProperty(URI objectPropertyURI) {
        OWLObjectProperty c = this.getObjectProperty(objectPropertyURI);
        if (c == null) {
            Property r = this.asProperty(objectPropertyURI);
            this.ontModel.add((Resource)r, RDF.type, (RDFNode)OWL.ObjectProperty);
            this.kb.refresh();
            c = new OWLObjectPropertyImpl((OWLOntology)this, r);
        }
        return c;
    }

    @Override
    public OWLDataProperty createDataProperty(URI targetURI) {
        OWLDataProperty c = this.getDataProperty(targetURI);
        if (c == null) {
            Property r = this.asProperty(targetURI);
            this.ontModel.add((Resource)r, RDF.type, (RDFNode)OWL.DatatypeProperty);
            this.kb.refresh();
            c = new OWLDataPropertyImpl((OWLOntology)this, r);
        }
        return c;
    }

    @Override
    public OWLIndividual createIndividual(URI targetURI) {
        OWLIndividual ind = this.getIndividual(targetURI);
        if (ind == null) {
            Resource r = this.asResource(targetURI);
            ind = new OWLIndividualImpl(this, r);
            this.kb.refresh();
        }
        return ind;
    }

    @Override
    public OWLIndividual createInstance(OWLClass c) {
        return this.createInstance(c, null);
    }

    @Override
    public OWLIndividual createInstance(OWLClass c, URI targetURI) {
        Resource r = targetURI != null ? this.asResource(targetURI) : this.ontModel.createResource();
        this.ontModel.add(r, RDF.type, (RDFNode)((Resource)c.getImplementation()));
        OWLIndividualImpl ind = new OWLIndividualImpl(this, r);
        this.kb.refresh();
        return ind;
    }

    @Override
    public OWLDataValue createDataValue(String value) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value));
    }

    @Override
    public OWLDataValue createDataValue(String value, String language) {
        return new OWLDataValueImpl(this.ontModel.createLiteral(value, language));
    }

    @Override
    public OWLDataValue createDataValue(Object value, URI datatypeURI) {
        if (org.mindswap.owl.vocabulary.RDF.XMLLiteral.equals(datatypeURI)) {
            return new OWLDataValueImpl(this.ontModel.createLiteral(value.toString(), true));
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value, datatypeURI.toString()));
    }

    @Override
    public OWLDataValue createDataValue(Object value) {
        if (value instanceof OWLDataValue) {
            return (OWLDataValue)value;
        }
        if (value instanceof URI) {
            return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value, (RDFDatatype)XSDDatatype.XSDanyURI));
        }
        return new OWLDataValueImpl(this.ontModel.createTypedLiteral(value));
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public URI getFileURI() {
        return this.fileURI;
    }

    @Override
    protected OWLDataValue wrapDataValue(Literal l, OWLOntology ont) {
        return new OWLDataValueImpl(l);
    }

    @Override
    protected OWLIndividual wrapIndividual(Resource r, OWLOntology ont) {
        return new OWLIndividualImpl(this, r);
    }

    @Override
    protected OWLClass wrapClass(Resource r, OWLOntology ont) {
        return new OWLClassImpl(this, r);
    }

    @Override
    protected OWLObjectProperty wrapObjectProperty(Property p, OWLOntology ont) {
        return new OWLObjectPropertyImpl((OWLOntology)this, p);
    }

    @Override
    protected OWLDataProperty wrapDataProperty(Property p, OWLOntology ont) {
        return new OWLDataPropertyImpl((OWLOntology)this, p);
    }

    public String toString() {
        return "Ontology(" + (this.uri == null ? "" : this.uri) + ")";
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
    }

    @Override
    public void setFileURI(URI uri) {
        this.fileURI = uri;
    }

    @Override
    public void refresh() {
        this.ontModel.rebind();
        this.kb.refresh();
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.setProperty(ind, prop, this.createDataValue(value));
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.setProperty(ind, prop, this.createDataValue(value));
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        Literal object = (Literal)value.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, null));
        this.ontModel.add(subject, predicate, (RDFNode)object);
        this.kb.refresh();
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        if (prop instanceof OWLObjectProperty && value instanceof OWLIndividual) {
            this.addProperty(ind, (OWLObjectProperty)prop, (OWLIndividual)value);
        } else if (prop instanceof OWLDataProperty && value instanceof OWLDataValue) {
            this.addProperty(ind, (OWLDataProperty)prop, (OWLDataValue)value);
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, OWLDataValue value) {
        this.ontModel.add((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)((Literal)value.getImplementation()));
        this.kb.refresh();
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, String value) {
        this.addProperty(ind, prop, this.createDataValue(value));
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLDataProperty prop, Object value) {
        this.addProperty(ind, prop, this.createDataValue(value));
    }

    @Override
    public void removeProperties(OWLIndividual ind, OWLProperty prop) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, null));
        this.kb.refresh();
    }

    @Override
    public void removeProperty(OWLIndividual ind, OWLProperty prop, OWLValue value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        RDFNode object = (RDFNode)value.getImplementation();
        Statement stmt = this.ontModel.createStatement(subject, predicate, object);
        this.ontModel.remove(stmt);
        this.refresh();
    }

    @Override
    public void addProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        this.ontModel.add((Resource)ind.getImplementation(), (Property)prop.getImplementation(), (RDFNode)((Resource)value.getImplementation()));
        this.kb.refresh();
    }

    @Override
    public void setProperty(OWLIndividual ind, OWLObjectProperty prop, OWLIndividual value) {
        Resource subject = (Resource)ind.getImplementation();
        Property predicate = (Property)prop.getImplementation();
        Resource object = (Resource)value.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, predicate, null));
        this.ontModel.add(subject, predicate, (RDFNode)object);
        this.kb.refresh();
    }

    @Override
    public void addType(OWLIndividual ind, OWLClass c) {
        this.ontModel.add((Resource)ind.getImplementation(), RDF.type, (RDFNode)((Resource)c.getImplementation()));
        this.kb.refresh();
    }

    @Override
    public void removeTypes(OWLIndividual ind) {
        Resource subject = (Resource)ind.getImplementation();
        this.ontModel.remove(this.ontModel.listStatements(subject, RDF.type, null));
        this.kb.refresh();
    }

    @Override
    public OWLOntology getTranslationSource() {
        return this.sourceOntology;
    }

    @Override
    public void setTranslationSource(OWLOntology ontology) {
        this.sourceOntology = ontology;
    }

    @Override
    public OWLIndividual parseLiteral(String literal) {
        OWLOntologyImpl ont;
        StringReader in = new StringReader(literal);
        try {
            try {
                ont = (OWLOntologyImpl)this.kb.read(in, this.uri);
            }
            catch (IOException iOException) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                return null;
            }
        }
        finally {
            try {
                ((Reader)in).close();
            }
            catch (IOException iOException) {}
        }
        OWLIndividual res = null;
        int outCount = 0;
        OWLIndividualList<?> instances = ont.getIndividuals();
        int i = 0;
        while (i < instances.size()) {
            OWLIndividual ind = (OWLIndividual)instances.get(i);
            if (ont.getIncomingProperties(ind).isEmpty()) {
                return ind;
            }
            if (res == null) {
                res = ind;
                outCount = ont.getProperties(ind).size();
            } else {
                int newCount = ont.getProperties(ind).size();
                if (newCount > outCount) {
                    res = ind;
                    outCount = newCount;
                }
            }
            ++i;
        }
        return res;
    }

    @Override
    public OWLOntology union(OWLOntology ont) {
        OWLOntology newOnt = OWLFactory.createOntology(null, false);
        newOnt.add(this);
        newOnt.add(ont);
        return newOnt;
    }

    @Override
    public void add(OWLOntology ont) {
        Model m1 = this.getImplementation().getBaseModel();
        Model m2 = ((OntModel)ont.getImplementation()).getBaseModel();
        m1.add(m2);
        this.kb.refresh();
    }

    @Override
    public List<Service> getServices() {
        if (this.kb != null) {
            return this.kb.getServices();
        }
        return super.getServices();
    }

    private void removeResourcesForOneLevel(Resource resource, boolean recursive) {
        if (recursive) {
            StmtIterator propIter = resource.listProperties();
            logger.debug("Processing resource {}", (Object)resource);
            while (propIter.hasNext()) {
                Statement stmt = propIter.nextStatement();
                logger.debug("Processing statement {}", (Object)stmt);
                if (!stmt.getObject().isResource()) continue;
                this.removeResourcesForOneLevel((Resource)stmt.getObject(), recursive);
            }
        }
        StmtIterator stmtiter = this.ontModel.listStatements(resource, null, null);
        this.ontModel.remove(stmtiter);
        stmtiter = this.ontModel.listStatements(null, null, (RDFNode)resource);
        this.ontModel.remove(stmtiter);
        if (recursive) {
            resource.removeProperties();
        }
    }

    @Override
    public void removeIndividuals(OWLIndividual ind, boolean recursive) {
        if (ind.getIncomingProperties().isEmpty()) {
            return;
        }
        Resource resource = (Resource)ind.getImplementation();
        this.removeResourcesForOneLevel(resource, recursive);
    }

    @Override
    public List<OWLIndividual> getNonLanguageIndividuals() {
        List<OWLClass> classes = this.getNonLanguageClasses();
        ArrayList<OWLIndividual> inds = new ArrayList<OWLIndividual>();
        int i = 0;
        while (i < classes.size()) {
            inds.addAll(this.getInstances(classes.get(i)));
            ++i;
        }
        return inds;
    }

    @Override
    public List<OWLClass> getNonLanguageClasses() {
        ExtendedIterator iter = this.getImplementation().listClasses();
        ArrayList<OWLClass> list = new ArrayList<OWLClass>();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (this.isInLanguageNamespace(resource)) continue;
            list.add(this.wrapClass(resource, this.getBaseOntology()));
        }
        return list;
    }

    @Override
    public List<OWLDataProperty> getNonLanguageDataProperties() {
        ExtendedIterator iter = this.getImplementation().listDatatypeProperties();
        ArrayList<OWLDataProperty> list = new ArrayList<OWLDataProperty>();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (this.isInLanguageNamespace((Resource)property)) continue;
            list.add(this.wrapDataProperty(property, this.getBaseOntology()));
        }
        return list;
    }

    @Override
    public List<OWLObjectProperty> getNonLanguageObjectProperties() {
        ExtendedIterator iter = this.getImplementation().listObjectProperties();
        ArrayList<OWLObjectProperty> list = new ArrayList<OWLObjectProperty>();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (this.isInLanguageNamespace((Resource)property)) continue;
            list.add(this.wrapObjectProperty(property, this.getBaseOntology()));
        }
        return list;
    }

    private boolean isInLanguageNamespace(Resource resource) {
        if (this.owlsNamespaces == null || this.owlsNamespaces.isEmpty()) {
            this.owlsNamespaces = new HashSet<String>();
            this.owlsNamespaces.add(OWLS_1_1.Service.Service.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.Process.Process.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.Profile.Profile.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.Grounding.WsdlGrounding.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.Expression.Expression.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.Actor.Actor.getNamespace());
            this.owlsNamespaces.add(OWLS_1_1.ObjList.List().getNamespace());
            this.owlsNamespaces.add("http://logic.stanford.edu/kif/kif.html");
            this.owlsNamespaces.add(SWRL.AtomList.getNamespace());
            this.owlsNamespaces.add(SWRLB.equal.getNamespace());
            this.owlsNamespaces.add("http://www.w3.org/2001/XMLSchema#");
            this.owlsNamespaces.add("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.owlsNamespaces.add("http://www.w3.org/2000/01/rdf-schema#");
            this.owlsNamespaces.add("http://www.w3.org/2002/07/owl#");
            this.owlsNamespaces.add("http://www.w3.org/2006/12/owl11#");
            this.owlsNamespaces.add(MoreGroundings.JavaGrounding.getNamespace());
            this.owlsNamespaces.add(OWLS_Extensions.Process.hasPerform.getNamespace());
            this.owlsNamespaces.add("http://purl.org/dc/elements/1.1.owl#");
            this.owlsNamespaces.add("http://www.isi.edu/~pan/damltime/time-entry.owl#");
            this.owlsNamespaces.add("http://www.daml.org/services/owl-s/1.1/generic/swrlx.owl#");
        }
        return this.owlsNamespaces.contains(resource.getNameSpace());
    }

    @Override
    public Set<OWLClass> getClasses() {
        return this.getAllClasses((ExtendedIterator<? extends RDFNode>)this.ontModel.listClasses(), this);
    }

    @Override
    public void removeAll(boolean includingImports) {
        this.ontModel.removeAll();
        if (includingImports) {
            for (Map.Entry<URI, OWLOntology> entry : this.imports.entrySet()) {
                entry.getValue().removeAll(includingImports);
            }
        }
    }
}

