/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import impl.jena.OWLKnowledgeBaseImpl;
import impl.owl.OWLCacheImpl;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mindswap.owl.OWLCache;
import org.mindswap.owl.OWLErrorHandler;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLReader;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLReaderImpl
implements OWLReader {
    static final Logger logger = LoggerFactory.getLogger(OWLReaderImpl.class);
    private static final Map<URI, OWLOntology> modelCache = new ConcurrentHashMap<URI, OWLOntology>();
    private static final Set<URI> defaultIgnores;
    OWLErrorHandler errHandler;
    private OWLCache cache = new OWLCacheImpl();
    private final Set<URI> ignores = new HashSet<URI>(defaultIgnores);
    private boolean ignoreFailedImport = false;

    static {
        HashSet<URI> tmp = new HashSet<URI>();
        tmp.add(URI.create(OWL.getURI()));
        tmp.add(URI.create(RDF.getURI()));
        tmp.add(URI.create(RDFS.getURI()));
        defaultIgnores = Collections.unmodifiableSet(tmp);
    }

    @Override
    public OWLCache getCache() {
        return this.cache;
    }

    @Override
    public void clear() {
        modelCache.clear();
    }

    @Override
    public OWLErrorHandler setErrorHandler(OWLErrorHandler newErrHandler) {
        OWLErrorHandler old = this.errHandler;
        this.errHandler = newErrHandler;
        return old;
    }

    @Override
    public OWLOntology read(URI uri) throws IOException {
        return this.read(OWLFactory.createKB(), uri);
    }

    @Override
    public OWLOntology read(Reader in, URI baseURI) throws IOException {
        return this.readInternal(OWLFactory.createKB(), new InputSource(in), null, baseURI);
    }

    @Override
    public OWLOntology read(InputStream in, URI baseURI) throws IOException {
        return this.readInternal(OWLFactory.createKB(), new InputSource(in), null, baseURI);
    }

    @Override
    public OWLOntology read(OWLKnowledgeBase kb, URI uri) throws IOException {
        InputSource in = this.createInputSource(uri, false);
        return this.readInternal(kb, in, uri, uri);
    }

    @Override
    public OWLOntology read(OWLKnowledgeBase kb, Reader in, URI baseURI) throws IOException {
        return this.readInternal(kb, new InputSource(in), null, baseURI);
    }

    @Override
    public OWLOntology read(OWLKnowledgeBase kb, InputStream in, URI baseURI) throws IOException {
        return this.readInternal(kb, new InputSource(in), null, baseURI);
    }

    @Override
    public Set<URI> getIgnoredOntologies() {
        return this.ignores;
    }

    @Override
    public void addIgnoredOntology(URI uri) {
        this.ignores.add(URIUtils.standardURI(uri));
    }

    @Override
    public void setCache(OWLCache cache) {
        this.cache = cache;
    }

    @Override
    public void setIgnoreFailedImport(boolean ignore) {
        this.ignoreFailedImport = ignore;
    }

    @Override
    public boolean isIgnoreFailedImport() {
        return this.ignoreFailedImport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputSource createInputSource(URI uri, boolean addToCache) throws FileNotFoundException {
        InputSource in = null;
        if (this.cache.isForced()) {
            in = this.cache.getCachedFile(uri.toString());
            if (in == null) {
                try {
                    in = new InputSource(uri.toURL().openConnection().getInputStream());
                    if (!addToCache) return in;
                    this.cache.updateCachedFile(uri);
                    return in;
                }
                catch (Exception e) {
                    String s = "Cannot read resource " + uri + ". Details: " + e;
                    logger.debug(s);
                    throw new FileNotFoundException(s);
                }
            } else {
                this.cache.updateCachedFile(uri);
            }
            return in;
        } else {
            try {
                return new InputSource(uri.toURL().openConnection().getInputStream());
            }
            catch (Exception e) {
                String s = "Cannot read resource " + uri + ". Details: " + e;
                logger.debug(s);
                in = this.cache.getCachedFile(uri.toString());
                if (in != null) return in;
                throw new FileNotFoundException(s);
            }
        }
    }

    private OWLOntology readInternal(OWLKnowledgeBase kb, InputSource in, URI physicalURI, URI baseURI) throws IOException {
        OWLOntology ont = this.readFile((OWLKnowledgeBaseImpl)kb, in, physicalURI, baseURI);
        return kb.load(ont, true);
    }

    private OWLOntology readImport(OWLKnowledgeBaseImpl kb, URI importURI) throws IOException {
        URI fileURI = importURI == null ? null : URIUtils.standardURI(importURI);
        OWLOntology ont = kb.getOntology(fileURI);
        if (ont != null) {
            logger.debug("Use already loaded ontology for the URI {}", (Object)fileURI);
            return ont;
        }
        return this.readFile(kb, this.createInputSource(importURI, true), importURI, importURI);
    }

    private OWLOntology readFile(OWLKnowledgeBaseImpl kb, InputSource in, URI physicalURI, URI baseURI) throws IOException {
        URI fileURI = physicalURI == null ? null : URIUtils.standardURI(physicalURI);
        OWLOntology ont = kb.getOntology(fileURI);
        if (ont != null) {
            logger.debug("Use already loaded ontology {} from given knowledge base.", (Object)fileURI);
        } else if (fileURI != null && (ont = modelCache.get(fileURI)) != null) {
            logger.debug("Use already loaded ontology {} from cache.", (Object)fileURI);
        } else {
            logger.debug("Reading ontology {}" + fileURI);
            String base = baseURI == null ? null : baseURI.toString();
            Model jenaModel = ModelFactory.createDefaultModel();
            RDFReader reader = jenaModel.getReader(FileUtils.guessLang((String)(fileURI != null ? fileURI.toString() : "")));
            if (this.errHandler != null) {
                reader.setErrorHandler((RDFErrorHandler)new DefaultErrorHandler());
            }
            if (in.getByteStream() != null) {
                reader.read(jenaModel, in.getByteStream(), base);
            } else {
                reader.read(jenaModel, in.getCharacterStream(), base);
            }
            ont = kb.createOntology(fileURI, fileURI, false, jenaModel);
            if (physicalURI != null) {
                modelCache.put(physicalURI, ont);
            }
            logger.debug("Check if {} has imports and start loading them (if any).", (Object)fileURI);
            StmtIterator i = jenaModel.listStatements(null, OWL.imports, null);
            while (i.hasNext()) {
                Statement stmt = i.nextStatement();
                String importFile = stmt.getResource().toString();
                try {
                    URI importURI = new URI(importFile);
                    logger.debug("Loading import {}, specified by {}", (Object)importURI, (Object)fileURI);
                    OWLOntology importOnt = this.readImport(kb, importURI);
                    ont.addImport(importOnt);
                }
                catch (URISyntaxException e) {
                    this.reportException("The import URI is invalid: " + importFile, new IOException(e.toString()));
                }
                catch (FileNotFoundException e) {
                    this.reportException("The import file " + importFile + " cannot be found.", e);
                }
            }
        }
        return ont;
    }

    private void reportException(String importFile, IOException e) throws IOException {
        logger.debug(importFile);
        if (this.ignoreFailedImport) {
            if (this.errHandler != null) {
                this.errHandler.warning(e);
            }
        } else {
            if (this.errHandler != null) {
                this.errHandler.fatal(e);
            }
            throw e;
        }
    }

    private final class DefaultErrorHandler
    implements RDFErrorHandler {
        public void warning(Exception e) {
            OWLReaderImpl.this.errHandler.warning(e);
            if (logger.isDebugEnabled()) {
                logger.debug(ParseException.formatMessage((Exception)e));
            }
        }

        public void error(Exception e) {
            OWLReaderImpl.this.errHandler.error(e);
            if (logger.isDebugEnabled()) {
                logger.debug(ParseException.formatMessage((Exception)e));
            }
        }

        public void fatalError(Exception e) {
            OWLReaderImpl.this.errHandler.fatal(e);
            if (logger.isDebugEnabled()) {
                logger.debug(ParseException.formatMessage((Exception)e));
            }
        }
    }
}

