/*
 * Decompiled with CFR 0.152.
 */
package impl.jena;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.lang.rdql.ParsedLiteral;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementFetch;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementUnsaid;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;
import com.hp.hpl.jena.vocabulary.RDF;
import impl.jena.OWLDataValueImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLDataValue;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLModel;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLProperty;
import org.mindswap.owl.vocabulary.OWL;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.query.ABoxQuery;
import org.mindswap.query.ABoxQueryParser;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataValue;
import org.mindswap.swrl.SWRLDataVariable;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLFactoryCreator;
import org.mindswap.swrl.SWRLIndividual;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLIndividualVariable;
import org.mindswap.swrl.SWRLObject;

public class RDQLParser
implements ABoxQueryParser {
    private static final String varNS = "var:";
    private final OWLModel model;

    public RDQLParser(OWLModel model) {
        this.model = model;
    }

    public ABoxQuery parse(String rdqlString) {
        OWLOntology ont = OWLFactory.createOntology(null, false);
        SWRLFactory swrl = SWRLFactoryCreator.createFactory(ont);
        ArrayList resultVars = new ArrayList();
        HashMap vars = new HashMap();
        Query rdql = QueryFactory.create((String)rdqlString, (Syntax)Syntax.syntaxRDQL);
        AtomList atomList = swrl.createList();
        Element elmnt = rdql.getQueryPattern();
        Visitor v = new Visitor(ont, swrl, vars, atomList);
        elmnt.visit((ElementVisitor)v);
        atomList = v.getAtomList();
        for (String var : rdql.getResultVars()) {
            resultVars.add(vars.get("?" + var));
        }
        return new ABoxQuery(atomList, resultVars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SWRLDataObject makeDataObject(Expression expr, OWLOntology ont) throws URISyntaxException {
        if (expr.isVariable()) {
            OWLIndividual ind = ont.createInstance(SWRL.Variable, new URI(varNS + expr.getName()));
            return ind.castTo(SWRLDataVariable.class);
        }
        if (!expr.isConstant()) throw new NotImplementedException();
        OWLDataValue value = null;
        if (expr instanceof ParsedLiteral) {
            ParsedLiteral lit = (ParsedLiteral)expr;
            if (lit.isNode()) {
                throw new NotImplementedException();
            }
            if (lit.isInt()) {
                value = ont.createDataValue(new Long(lit.getInt()));
                return value.castTo(SWRLDataValue.class);
            } else if (lit.isDouble()) {
                value = ont.createDataValue(new Double(lit.getInt()));
                return value.castTo(SWRLDataValue.class);
            } else if (lit.isBoolean()) {
                value = ont.createDataValue(lit.getBoolean() ? Boolean.TRUE : Boolean.FALSE);
                return value.castTo(SWRLDataValue.class);
            } else if (lit.isString()) {
                value = ont.createDataValue(lit.getString());
                return value.castTo(SWRLDataValue.class);
            } else {
                if (!lit.isURI()) throw new IllegalArgumentException();
                value = ont.createDataValue(URI.create(lit.getURI()));
            }
            return value.castTo(SWRLDataValue.class);
        } else {
            value = ont.createDataValue(expr.getValue());
        }
        return value.castTo(SWRLDataValue.class);
    }

    private SWRLDataObject makeDataObject(Node node, OWLOntology ont) throws URISyntaxException {
        if (node.isVariable()) {
            OWLIndividual ind = ont.createInstance(SWRL.Variable, new URI(varNS + node.getName()));
            return ind.castTo(SWRLDataVariable.class);
        }
        OWLDataValueImpl value = new OWLDataValueImpl((Literal)new LiteralImpl(node, (EnhGraph)ont.getImplementation()));
        return value.castTo(SWRLDataValue.class);
    }

    private SWRLIndividualObject makeIndividalObject(Node node, OWLOntology ont) throws URISyntaxException {
        if (node.isVariable()) {
            OWLIndividual ind = ont.createInstance(SWRL.Variable, new URI(varNS + node.getName()));
            return ind.castTo(SWRLIndividualVariable.class);
        }
        OWLIndividual ind = ont.createInstance(OWL.Thing, new URI(node.getURI()));
        return ind.castTo(SWRLIndividual.class);
    }

    final class Visitor
    implements ElementVisitor {
        private final OWLOntology ont;
        private final SWRLFactory swrl;
        private final Map vars;
        private AtomList atomList;

        Visitor(OWLOntology ont, SWRLFactory swrl, Map vars, AtomList atomList) {
            this.ont = ont;
            this.swrl = swrl;
            this.vars = vars;
            this.atomList = atomList;
        }

        AtomList getAtomList() {
            return this.atomList;
        }

        public void visit(ElementTriplesBlock elementtriplesblock) {
            BasicPattern bp = elementtriplesblock.getPattern();
            for (Triple t : bp) {
                try {
                    if (t.getPredicate().isVariable()) {
                        throw new IllegalArgumentException("Variables cannot be used in predicate position in AboxQuery");
                    }
                    Atom atom = null;
                    URI pred = new URI(t.getPredicate().getURI());
                    if (pred.toString().equals(RDF.type.getURI())) {
                        if (t.getObject().isVariable()) {
                            throw new IllegalArgumentException("Variables cannot be used as objects of rdf:type triples in ABoxQuery");
                        }
                        OWLClass c = this.ont.createClass(new URI(t.getObject().getURI()));
                        SWRLIndividualObject arg = RDQLParser.this.makeIndividalObject(t.getSubject(), this.ont);
                        atom = this.swrl.createClassAtom(c, arg);
                        this.vars.put(t.getSubject().toString(), arg);
                    } else {
                        SWRLObject arg2;
                        SWRLIndividualObject arg1;
                        OWLProperty p = RDQLParser.this.model.getProperty(pred);
                        if (p == null) {
                            throw new IllegalArgumentException(pred + " is not a known [Object|Data]Property.");
                        }
                        if (p instanceof OWLDataProperty) {
                            OWLDataProperty dp = this.ont.createDataProperty(p.getURI());
                            arg1 = RDQLParser.this.makeIndividalObject(t.getSubject(), this.ont);
                            arg2 = RDQLParser.this.makeDataObject(t.getObject(), this.ont);
                            this.vars.put(t.getSubject().toString(), arg1);
                            this.vars.put(t.getObject().toString(), arg2);
                            atom = this.swrl.createDataPropertyAtom(dp, arg1, (SWRLDataObject)arg2);
                        } else {
                            OWLObjectProperty op = this.ont.createObjectProperty(p.getURI());
                            arg1 = RDQLParser.this.makeIndividalObject(t.getSubject(), this.ont);
                            arg2 = RDQLParser.this.makeIndividalObject(t.getObject(), this.ont);
                            this.vars.put(t.getSubject().toString(), arg1);
                            this.vars.put(t.getObject().toString(), arg2);
                            atom = this.swrl.createIndividualPropertyAtom(op, arg1, (SWRLIndividualObject)arg2);
                        }
                    }
                    this.atomList = this.atomList.add(atom);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(String.valueOf(e.getInput()) + " is not a valid URI!");
                }
            }
        }

        public void visit(ElementFilter elementfilter) {
            Expr expr = elementfilter.getExpr();
        }

        public void visit(ElementUnion elementunion) {
        }

        public void visit(ElementOptional elementoptional) {
        }

        public void visit(ElementGroup elementgroup) {
            List elements = elementgroup.getElements();
            for (Element e : elements) {
                e.visit((ElementVisitor)this);
            }
        }

        public void visit(ElementDataset elementdataset) {
        }

        public void visit(ElementNamedGraph elementnamedgraph) {
        }

        public void visit(ElementUnsaid elementunsaid) {
        }

        public void visit(ElementService elementservice) {
        }

        public void visit(ElementSubQuery elementservice) {
        }

        public void visit(ElementAssign elementservice) {
        }

        public void visit(ElementFetch elementservice) {
        }

        public void visit(ElementPathBlock arg0) {
        }
    }
}

