/*
 * Decompiled with CFR 0.152.
 */
package impl.owl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.mindswap.owl.OWLCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class OWLCacheImpl
implements OWLCache {
    private static final Logger logger = LoggerFactory.getLogger(OWLCacheImpl.class);
    protected Properties cache = new Properties();
    protected String localCacheDirectory = null;
    protected boolean forced = true;
    protected boolean silent = true;

    public void setForced(boolean b) {
        this.forced = b;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setLocalCacheDirectory(String dir) {
        this.localCacheDirectory = dir;
        if (dir == null) {
            this.cache.clear();
            logger.info("Local cache directory is disabled.");
        } else {
            String indexFileName = String.valueOf(this.localCacheDirectory) + File.separator + "service.idx";
            try {
                File indexFile = new File(indexFileName);
                this.cache = new Properties();
                this.cache.load(new FileInputStream(indexFile));
                logger.info("Cache has been initialized with {} entries.", (Object)this.cache.size());
            }
            catch (FileNotFoundException e) {
                logger.error("Cache index file {} cannot be found.", (Object)indexFileName);
                this.localCacheDirectory = null;
            }
            catch (IOException e) {
                logger.error("Cache index file {} has an invalid format.", (Object)indexFileName);
                this.localCacheDirectory = null;
            }
        }
    }

    public String getLocalCacheDirectory() {
        return this.localCacheDirectory;
    }

    public InputSource getCachedFile(String fileURI) {
        InputSource in;
        block9: {
            in = null;
            if (this.cache != null) break block9;
            return null;
        }
        try {
            String localFileName;
            if (fileURI.endsWith("#")) {
                fileURI = fileURI.substring(0, fileURI.length() - 1);
            }
            if ((localFileName = this.cache.getProperty(fileURI)) != null) {
                File file = new File(localFileName);
                if (!file.exists() && this.localCacheDirectory != null) {
                    file = new File(String.valueOf(this.localCacheDirectory) + File.separator + localFileName);
                }
                if (!file.exists()) {
                    logger.warn("Cached file does not exist {}", (Object)file);
                } else {
                    if (!this.silent) {
                        logger.info("Using cached file {} for URI {}", (Object)file, (Object)fileURI);
                    }
                    in = new InputSource(new FileInputStream(file));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return in;
    }

    public void addCachedFile(String fileURI, File localFile) {
        this.cache.setProperty(fileURI, localFile.getName());
    }

    public void updateCachedFile(URI uri) {
    }

    public void updateIndexFile() {
        String indexFileName = String.valueOf(this.getLocalCacheDirectory()) + File.separator + "service.idx";
        try {
            this.cache.store(new FileOutputStream(indexFileName), "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeCachedFile(URI uri, File localFile) {
        if (localFile.exists()) {
            localFile.delete();
        }
        if (this.cache.containsKey(uri)) {
            this.cache.remove(uri);
            this.updateIndexFile();
        }
    }
}

