/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.grounding;

import com.fujitsu.fla.upnp.Action;
import com.fujitsu.fla.upnp.Argument;
import com.fujitsu.fla.upnp.ArgumentList;
import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.Device;
import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.UPnPStatus;
import impl.owls.grounding.AtomicGroundingImpl;
import java.net.URL;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.EntityFactory;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.UPnPAtomicGrounding;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.vocabulary.FLAServiceOnt;
import org.mindswap.query.ValueMap;
import org.mindswap.utils.Utils;
import org.mindswap.utils.XSLTEngine;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UPnPAtomicGroundingImpl
extends AtomicGroundingImpl<String>
implements UPnPAtomicGrounding {
    public UPnPAtomicGroundingImpl(OWLIndividual ind) {
        super(ind);
    }

    @Override
    public OWLIndividualList<? extends MessageMap<String>> getInputMap() {
        return OWLFactory.wrapList(this.getProperties(FLAServiceOnt.upnpInputMapping), MessageMap.StringMessageMap.class);
    }

    @Override
    public OWLIndividualList<? extends MessageMap<String>> getOutputMap() {
        return OWLFactory.wrapList(this.getProperties(FLAServiceOnt.upnpOutputMapping), MessageMap.StringMessageMap.class);
    }

    @Override
    public void setUPnPService(String service) {
        this.setProperty(FLAServiceOnt.upnpServiceID, service);
    }

    @Override
    public String getUPnPService() {
        return this.getPropertyAsString(FLAServiceOnt.upnpServiceID);
    }

    @Override
    public void setUPnPAction(String action) {
        this.setProperty(FLAServiceOnt.upnpCommand, action);
    }

    @Override
    public String getUPnPAction() {
        return this.getPropertyAsString(FLAServiceOnt.upnpCommand);
    }

    @Override
    public URL getDescriptionURL() {
        try {
            ControlPoint cp = new ControlPoint();
            Device device = cp.getProxyDevice(this.getUPnPDescription());
            String url = device.getPresentationURL();
            cp.stop();
            return new URL(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setUPnPDescription(String description) {
        this.setProperty(FLAServiceOnt.upnpDeviceURL, description);
    }

    @Override
    public String getUPnPDescription() {
        return this.getPropertyAsString(FLAServiceOnt.upnpDeviceURL);
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values) throws ExecutionException {
        return this.invoke(values, OWLFactory.createKB());
    }

    @Override
    public ValueMap<Output, OWLValue> invoke(ValueMap<Input, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        ControlPoint cp = new ControlPoint();
        Device device = cp.getProxyDevice(this.getUPnPDescription());
        Service service = device.getService(this.getUPnPService());
        Action action = service.getAction(this.getUPnPAction());
        ValueMap<Output, OWLValue> results = new ValueMap<Output, OWLValue>();
        OWLIndividualList<? extends MessageMap<String>> inputMapList = this.getInputMap();
        ArgumentList inArguments = action.getInputArgumentList();
        int i = 0;
        while (i < inArguments.size()) {
            Object value;
            Argument in = inArguments.getArgument(i);
            MessageMap mp = this.getMessageMap(inputMapList, in.getName());
            Input param = mp.getOWLSParameter().castTo(Input.class);
            Object inputValue = value = values.getValue(param);
            if (mp.getTransformation() != null) {
                value = XSLTEngine.transform(value.toString(), (String)mp.getTransformation());
                Node node = Utils.getAsNode(value.toString());
                inputValue = node.getFirstChild().getNodeValue();
            }
            action.setArgumentValue(mp.getGroundingParameter().toString(), inputValue.toString());
            ++i;
        }
        boolean ctrlRes = action.postControlAction();
        if (!ctrlRes) {
            UPnPStatus err = action.getControlStatus();
            throw new ExecutionException(String.valueOf(err.getDescription()) + " (" + Integer.toString(err.getCode()) + ")");
        }
        OWLIndividualList<? extends MessageMap<String>> outputMapList = this.getOutputMap();
        ArgumentList outArguments = action.getOutputArgumentList();
        int i2 = 0;
        while (i2 < outArguments.size()) {
            Argument out = outArguments.getArgument(i2);
            MessageMap mp = this.getMessageMap(outputMapList, out.getName());
            if (mp != null) {
                Output param = mp.getOWLSParameter().castTo(Output.class);
                String outputValue = null;
                outputValue = mp.getTransformation() == null ? out.getValue() : XSLTEngine.transform(out.getValue().toString(), (String)mp.getTransformation());
                if (param.getParamType().isDataType()) {
                    results.setValue(param, EntityFactory.createDataValue((Object)outputValue));
                } else {
                    results.setValue(param, kb.parseLiteral(outputValue.toString()));
                }
            }
            ++i2;
        }
        return results;
    }

    @Override
    public void addMessageMap(Parameter owlsParameter, String groundingParameter, String xsltTransformation) {
        MessageMap<String> map = this.getOntology().createUPnPMessageMap();
        map.setOWLSParameter(owlsParameter);
        map.setGroundingParameter(groundingParameter);
        if (xsltTransformation != null && xsltTransformation.length() > 0) {
            map.setTransformation(xsltTransformation);
        }
        this.addMessageMap(map);
    }

    @Override
    public String getGroundingType() {
        return "UPNP";
    }
}

