/*
 * Decompiled with CFR 0.152.
 */
package impl.owls.process.execution;

import impl.owls.process.execution.ProcessExecutionUtil;
import impl.owls.process.execution.StandardExecutionValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mindswap.exceptions.ExecutionException;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLIndividualList;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.generic.list.OWLSObjList;
import org.mindswap.owls.grounding.AtomicGrounding;
import org.mindswap.owls.process.AnyOrder;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.BagBasedControlConstruct;
import org.mindswap.owls.process.Choice;
import org.mindswap.owls.process.CompositeProcess;
import org.mindswap.owls.process.Condition;
import org.mindswap.owls.process.ControlConstruct;
import org.mindswap.owls.process.ControlConstructBag;
import org.mindswap.owls.process.ControlConstructList;
import org.mindswap.owls.process.ForEach;
import org.mindswap.owls.process.IfThenElse;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputBinding;
import org.mindswap.owls.process.Local;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputBinding;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Perform;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.Produce;
import org.mindswap.owls.process.RepeatUntil;
import org.mindswap.owls.process.RepeatWhile;
import org.mindswap.owls.process.Result;
import org.mindswap.owls.process.Sequence;
import org.mindswap.owls.process.SimpleProcess;
import org.mindswap.owls.process.Split;
import org.mindswap.owls.process.SplitJoin;
import org.mindswap.owls.process.ValueOf;
import org.mindswap.owls.process.execution.BaseExecutionContext;
import org.mindswap.owls.process.execution.ExecutionSupport;
import org.mindswap.owls.process.execution.ExecutionValidator;
import org.mindswap.owls.process.execution.ProcessExecutionEngine;
import org.mindswap.owls.process.execution.ProcessMonitor;
import org.mindswap.owls.vocabulary.OWLS_1_1;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutionEngineImpl
implements ProcessExecutionEngine,
ExecutionSupport<BaseExecutionContext> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessExecutionEngineImpl.class);
    protected final AtomicBoolean working;
    protected ExecutionValidator executionValidator = new StandardExecutionValidator();
    protected final List<ProcessMonitor> monitors = new ArrayList<ProcessMonitor>();
    protected OWLKnowledgeBase env;
    protected final Map<Perform, ValueMap<Parameter, OWLValue>> performResults = new HashMap<Perform, ValueMap<Parameter, OWLValue>>();
    protected Process process;

    public ProcessExecutionEngineImpl() {
        this.working = new AtomicBoolean(false);
    }

    @Override
    public ExecutionValidator getExecutionValidator() {
        return this.executionValidator;
    }

    @Override
    public ExecutionValidator setExecutionValidator(ExecutionValidator ev) {
        if (this.working.get()) {
            throw new IllegalStateException("Setting the execution validator is forbidden while an execution is on the way.");
        }
        ExecutionValidator previous = this.executionValidator;
        this.executionValidator = ev;
        return previous;
    }

    @Override
    public boolean addMonitor(ProcessMonitor monitor) {
        return this.monitors.add(monitor);
    }

    @Override
    public boolean removeMonitor(ProcessMonitor monitor) {
        return this.monitors.remove(monitor);
    }

    protected void executionFailed(String msg) throws ExecutionException {
        this.executionFailed(new ExecutionException(msg, this.process));
    }

    protected void executionFailed(Exception e) throws ExecutionException {
        this.executionFailed(new ExecutionException(e, this.process));
    }

    protected void executionFailed(ExecutionException e) throws ExecutionException {
        for (ProcessMonitor monitor : this.monitors) {
            monitor.executionFailed(e);
        }
        throw e;
    }

    protected boolean passFilter(ProcessMonitor monitor, Process p) {
        int processType = 7;
        processType = p instanceof AtomicProcess ? 1 : (p instanceof CompositeProcess ? 2 : 4);
        return (processType & monitor.getMonitorFilter()) != 0;
    }

    protected void executionStarted(Process p, ValueMap<Input, OWLValue> inputs) {
        for (ProcessMonitor monitor : this.monitors) {
            if (!this.passFilter(monitor, p)) continue;
            monitor.executionStarted(p, inputs);
        }
    }

    protected void executionFinished(Process p, ValueMap<Input, OWLValue> inputs, ValueMap<Output, OWLValue> outputs) {
        for (ProcessMonitor monitor : this.monitors) {
            if (!this.passFilter(monitor, p)) continue;
            monitor.executionFinished(p, inputs, outputs);
        }
    }

    protected void executionStarted() {
        for (ProcessMonitor monitor : this.monitors) {
            monitor.executionStarted();
        }
    }

    protected void executionFinished() {
        for (ProcessMonitor monitor : this.monitors) {
            monitor.executionFinished();
        }
    }

    protected void init(Process p, OWLKnowledgeBase kb) {
        this.env = kb != null ? kb : p.getKB();
        this.process = p;
        this.performResults.clear();
        this.working.set(true);
    }

    protected void cleanup() {
        this.env = null;
        this.process = null;
        this.working.set(false);
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Process p, OWLKnowledgeBase kb) throws ExecutionException {
        return this.execute(p, new ValueMap<Input, OWLValue>(), kb);
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Process p, ValueMap<Input, OWLValue> values, OWLKnowledgeBase kb) throws ExecutionException {
        this.init(p, kb);
        try {
            ValueMap<Output, OWLValue> valueMap = this.executeProcess(p, values);
            return valueMap;
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public ValueMap<Output, OWLValue> execute(Perform p, OWLKnowledgeBase kb) throws ExecutionException {
        ValueMap<Output, OWLValue> results;
        this.init(p.getProcess(), kb);
        BaseExecutionContext context = new BaseExecutionContext();
        try {
            p.execute(context, this);
            results = context.getOutputs();
            this.executionFinished(this.process, context.getInputs(), results);
        }
        finally {
            this.cleanup();
        }
        return results;
    }

    protected ValueMap<Output, OWLValue> executeProcess(Process p, ValueMap<Input, OWLValue> inputs) throws ExecutionException {
        this.executionStarted(p, inputs);
        try {
            this.executionValidator.checkPreconditions(p, inputs, this.env);
        }
        catch (ExecutionException e) {
            this.executionFailed(e);
            throw e;
        }
        BaseExecutionContext context = new BaseExecutionContext();
        context.addInputs(inputs);
        p.execute(context, this);
        ValueMap<Output, OWLValue> results = context.getOutputs();
        this.executionFinished(p, inputs, results);
        return results;
    }

    @Override
    public void executeAtomicProcess(AtomicProcess p, BaseExecutionContext context) throws ExecutionException {
        logger.debug("Executing AtomicProcess {}\nInputs: {}", (Object)p, (Object)context.getInputs().debugString());
        AtomicGrounding<?> grounding = p.getGrounding();
        if (grounding == null) {
            throw new ExecutionException("No grounding for " + p);
        }
        logger.debug("Invoking {}", (Object)grounding.getDescriptionURL());
        ValueMap<Output, OWLValue> outputs = grounding.invoke(context.getInputs(), this.env);
        context.getValues().putMap(outputs);
        this.executionValidator.checkResults(p, context.getValues(), this.env);
    }

    @Override
    public void executeCompositeProcess(CompositeProcess cp, BaseExecutionContext context) throws ExecutionException {
        ValueMap<Parameter, OWLValue> prevParentPerform = this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        this.performResults.put(OWLS_1_1.Process.TheParentPerform, context.getValues());
        cp.getComposedOf().execute(context, this);
        Result result = cp.getResult();
        if (result != null) {
            ProcessExecutionUtil.processValues(this.performResults, context.getValues(), result.getBindings());
        }
        this.performResults.put(OWLS_1_1.Process.TheParentPerform, prevParentPerform);
    }

    @Override
    public void executeSimpleProcess(SimpleProcess sp, BaseExecutionContext context) throws ExecutionException {
        throw new ExecutionException(new NotImplementedException("Executing simple processes is not implemented!"));
    }

    @Override
    public void executePerform(Perform perform, BaseExecutionContext context) throws ExecutionException {
        Process performProcess = perform.getProcess();
        if (performProcess == null) {
            this.executionFailed("Perform " + perform + " does not have a process");
        }
        ValueMap<Parameter, OWLValue> values = new ValueMap<Parameter, OWLValue>();
        ValueMap<Parameter, OWLValue> prevThisPerform = this.performResults.get(OWLS_1_1.Process.ThisPerform);
        this.performResults.put(OWLS_1_1.Process.ThisPerform, values);
        OWLIndividualList<InputBinding> bindings = perform.getBindings();
        ProcessExecutionUtil.processValues(this.performResults, values, bindings);
        BaseExecutionContext newContext = new BaseExecutionContext(values);
        performProcess.execute(newContext, this);
        this.performResults.put(perform, newContext.getValues());
        this.performResults.put(OWLS_1_1.Process.ThisPerform, prevThisPerform);
    }

    @Override
    public void executeProduce(Produce produce, BaseExecutionContext context) throws ExecutionException {
        ValueMap<Parameter, OWLValue> values = this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        OWLIndividualList<OutputBinding> bindings = produce.getBindings();
        ProcessExecutionUtil.processValues(this.performResults, values, bindings);
    }

    @Override
    public void executeSequence(Sequence seq, BaseExecutionContext context) throws ExecutionException {
        ControlConstructList ccList = seq.getComponents();
        int i = 0;
        while (i < ccList.size()) {
            ControlConstruct component = ccList.get(i);
            component.execute(context, this);
            ++i;
        }
    }

    @Override
    public void executeAnyOrder(AnyOrder ao, BaseExecutionContext context) throws ExecutionException {
        ControlConstructBag ccList = ao.getComponents();
        int i = 0;
        while (i < ccList.size()) {
            ControlConstruct component = ccList.get(i);
            component.execute(context, this);
            ++i;
        }
    }

    @Override
    public void executeChoice(Choice choice, BaseExecutionContext context) throws ExecutionException {
        ControlConstructBag ccList = choice.getComponents();
        int size = ccList.size();
        int index = new Random().nextInt(size);
        ControlConstruct component = ccList.get(index);
        component.execute(context, this);
    }

    @Override
    public void executeIfThenElse(IfThenElse ifThenElse, BaseExecutionContext context) throws ExecutionException {
        Condition ifCondition = ifThenElse.getCondition();
        ControlConstruct thenCC = ifThenElse.getThen();
        ControlConstruct elseCC = ifThenElse.getElse();
        if (this.isTrue(ifCondition)) {
            thenCC.execute(context, this);
        } else if (elseCC != null) {
            elseCC.execute(context, this);
        }
    }

    @Override
    public void executeRepeatWhile(RepeatWhile cc, BaseExecutionContext context) throws ExecutionException {
        Condition whileCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        while (this.isTrue(whileCondition)) {
            loopBody.execute(context, this);
        }
    }

    @Override
    public void executeRepeatUntil(RepeatUntil cc, BaseExecutionContext context) throws ExecutionException {
        Condition repeatCondition = cc.getCondition();
        ControlConstruct loopBody = cc.getComponent();
        do {
            loopBody.execute(context, this);
        } while (this.isTrue(repeatCondition));
    }

    @Override
    public void executeForEach(ForEach fe, BaseExecutionContext context) throws ExecutionException {
        ValueMap<Parameter, OWLValue> parentValues = this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        ControlConstruct loopBody = fe.getComponent();
        Local loopVar = fe.getLoopVar();
        ValueOf valueOf = fe.getListValue();
        Perform otherPerform = valueOf.getPerform();
        Parameter otherParam = valueOf.getParameter();
        ValueMap<Parameter, OWLValue> performResult = this.performResults.get(otherPerform);
        if (performResult == null) {
            this.executionFailed("Perform " + otherPerform + " cannot be found!");
        }
        OWLIndividual ind = performResult.getIndividualValue(otherParam);
        OWLSObjList list = ind.castTo(OWLSObjList.class);
        while (!list.isEmpty()) {
            OWLIndividual value = list.getFirst();
            parentValues.setValue(loopVar, value);
            loopBody.execute(context, this);
            list = list.getRest();
        }
    }

    @Override
    public void executeSplit(Split split, BaseExecutionContext context) throws ExecutionException {
        this.executeParallel(split, context, false);
    }

    @Override
    public void executeSplitJoin(SplitJoin split, BaseExecutionContext context) throws ExecutionException {
        this.executeParallel(split, context, true);
    }

    protected boolean isTrue(Condition condition) {
        ValueMap<Parameter, OWLValue> binding = this.performResults.get(OWLS_1_1.Process.TheParentPerform);
        return condition.isTrue(this.env, binding);
    }

    protected boolean isTrue(Condition condition, ValueMap<Parameter, OWLValue> binding) {
        return condition.isTrue(this.env, binding);
    }

    protected void executeParallel(BagBasedControlConstruct cc, BaseExecutionContext context, boolean join) throws ExecutionException {
        ControlConstructBag ccList = cc.getComponents();
        ProcessExecutionThread[] threads = new ProcessExecutionThread[ccList.size()];
        int i = 0;
        while (i < ccList.size()) {
            ControlConstruct construct = ccList.get(i);
            threads[i] = new ProcessExecutionThread(construct, context);
            logger.debug("Starting {} ...", (Object)construct);
            threads[i].start();
            ++i;
        }
        if (join) {
            HashSet<Exception> exceptions = new HashSet<Exception>();
            ProcessExecutionThread[] processExecutionThreadArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessExecutionThread element = processExecutionThreadArray[n2];
                try {
                    logger.debug("Waiting {} to finish...", (Object)element.cc);
                    element.join();
                    logger.debug("{} finished", (Object)element.cc);
                    if (element.ee != null) {
                        exceptions.add(element.ee);
                    }
                }
                catch (InterruptedException e) {
                    this.executionFailed(e);
                    exceptions.add(e);
                }
                ++n2;
            }
            if (exceptions.size() > 0) {
                throw new ExecutionException(exceptions);
            }
        }
    }

    private final class ProcessExecutionThread
    extends Thread {
        final BaseExecutionContext context;
        final ControlConstruct cc;
        ExecutionException ee;

        ProcessExecutionThread(ControlConstruct cc, BaseExecutionContext context) {
            this.cc = cc;
            this.context = context;
        }

        public void run() {
            try {
                this.cc.execute(this.context, ProcessExecutionEngineImpl.this);
            }
            catch (ExecutionException e) {
                this.ee = e;
            }
        }
    }
}

