/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.AtomImpl;
import java.util.HashSet;
import java.util.Set;
import org.mindswap.exceptions.NotImplementedException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.list.OWLList;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLObject;

public class BuiltinAtomImpl
extends AtomImpl
implements BuiltinAtom {
    private static final Set<OWLIndividual> THREE_ARGS = new HashSet<OWLIndividual>();

    static {
        THREE_ARGS.add(SWRLB.add);
        THREE_ARGS.add(SWRLB.subtract);
        THREE_ARGS.add(SWRLB.multiply);
        THREE_ARGS.add(SWRLB.divide);
    }

    public BuiltinAtomImpl(OWLIndividual ind) {
        super(ind);
    }

    public Atom apply(ValueMap binding) {
        BuiltinAtom newAtom;
        OWLIndividual builtin = this.getBuiltin();
        int argCount = this.getArgumentCount();
        SWRLDataObject[] args = new SWRLDataObject[argCount];
        int i = 0;
        while (i < argCount) {
            SWRLDataObject arg = (SWRLDataObject)this.getArgument(i);
            args[i] = this.getDataObject(arg, binding);
            ++i;
        }
        if (builtin.equals(SWRLB.equal)) {
            newAtom = this.getSWRLFactory().createEqual(args[0], args[1]);
        } else if (builtin.equals(SWRLB.notEqual)) {
            newAtom = this.getSWRLFactory().createNotEqual(args[0], args[1]);
        } else if (builtin.equals(SWRLB.greaterThan)) {
            newAtom = this.getSWRLFactory().createGreaterThan(args[0], args[1]);
        } else if (builtin.equals(SWRLB.greaterThanOrEqual)) {
            newAtom = this.getSWRLFactory().createGreaterThanOrEqual(args[0], args[1]);
        } else if (builtin.equals(SWRLB.lessThan)) {
            newAtom = this.getSWRLFactory().createLessThan(args[0], args[1]);
        } else if (builtin.equals(SWRLB.lessThanOrEqual)) {
            newAtom = this.getSWRLFactory().createLessThanOrEqual(args[0], args[1]);
        } else if (builtin.equals(SWRLB.add)) {
            newAtom = this.getSWRLFactory().createAdd(args[0], args[1], args[2]);
        } else if (builtin.equals(SWRLB.subtract)) {
            newAtom = this.getSWRLFactory().createSubtract(args[0], args[1], args[2]);
        } else {
            throw new NotImplementedException(builtin.toPrettyString());
        }
        return newAtom;
    }

    public OWLIndividual getBuiltin() {
        return this.getProperty(SWRL.builtin);
    }

    public void setBuiltin(OWLIndividual builtin) {
        this.setProperty(SWRL.builtin, builtin);
    }

    public int getArgumentCount() {
        if (THREE_ARGS.contains(this.getBuiltin())) {
            return 3;
        }
        return 2;
    }

    private OWLList getArguments() {
        OWLIndividual args = this.getProperty(SWRL.arguments);
        return args == null ? null : args.castTo(OWLList.class);
    }

    public SWRLObject getArgument(int index) {
        OWLList args = this.getArguments();
        if (args == null) {
            return null;
        }
        OWLValue arg = args.get(index);
        if (arg == null) {
            return null;
        }
        return arg.castTo(SWRLDataObject.class);
    }

    public void addArgument(SWRLObject arg) {
        if (!(arg instanceof SWRLDataObject)) {
            throw new IllegalArgumentException(String.valueOf(BuiltinAtom.class.getSimpleName()) + " argument should be a " + SWRLDataObject.class.getSimpleName());
        }
        OWLList args = this.getArguments();
        if (args == null) {
            OWLList nil = this.getOntology().createList(RDF.ListVocabulary);
            args = nil.insert(arg);
            this.setProperty(SWRL.arguments, args);
        } else {
            args.add(arg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setArgument(int index, SWRLObject arg) {
        if (!(arg instanceof SWRLDataObject)) {
            throw new IllegalArgumentException(String.valueOf(BuiltinAtom.class.getSimpleName()) + " argument should be a " + SWRLDataObject.class.getSimpleName());
        }
        OWLList args = this.getArguments();
        if (args == null) {
            if (index != 0) throw new IndexOutOfBoundsException();
            OWLList nil = this.getOntology().createList(RDF.ListVocabulary);
            args = nil.insert(arg);
            this.setProperty(SWRL.arguments, args);
            return;
        } else {
            args.set(index, arg);
        }
    }

    public String toString() {
        OWLIndividual builtin = this.getBuiltin();
        if (builtin == null) {
            return "Missing_class_predicate";
        }
        StringBuffer str = new StringBuffer();
        if (builtin.equals(SWRLB.equal)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.lessThan)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" < ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.greaterThan)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" > ");
            str.append(this.getArgument(1));
            str.append(")");
        } else if (builtin.equals(SWRLB.add)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(" + ");
            str.append(this.getArgument(2));
            str.append(")");
        } else if (builtin.equals(SWRLB.subtract)) {
            str.append("(");
            str.append(this.getArgument(0));
            str.append(" = ");
            str.append(this.getArgument(1));
            str.append(" - ");
            str.append(this.getArgument(2));
            str.append(")");
        } else {
            str.append(builtin.getLocalName()).append("(");
            int i = 0;
            while (i < this.getArgumentCount()) {
                SWRLObject arg = this.getArgument(i);
                if (i > 0) {
                    str.append(", ");
                }
                str.append(arg);
                ++i;
            }
            str.append(")");
        }
        return str.toString();
    }

    public void evaluate(ValueMap values) {
        OWLIndividual builtin = this.getBuiltin();
        if (!(SWRLB.add.equals(builtin) || SWRLB.subtract.equals(builtin) || SWRLB.multiply.equals(builtin) || SWRLB.divide.equals(builtin))) {
            return;
        }
        throw new NotImplementedException("Builtin SWRL atoms cannot be evaluated");
    }
}

