/*
 * Decompiled with CFR 0.152.
 */
package impl.swrl;

import impl.swrl.SWRLDataVariableImpl;
import impl.swrl.SWRLIndividualVariableImpl;
import java.net.URI;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLDataProperty;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLObjectProperty;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLValue;
import org.mindswap.owl.vocabulary.SWRL;
import org.mindswap.owl.vocabulary.SWRLB;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.BuiltinAtom;
import org.mindswap.swrl.ClassAtom;
import org.mindswap.swrl.DataPropertyAtom;
import org.mindswap.swrl.DifferentIndividualsAtom;
import org.mindswap.swrl.IndividualPropertyAtom;
import org.mindswap.swrl.SWRLDataObject;
import org.mindswap.swrl.SWRLDataVariable;
import org.mindswap.swrl.SWRLFactory;
import org.mindswap.swrl.SWRLIndividualObject;
import org.mindswap.swrl.SWRLIndividualVariable;
import org.mindswap.swrl.SameIndividualAtom;

public class SWRLFactoryImpl
implements SWRLFactory {
    private final OWLOntology ont;

    public SWRLFactoryImpl(OWLOntology ont) {
        this.ont = ont;
    }

    public OWLOntology getOntology() {
        return this.ont;
    }

    public AtomList createList() {
        return this.ont.createList(SWRL.AtomListVocabulary).castTo(AtomList.class);
    }

    public AtomList createList(Atom atom) {
        return this.ont.createList(SWRL.AtomListVocabulary, atom).castTo(AtomList.class);
    }

    public SWRLIndividualVariable createIndividualVariable(URI uri) {
        return new SWRLIndividualVariableImpl(this.ont.createInstance(SWRL.Variable, uri));
    }

    public SWRLDataVariable createDataVariable(URI uri) {
        return new SWRLDataVariableImpl(this.ont.createInstance(SWRL.Variable, uri));
    }

    public ClassAtom createAtom(OWLClass c, OWLIndividual arg) {
        return this.createClassAtom(c, arg.castTo(SWRLIndividualObject.class));
    }

    public ClassAtom createClassAtom(OWLClass c, OWLIndividual arg) {
        return this.createClassAtom(c, arg.castTo(SWRLIndividualObject.class));
    }

    public ClassAtom createClassAtom(OWLClass c, SWRLIndividualObject arg) {
        ClassAtom atom = this.ont.createInstance(SWRL.ClassAtom).castTo(ClassAtom.class);
        atom.setClassPredicate(c);
        atom.setArgument1(arg);
        return atom;
    }

    public IndividualPropertyAtom createAtom(OWLObjectProperty p, OWLIndividual arg1, OWLIndividual arg2) {
        return this.createIndividualPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    public IndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty p, OWLIndividual arg1, OWLIndividual arg2) {
        return this.createIndividualPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    public IndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty p, SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        IndividualPropertyAtom atom = this.ont.createInstance(SWRL.IndividualPropertyAtom).castTo(IndividualPropertyAtom.class);
        atom.setPropertyPredicate(p);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    public DataPropertyAtom createAtom(OWLDataProperty p, OWLIndividual arg1, OWLValue arg2) {
        return this.createDataPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLDataObject.class));
    }

    public DataPropertyAtom createDataPropertyAtom(OWLDataProperty p, OWLIndividual arg1, OWLValue arg2) {
        return this.createDataPropertyAtom(p, arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLDataObject.class));
    }

    public DataPropertyAtom createDataPropertyAtom(OWLDataProperty p, SWRLIndividualObject arg1, SWRLDataObject arg2) {
        DataPropertyAtom atom = this.ont.createInstance(SWRL.DatavaluedPropertyAtom).castTo(DataPropertyAtom.class);
        atom.setPropertyPredicate(p);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    public SameIndividualAtom createSameIndividualAtom(OWLIndividual arg1, OWLIndividual arg2) {
        return this.createSameIndividualAtom(arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    public SameIndividualAtom createSameIndividualAtom(SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        SameIndividualAtom atom = this.ont.createInstance(SWRL.SameIndividualAtom).castTo(SameIndividualAtom.class);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    public DifferentIndividualsAtom createDifferentIndividualsAtom(OWLIndividual arg1, OWLIndividual arg2) {
        return this.createDifferentIndividualsAtom(arg1.castTo(SWRLIndividualObject.class), arg2.castTo(SWRLIndividualObject.class));
    }

    public DifferentIndividualsAtom createDifferentIndividualsAtom(SWRLIndividualObject arg1, SWRLIndividualObject arg2) {
        DifferentIndividualsAtom atom = this.ont.createInstance(SWRL.DifferentIndividualsAtom).castTo(DifferentIndividualsAtom.class);
        atom.setArgument1(arg1);
        atom.setArgument2(arg2);
        return atom;
    }

    public BuiltinAtom createEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.equal);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createNotEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.notEqual);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createLessThan(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.lessThan);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createLessThanOrEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.lessThanOrEqual);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createGreaterThan(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.greaterThan);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createGreaterThanOrEqual(SWRLDataObject arg1, SWRLDataObject arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.greaterThanOrEqual);
        atom.setArgument(0, arg1);
        atom.setArgument(1, arg2);
        return atom;
    }

    public BuiltinAtom createAdd(OWLValue result, OWLValue arg1, OWLValue arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.add);
        atom.setArgument(0, result.castTo(SWRLDataObject.class));
        atom.setArgument(1, arg1.castTo(SWRLDataObject.class));
        atom.setArgument(2, arg2.castTo(SWRLDataObject.class));
        return atom;
    }

    public BuiltinAtom createSubtract(OWLValue result, OWLValue arg1, OWLValue arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.subtract);
        atom.setArgument(0, result.castTo(SWRLDataObject.class));
        atom.setArgument(1, arg1.castTo(SWRLDataObject.class));
        atom.setArgument(2, arg2.castTo(SWRLDataObject.class));
        return atom;
    }

    public BuiltinAtom createMultiply(OWLValue result, OWLValue arg1, OWLValue arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.multiply);
        atom.setArgument(0, result.castTo(SWRLDataObject.class));
        atom.setArgument(1, arg1.castTo(SWRLDataObject.class));
        atom.setArgument(2, arg2.castTo(SWRLDataObject.class));
        return atom;
    }

    public BuiltinAtom createDivide(OWLValue result, OWLValue arg1, OWLValue arg2) {
        BuiltinAtom atom = this.ont.createInstance(SWRL.BuiltinAtom).castTo(BuiltinAtom.class);
        atom.setBuiltin(SWRLB.divide);
        atom.setArgument(0, result.castTo(SWRLDataObject.class));
        atom.setArgument(1, arg1.castTo(SWRLDataObject.class));
        atom.setArgument(2, arg2.castTo(SWRLDataObject.class));
        return atom;
    }
}

