/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owl.vocabulary;

import impl.jena.OWLDataTypeImpl;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.mindswap.owl.OWLDataType;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.vocabulary.XSD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDataTypes {
    private static final Impl instance = new Impl();

    public static Set<OWLDataType> getDataTypes() {
        return instance.getDataTypes();
    }

    public static Map<URI, OWLDataType> getDataTypeMap() {
        return instance.getDataTypeMap();
    }

    public static OWLDataType getDataType(URI uri) {
        return instance.getDataType(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Impl
    implements Interface {
        private final Map<URI, OWLDataType> datatypes = new HashMap<URI, OWLDataType>();

        Impl() {
            OWLOntology ont = OWLFactory.createKB().getBaseOntology();
            this.datatypes.put(XSD.decimal, new OWLDataTypeImpl(ont, XSD.decimal));
            this.datatypes.put(XSD.xsdString, new OWLDataTypeImpl(ont, XSD.xsdString));
            this.datatypes.put(XSD.xsdBoolean, new OWLDataTypeImpl(ont, XSD.xsdBoolean));
            this.datatypes.put(XSD.xsdFloat, new OWLDataTypeImpl(ont, XSD.xsdFloat));
            this.datatypes.put(XSD.xsdDouble, new OWLDataTypeImpl(ont, XSD.xsdDouble));
            this.datatypes.put(XSD.dateTime, new OWLDataTypeImpl(ont, XSD.dateTime));
            this.datatypes.put(XSD.date, new OWLDataTypeImpl(ont, XSD.date));
            this.datatypes.put(XSD.time, new OWLDataTypeImpl(ont, XSD.time));
            this.datatypes.put(XSD.gYear, new OWLDataTypeImpl(ont, XSD.gYear));
            this.datatypes.put(XSD.gMonth, new OWLDataTypeImpl(ont, XSD.gMonth));
            this.datatypes.put(XSD.gDay, new OWLDataTypeImpl(ont, XSD.gDay));
            this.datatypes.put(XSD.gYearMonth, new OWLDataTypeImpl(ont, XSD.gYearMonth));
            this.datatypes.put(XSD.gMonthDay, new OWLDataTypeImpl(ont, XSD.gMonthDay));
            this.datatypes.put(XSD.duration, new OWLDataTypeImpl(ont, XSD.duration));
            this.datatypes.put(XSD.anyURI, new OWLDataTypeImpl(ont, XSD.anyURI));
            this.datatypes.put(XSD.integer, new OWLDataTypeImpl(ont, XSD.integer));
            this.datatypes.put(XSD.nonPositiveInteger, new OWLDataTypeImpl(ont, XSD.nonPositiveInteger));
            this.datatypes.put(XSD.negativeInteger, new OWLDataTypeImpl(ont, XSD.negativeInteger));
            this.datatypes.put(XSD.nonNegativeInteger, new OWLDataTypeImpl(ont, XSD.nonNegativeInteger));
            this.datatypes.put(XSD.positiveInteger, new OWLDataTypeImpl(ont, XSD.positiveInteger));
            this.datatypes.put(XSD.xsdLong, new OWLDataTypeImpl(ont, XSD.xsdLong));
            this.datatypes.put(XSD.xsdInt, new OWLDataTypeImpl(ont, XSD.xsdInt));
            this.datatypes.put(XSD.xsdShort, new OWLDataTypeImpl(ont, XSD.xsdShort));
            this.datatypes.put(XSD.xsdByte, new OWLDataTypeImpl(ont, XSD.xsdByte));
            this.datatypes.put(XSD.unsignedByte, new OWLDataTypeImpl(ont, XSD.unsignedByte));
            this.datatypes.put(XSD.unsignedShort, new OWLDataTypeImpl(ont, XSD.unsignedShort));
            this.datatypes.put(XSD.unsignedInt, new OWLDataTypeImpl(ont, XSD.unsignedInt));
            this.datatypes.put(XSD.unsignedLong, new OWLDataTypeImpl(ont, XSD.unsignedLong));
            this.datatypes.put(XSD.normalizedString, new OWLDataTypeImpl(ont, XSD.normalizedString));
            this.datatypes.put(XSD.token, new OWLDataTypeImpl(ont, XSD.token));
            this.datatypes.put(XSD.language, new OWLDataTypeImpl(ont, XSD.language));
            this.datatypes.put(XSD.NMTOKEN, new OWLDataTypeImpl(ont, XSD.NMTOKEN));
            this.datatypes.put(XSD.Name, new OWLDataTypeImpl(ont, XSD.Name));
            this.datatypes.put(XSD.NCName, new OWLDataTypeImpl(ont, XSD.NCName));
        }

        @Override
        public Set<OWLDataType> getDataTypes() {
            return new HashSet<OWLDataType>(this.datatypes.values());
        }

        @Override
        public Map<URI, OWLDataType> getDataTypeMap() {
            return Collections.unmodifiableMap(this.datatypes);
        }

        @Override
        public OWLDataType getDataType(URI uri) {
            return this.datatypes.get(uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Interface {
        public Set<OWLDataType> getDataTypes();

        public Map<URI, OWLDataType> getDataTypeMap();

        public OWLDataType getDataType(URI var1);
    }
}

