/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import java.util.Map;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseExecutionContext {
    private final ValueMap<Parameter, OWLValue> values = new ValueMap();

    public BaseExecutionContext() {
    }

    public BaseExecutionContext(ValueMap<Parameter, OWLValue> parameterValues) {
        this();
        if (parameterValues == null) {
            throw new IllegalArgumentException("Inputs map was null.");
        }
        this.values.putMap(parameterValues);
    }

    public int addInputs(ValueMap<Input, OWLValue> inputs) {
        int replaced = 0;
        for (Map.Entry<Input, OWLValue> entry : inputs) {
            if (this.values.setValue(entry.getKey(), entry.getValue()) == null) continue;
            ++replaced;
        }
        return replaced;
    }

    public int addOutputs(ValueMap<Output, OWLValue> inputs) {
        int replaced = 0;
        for (Map.Entry<Output, OWLValue> entry : inputs) {
            if (this.values.setValue(entry.getKey(), entry.getValue()) == null) continue;
            ++replaced;
        }
        return replaced;
    }

    public ValueMap<Input, OWLValue> getInputs() {
        ValueMap<Input, OWLValue> inputs = new ValueMap<Input, OWLValue>();
        for (Map.Entry<Parameter, OWLValue> entry : this.values) {
            Parameter p = entry.getKey();
            if (!(p instanceof Input)) continue;
            inputs.setValue((Input)p, entry.getValue());
        }
        return inputs;
    }

    public ValueMap<Output, OWLValue> getOutputs() {
        ValueMap<Output, OWLValue> outputs = new ValueMap<Output, OWLValue>();
        for (Map.Entry<Parameter, OWLValue> entry : this.values) {
            Parameter p = entry.getKey();
            if (!(p instanceof Output)) continue;
            outputs.setValue((Output)p, entry.getValue());
        }
        return outputs;
    }

    public ValueMap<Parameter, OWLValue> getValues() {
        return this.values;
    }
}

