/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.owls.process.execution;

import org.mindswap.exceptions.ExecutionException;
import org.mindswap.owl.OWLIndividual;
import org.mindswap.owl.OWLValue;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.Parameter;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.process.execution.AbstractMonitor;
import org.mindswap.query.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProcessMonitor
extends AbstractMonitor {
    @Override
    public void executionStarted() {
        this.out.println();
        this.out.flush();
    }

    @Override
    public void executionFinished() {
        this.out.println();
        this.out.flush();
    }

    @Override
    public void executionStarted(Process process, ValueMap<Input, OWLValue> inputs) {
        this.out.println("Start executing process " + process);
        this.out.println("Inputs: ");
        for (Input input : process.getInputs()) {
            this.out.print(String.valueOf(input.toPrettyString()) + " =  ");
            OWLValue value = inputs.getValue(input);
            if (value == null) {
                value = input.getConstantValue();
            }
            if (value == null) {
                this.out.println("<< NO VALUE >>");
                continue;
            }
            if (value.isDataValue()) {
                this.out.println(value);
                continue;
            }
            OWLIndividual ind = (OWLIndividual)value;
            if (ind.isAnon()) {
                this.out.println(ind.toRDF(false, false));
                continue;
            }
            this.out.println(value);
        }
        this.out.flush();
    }

    @Override
    public void executionFinished(Process process, ValueMap<Input, OWLValue> inputs, ValueMap<Output, OWLValue> outputs) {
        this.out.println("Execution finished for " + process);
        this.out.println("Outputs: ");
        for (Output output : process.getOutputs()) {
            this.out.print(String.valueOf(output.toPrettyString()) + " =  ");
            OWLValue value = outputs.getValue(output);
            if (value == null) {
                this.out.println("<< NO VALUE >>");
                continue;
            }
            if (value.isDataValue()) {
                this.out.println(value);
                continue;
            }
            OWLIndividual ind = (OWLIndividual)value;
            if (ind.isAnon()) {
                this.out.println(ind.toRDF(false, false));
                continue;
            }
            this.out.println(value);
        }
        this.out.flush();
    }

    @Override
    public void executionFailed(ExecutionException e) {
        this.out.println("Execution failed: ");
        this.out.println(e);
        this.out.flush();
    }

    @Override
    public void executionContinued(Process process) {
    }

    @Override
    public void executionInterrupted(Process process, AtomicProcess lastProcess) {
    }

    @Override
    public void intermediateResultsReceived(ValueMap<Parameter, OWLValue> values) {
    }
}

