/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.query.ValueMap;
import org.mindswap.swrl.Atom;
import org.mindswap.swrl.AtomList;
import org.mindswap.swrl.SWRLObject;
import org.mindswap.swrl.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ABoxQuery {
    private final AtomList body;
    private final List<Variable> resultVars;

    public ABoxQuery(AtomList body) {
        this(body, body.getVars());
    }

    public ABoxQuery(AtomList body, Collection<? extends Variable> resultVars) {
        this.body = body;
        this.resultVars = new ArrayList<Variable>(resultVars);
    }

    public void addResultVar(Variable var) {
        this.resultVars.add(var);
    }

    public void addResultVars(Collection<Variable> vars) {
        this.resultVars.addAll(vars);
    }

    public AtomList getBody() {
        return this.body;
    }

    public List<Variable> getResultVars() {
        return this.resultVars;
    }

    public List<SWRLObject> getVars() {
        ArrayList<SWRLObject> vars = new ArrayList<SWRLObject>();
        AtomList list = this.body;
        while (!list.isEmpty()) {
            Atom atom = list.getFirst();
            int j = 0;
            while (j < atom.getArgumentCount()) {
                SWRLObject term = atom.getArgument(j);
                if (term instanceof Variable) {
                    vars.add(term);
                }
                ++j;
            }
            list = list.getRest();
        }
        return vars;
    }

    public List<ValueMap> run(OWLKnowledgeBase kb) {
        return kb.query(this);
    }

    public ABoxQuery apply(ValueMap binding) {
        AtomList atoms = this.getBody().apply(binding);
        ArrayList<Variable> newResultVars = new ArrayList<Variable>(this.resultVars);
        newResultVars.removeAll(binding.getVariables());
        return new ABoxQuery(atoms, newResultVars);
    }

    public String toString() {
        return "query(" + this.getResultVars() + ") :- " + this.getBody().toString();
    }
}

