/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class ReflectionUtils {
    public static Object getCastedObjectFromStringValue(String lexicalValue, Class type) {
        String strClass = type.getName();
        Integer retVal = null;
        if ("String".equals(strClass) || "java.lang.String".equals(strClass)) {
            return lexicalValue;
        }
        if ("java.net.URL".equals(strClass)) {
            try {
                return new URL(lexicalValue);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else {
            if ("short".equals(strClass) || "java.lang.Short".equals(strClass)) {
                return new Short(lexicalValue);
            }
            if ("byte".equals(strClass) || "java.lang.Byte".equals(strClass)) {
                return new Byte(lexicalValue);
            }
            if ("int".equals(strClass) || "java.lang.Integer".equals(strClass)) {
                retVal = new Integer(lexicalValue);
            } else {
                if ("long".equals(strClass) || "java.lang.Long".equals(strClass)) {
                    return new Long(lexicalValue);
                }
                if ("float".equals(strClass) || "java.lang.Float".equals(strClass)) {
                    return new Float(lexicalValue);
                }
                if ("double".equals(strClass) || "java.lang.Double".equals(strClass)) {
                    return new Double(lexicalValue);
                }
                if ("char".equals(strClass) || "java.lang.Character".equals(strClass)) {
                    return new Character(lexicalValue.charAt(0));
                }
                if ("boolean".equals(strClass) || "java.lang.Boolean".equals(strClass)) {
                    return new Boolean(lexicalValue);
                }
            }
        }
        return retVal;
    }

    public static Class getClassFromString(String strClass) {
        Class<?> javaClass = null;
        if ("short".equals(strClass)) {
            return Short.TYPE;
        }
        if ("byte".equals(strClass)) {
            return Byte.TYPE;
        }
        if ("int".equals(strClass)) {
            return Integer.TYPE;
        }
        if ("long".equals(strClass)) {
            return Long.TYPE;
        }
        if ("float".equals(strClass)) {
            return Float.TYPE;
        }
        if ("double".equals(strClass)) {
            return Double.TYPE;
        }
        if ("char".equals(strClass)) {
            return Character.TYPE;
        }
        if ("boolean".equals(strClass)) {
            return Boolean.TYPE;
        }
        try {
            javaClass = Class.forName(strClass);
        }
        catch (Exception e) {
            javaClass = null;
        }
        return javaClass;
    }

    public static String getWrapperTypeForPrimitive(String primitive) {
        if ("short".equals(primitive)) {
            return Short.class.getName();
        }
        if ("byte".equals(primitive)) {
            return Byte.class.getName();
        }
        if ("int".equals(primitive)) {
            return Integer.class.getName();
        }
        if ("long".equals(primitive)) {
            return Long.class.getName();
        }
        if ("float".equals(primitive)) {
            return Float.class.getName();
        }
        if ("double".equals(primitive)) {
            return Double.class.getName();
        }
        if ("char".equals(primitive)) {
            return Character.class.getName();
        }
        if ("boolean".equals(primitive)) {
            return Boolean.class.getName();
        }
        return primitive;
    }

    public static Hashtable inferFieldFromGetter(Class claz) {
        Hashtable inferredFields = new Hashtable();
        Method[] methods = claz.getMethods();
        int i = 0;
        while (i < methods.length) {
            String methodName = methods[i].getName();
            if (methodName.startsWith("get")) {
                inferredFields.put(methodName.substring(3), methods[i].getReturnType());
            } else if (methodName.startsWith("set") && methods[i].getParameterTypes().length == 1) {
                inferredFields.put(methodName.substring(3), methods[i].getParameterTypes()[0]);
            }
            ++i;
        }
        return inferredFields;
    }
}

