/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.mindswap.owl.vocabulary.RDF;
import org.mindswap.utils.URIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static <K, V> K getHashtableKey(Map<K, V> map, V value) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Node getAsNode(String in) {
        try {
            DOMParser parser = new DOMParser();
            parser.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) {
                    logger.debug("XML parser warning", (Throwable)exception);
                }

                public void error(SAXParseException exception) {
                    logger.debug("XML parser error", (Throwable)exception);
                }

                public void fatalError(SAXParseException exception) {
                    logger.debug("XML parser fatal error", (Throwable)exception);
                }
            });
            parser.parse(new InputSource(new StringReader(in)));
            return parser.getDocument().getDocumentElement();
        }
        catch (Exception e) {
            logger.debug("Exception while XML parsing. Details: " + e);
            return null;
        }
    }

    public static String readURL(URL fileURL) throws IOException {
        return Utils.readAll(new InputStreamReader(fileURL.openStream()));
    }

    public static String readFile(String fileName) throws IOException {
        return Utils.readAll(new FileReader(fileName));
    }

    public static String readAll(Reader reader) throws IOException {
        int ch;
        StringBuffer buffer = new StringBuffer();
        BufferedReader in = new BufferedReader(reader);
        while ((ch = in.read()) > -1) {
            buffer.append((char)ch);
        }
        in.close();
        return buffer.toString();
    }

    public static String formatXML(Node node) {
        try {
            StringWriter out = new StringWriter();
            Document doc = node.getOwnerDocument();
            OutputFormat format = new OutputFormat(doc);
            format.setIndenting(true);
            format.setLineWidth(0);
            format.setPreserveSpace(false);
            format.setOmitXMLDeclaration(false);
            XMLSerializer serial = new XMLSerializer((Writer)out, format);
            serial.asDOMSerializer();
            serial.serialize(doc);
            return out.toString();
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Problem serializing node. Details: " + e);
            }
            return "Problem serializing node " + e;
        }
    }

    public static String formatRDF(String rdf) {
        Node node = Utils.getAsNode(rdf);
        if (node == null) {
            return rdf;
        }
        return Utils.formatNode(node, " ").substring(System.getProperty("line.separator").length());
    }

    public static String formatNode(Node node, String indent) {
        String str = "";
        short type = node.getNodeType();
        if (type == 3) {
            str = node.getNodeValue().trim();
        } else if (type == 1) {
            Node rdfResource;
            NodeList children;
            if (!(node.getParentNode() instanceof Document)) {
                str = String.valueOf(System.getProperty("line.separator")) + indent + node.getLocalName() + ": ";
            }
            int len = (children = node.getChildNodes()) != null ? children.getLength() : 0;
            int i = 0;
            while (i < len) {
                str = String.valueOf(str) + Utils.formatNode(children.item(i), String.valueOf(indent) + "  ");
                ++i;
            }
            if (len == 0 && (rdfResource = node.getAttributes().getNamedItemNS(RDF.getURI().toString(), "resource")) instanceof Attr) {
                str = String.valueOf(str) + URIUtils.getLocalName(((Attr)rdfResource).getValue());
            }
        }
        return str;
    }
}

