/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.utils;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.mindswap.owls.process.Parameter;
import org.mindswap.query.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLTEngine {
    private static final Logger logger = LoggerFactory.getLogger(XSLTEngine.class);
    static final String header = "<?xml";

    public static String transform(String input, String xsltStylesheet) {
        return XSLTEngine.transform(input, xsltStylesheet, new ValueMap());
    }

    public static String transform(String input, String xsltStylesheet, ValueMap parameters) {
        String output = null;
        try {
            StringWriter result = new StringWriter();
            if (logger.isDebugEnabled()) {
                logger.debug("Input {}", (Object)input);
                logger.debug("XSLT  {}", (Object)xsltStylesheet);
            }
            if (xsltStylesheet == null) {
                return input;
            }
            xsltStylesheet = xsltStylesheet.trim();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsltStylesheet)));
            for (Parameter param : parameters.getVariables()) {
                String value = parameters.getStringValue(param);
                transformer.setParameter(param.getLocalName(), value);
                transformer.setParameter(param.getURI().toString(), value);
            }
            transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(result));
            output = result.toString().trim();
            if (output.startsWith(header)) {
                int split = output.indexOf(62) + 1;
                output = output.substring(split);
            }
            logger.debug("Output {}", (Object)output);
        }
        catch (Exception e) {
            logger.debug("XSLT Engine cannot apply transformation {}", (Throwable)e);
        }
        return output;
    }
}

