/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.constants.Style;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.mindswap.utils.URIUtils;
import org.mindswap.utils.Utils;
import org.mindswap.wsdl.WSDLConsts;
import org.mindswap.wsdl.WSDLParameter;
import org.mindswap.wsdl.WSDLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLOperation {
    private static final Logger logger = LoggerFactory.getLogger(WSDLOperation.class);
    private WSDLService service = null;
    private Call call = null;
    private final Vector<WSDLParameter> inputs;
    private final Vector<WSDLParameter> outputs;
    private String operationName;
    private String inputMessageName;
    private String outputMessageName;
    private String portName;
    private String documentation;

    public WSDLOperation(Call c) {
        this.call = c;
        this.inputs = new Vector();
        this.outputs = new Vector();
    }

    public WSDLParameter getInput(int i) {
        return this.getInputs().elementAt(i);
    }

    public WSDLParameter getInput(String name) {
        int i = 0;
        while (i < this.inputs.size()) {
            WSDLParameter in = this.inputs.get(i);
            String paramName = in.getName();
            if (paramName.equals(name) || URIUtils.getLocalName(paramName).equals(name)) {
                return in;
            }
            ++i;
        }
        return null;
    }

    public WSDLParameter getOutput(int i) {
        return this.getOutputs().elementAt(i);
    }

    public WSDLParameter getOutput(String name) {
        int i = 0;
        while (i < this.outputs.size()) {
            WSDLParameter out = this.outputs.get(i);
            String paramName = out.getName();
            if (paramName.equals(name) || URIUtils.getLocalName(paramName).equals(name)) {
                return out;
            }
            ++i;
        }
        return null;
    }

    public Vector<WSDLParameter> getInputs() {
        return this.inputs;
    }

    public Vector<WSDLParameter> getOutputs() {
        return this.outputs;
    }

    void addInput(String name, QName type) {
        this.inputs.add(new WSDLParameter(name, type));
    }

    void addOutput(String name, QName type) {
        this.outputs.add(new WSDLParameter(name, type));
    }

    public String getName() {
        return this.call.getOperationName().getLocalPart();
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String s) {
        this.operationName = s;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String s) {
        this.portName = s;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public void setInputMessageName(String s) {
        this.inputMessageName = s;
    }

    public String getOutputMessageName() {
        return this.outputMessageName;
    }

    public void setOutputMessageName(String s) {
        this.outputMessageName = s;
    }

    public WSDLService getService() {
        return this.service;
    }

    public void setService(WSDLService s) {
        this.service = s;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String s) {
        this.documentation = s;
    }

    public String toString() {
        return this.getName();
    }

    public String getDescription() {
        WSDLParameter param;
        String s = String.valueOf(this.getName()) + "(";
        Iterator<WSDLParameter> i = this.inputs.iterator();
        while (i.hasNext()) {
            param = i.next();
            s = String.valueOf(s) + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + ") -> (";
        i = this.outputs.iterator();
        while (i.hasNext()) {
            param = i.next();
            s = String.valueOf(s) + param.getName() + ":" + param.getType().getLocalPart();
            if (!i.hasNext()) continue;
            s = String.valueOf(s) + ", ";
        }
        s = String.valueOf(s) + ")";
        return s;
    }

    public void invoke() throws AxisFault, SOAPException {
        SOAPEnvelope request = this.createRequest();
        logger.debug("Invoke operation {}", (Object)this.getDescription());
        logger.debug("Request {}", (Object)request);
        SOAPEnvelope reply = this.call.invoke(request);
        logger.debug("Reply {}", (Object)Utils.formatXML(reply));
        this.processResult(reply);
    }

    private void processResult(SOAPEnvelope reply) throws SOAPException {
        SOAPBody soapBody = reply.getBody();
        SOAPElement response = (SOAPElement)soapBody.getChildElements().next();
        Iterator messageParts = response.getChildElements();
        int i = 0;
        while (i < this.outputs.size()) {
            Iterator children;
            WSDLParameter output = this.outputs.elementAt(i);
            SOAPElement e = (SOAPElement)messageParts.next();
            output.setTextValue(e.toString());
            logger.debug("processResult {}", (Object)e);
            logger.debug("processResult.value {}", (Object)e.getValue());
            logger.debug("processResult.element node {}", (Object)(e.getNodeType() == 1 ? 1 : 0));
            logger.debug("processResult.has children? {}", (Object)e.getChildElements().hasNext());
            if (e.getChildElements().hasNext()) {
                logger.debug("processResult.first child {}", e.getChildElements().next());
            }
            if ((children = e.getChildElements()).hasNext()) {
                Node child = (Node)e.getChildElements().next();
                if (child.getNodeType() == 3) {
                    output.setValue(child.toString());
                } else {
                    output.setValue(e.toString());
                }
            } else {
                output.setValue(e.toString());
            }
            ++i;
        }
    }

    private SOAPEnvelope createRequest() throws SOAPException {
        String targetNamespace = this.call.getOperationName().getNamespaceURI();
        String opName = this.call.getOperationName().getLocalPart();
        SOAPEnvelope envelope = new SOAPEnvelope();
        logger.debug("SOAP Action = {}", (Object)this.call.getSOAPActionURI());
        logger.debug("SOAP Action used = {}", (Object)this.call.useSOAPAction());
        String inputEncodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        if ("http://schemas.xmlsoap.org/soap/encoding/" != null) {
            envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
        }
        String nsOp = this.call.getOperationStyle().equals(Style.RPC) ? "u" : "";
        SOAPBodyElement soapBody = new SOAPBodyElement(envelope.createName(opName, nsOp, targetNamespace));
        envelope.addBodyElement(soapBody);
        for (WSDLParameter param : this.inputs) {
            Object paramValue = param.getValue();
            if (paramValue == null) continue;
            SOAPElement soapElement = soapBody.addChildElement(URIUtils.getLocalName(param.getName()), "");
            if (paramValue instanceof Node) {
                logger.debug("Case 1");
                this.createSOAPElement(soapElement, (Node)paramValue);
                if (soapElement.getAttributeValue((Name)WSDLConsts.xsiType) != null) continue;
                logger.debug("Case 1a");
                soapElement.addAttribute((Name)WSDLConsts.xsiType, "u:" + param.getType().getLocalPart());
                continue;
            }
            logger.debug("Case 2 {}", (Object)param.getType());
            soapElement.addAttribute((Name)WSDLConsts.xsiType, "xsd:" + param.getType().getLocalPart());
            soapElement.addTextNode(paramValue.toString());
        }
        return envelope;
    }

    private void createSOAPElement(SOAPElement parent, Node node) throws SOAPException {
        short type = node.getNodeType();
        if (type == 3) {
            Node n;
            logger.debug("Case 3");
            String datatype = null;
            NamedNodeMap temp = node.getParentNode().getAttributes();
            if (temp != null && (n = temp.getNamedItemNS(RDF.getURI(), "datatype")) != null && (datatype = n.getNodeValue()) != null) {
                datatype = datatype.substring(datatype.indexOf("#") + 1);
            }
            if (datatype != null) {
                parent.addAttribute((Name)WSDLConsts.xsiType, "xsd:" + datatype);
            }
            parent.addTextNode(node.getNodeValue());
        } else if (type == 1) {
            SOAPElement soapElement;
            if (!(node.getParentNode() instanceof Document)) {
                logger.debug("Case 4");
                soapElement = parent.addChildElement(node.getNodeName());
            } else {
                logger.debug("Case 5");
                soapElement = parent;
            }
            NodeList children = node.getChildNodes();
            if (children != null) {
                int len = children.getLength();
                int i = 0;
                while (i < len) {
                    this.createSOAPElement(soapElement, children.item(i));
                    ++i;
                }
            }
        }
    }
}

