/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.wsdl;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owl.OWLType;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.profile.Profile;
import org.mindswap.owls.service.Service;
import org.mindswap.utils.URIUtils;
import org.mindswap.wsdl.WSDLOperation;
import org.mindswap.wsdl.WSDLParameter;

public class WSDLTranslator {
    private final Service service;
    private final Profile profile;
    private final AtomicProcess process;
    private final WSDLAtomicGrounding wsdlAtomicGrounding;
    private final OWLOntology ont = OWLFactory.createOntology(null, true);
    private final URI baseURI;

    public WSDLTranslator(WSDLOperation op, String serviceURI, String prefix) {
        this.baseURI = URIUtils.createURI(serviceURI);
        this.service = this.ont.createService(URIUtils.createURI(this.baseURI, String.valueOf(prefix) + "Service"));
        this.profile = this.ont.createProfile(URIUtils.createURI(this.baseURI, String.valueOf(prefix) + "Profile"));
        this.process = this.ont.createAtomicProcess(URIUtils.createURI(this.baseURI, String.valueOf(prefix) + "Process"));
        Grounding grounding = this.ont.createGrounding(URIUtils.createURI(this.baseURI, String.valueOf(prefix) + "Grounding"));
        this.wsdlAtomicGrounding = this.ont.createWSDLAtomicGrounding(URIUtils.createURI(this.baseURI, String.valueOf(prefix) + "AtomicProcessGrounding"));
        this.process.setLabel(this.process.getURI().getFragment());
        this.service.setProfile(this.profile);
        this.service.setProcess(this.process);
        this.service.setGrounding(grounding);
        this.wsdlAtomicGrounding.setProcess(this.process);
        this.wsdlAtomicGrounding.setOperation(URI.create(op.getOperationName()));
        this.wsdlAtomicGrounding.setWSDL(op.getService().getFileURI());
        this.wsdlAtomicGrounding.setPortType(URI.create(op.getPortName()));
        this.wsdlAtomicGrounding.setInputMessage(URI.create(op.getInputMessageName()));
        this.wsdlAtomicGrounding.setOutputMessage(URI.create(op.getOutputMessageName()));
        grounding.addGrounding(this.wsdlAtomicGrounding);
    }

    public void setServiceName(String serviceName) {
        this.profile.setServiceName(serviceName);
    }

    public void setTextDescription(String textDescription) {
        this.profile.setTextDescription(textDescription);
    }

    public void addInput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Input input = this.ont.createInput(URIUtils.createURI(this.baseURI, paramName));
        input.setLabel(paramName);
        OWLType type = this.ont.getType(paramType);
        input.setParamType(type == null ? this.ont.createClass(paramType) : type);
        this.process.addInput(input);
        this.profile.addInput(input);
        this.wsdlAtomicGrounding.addMessageMap(input, param.getName(), xsltTransformation);
    }

    public void addOutput(WSDLParameter param, String paramName, URI paramType, String xsltTransformation) {
        Output output = this.ont.createOutput(URIUtils.createURI(this.baseURI, paramName));
        output.setLabel(paramName);
        OWLType type = this.ont.getType(paramType);
        output.setParamType(type == null ? this.ont.createClass(paramType) : type);
        this.process.addOutput(output);
        this.profile.addOutput(output);
        this.wsdlAtomicGrounding.addMessageMap(output, param.getName(), xsltTransformation);
    }

    public void writeOWLS(Writer out) {
        this.ont.write(out, this.baseURI);
    }

    public void writeOWLS(OutputStream out) {
        this.ont.write(out, this.baseURI);
    }

    public Service getService() {
        return this.service;
    }
}

