/*
 * Decompiled with CFR 0.152.
 */
package SME2Plugin;

import SME2Plugin.S3Matchmaker;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.IStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Pair;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MyS3Matchmaker
extends S3Matchmaker {
    private static Logger logger = Logger.getLogger(MyS3Matchmaker.class);

    public IStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(IStrategy strategy) {
        this.strategy = strategy;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Hashtable<URL, Vector<Pair>> myQuery(URL queryURL) {
        Hashtable<URL, Vector<Pair>> results = new Hashtable<URL, Vector<Pair>>();
        File file = new File(queryURL.getFile());
        if (queryURL.getProtocol().equals("http")) {
            try {
                InputStream in = queryURL.openStream();
                this.myMatchmake(in, results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.isFile()) {
            InputStream in = FileManager.get().open(file.toString());
            this.myMatchmake(in, results);
        } else {
            String[] files = file.list(this.filter);
            if (files == null) {
                logger.error((Object)("Error on readig " + file + " Aborting..."));
                System.exit(0);
            }
            int i = 0;
            while (i < files.length) {
                logger.debug((Object)("Read " + file + "/" + files[i]));
                InputStream in = FileManager.get().open(file + "/" + files[i]);
                this.myMatchmake(in, results);
                ++i;
            }
        }
        return results;
    }

    protected void myMatchmake(InputStream in, Hashtable<URL, Vector<Pair>> results) {
        Model queryModel = this.getQueryModel(in);
        String realQueryURL = this.getQueryURL(queryModel);
        ResultSet rs = this.getResults(queryModel, realQueryURL, this.strategy);
        Vector<Pair> thisResults = this.transformResults2(rs);
        try {
            results.put(new URL(realQueryURL), thisResults);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected Vector<Pair> transformResults2(ResultSet rs) {
        Vector<Pair> results = new Vector<Pair>();
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            RDFNode service = rb.get("service");
            RDFNode sim = rb.get("sim");
            if (service.isURIResource()) {
                Resource res = (Resource)service;
                if (sim.isLiteral()) {
                    Literal l = (Literal)sim;
                    Pair pair = null;
                    try {
                        pair = new Pair(new URL(res.getURI()), String.valueOf(l.getDouble()));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    results.add(pair);
                    continue;
                }
                Pair pair = null;
                try {
                    pair = new Pair(new URL(res.getURI()), sim.toString());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                results.add(pair);
                continue;
            }
            Pair pair = null;
            try {
                pair = new Pair(new URL("http://error.html"), "0");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            results.add(pair);
        }
        return results;
    }

    protected void printResults(Hashtable<URL, Vector<URL>> results) {
        System.out.println("Custom printing results...");
        Set<Map.Entry<URL, Vector<URL>>> entrySet = results.entrySet();
        for (Map.Entry<URL, Vector<URL>> entry : entrySet) {
            for (URL url : entry.getValue()) {
                System.out.println(entry.getKey() + " " + url);
            }
        }
    }
}

