/*
 * Decompiled with CFR 0.152.
 */
package SME2Plugin;

import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.AbstractStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.IStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.impl.owlstc.simpack.SemanticInOutSatisfyJaccardStrategy;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import simpack.measure.weightingscheme.StringTFIDF;

public class SemanticSatisfactionMatchmaker
implements IMatchmakerPlugin {
    public static StringTFIDF TFIDF;
    protected Model model = ModelFactory.createDefaultModel();
    protected IStrategy strategy = new SemanticInOutSatisfyJaccardStrategy();
    protected FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".owls");
        }
    };
    protected String queryStringQueryURL = String.valueOf(AbstractStrategy.prolog) + AbstractStrategy.NL + "SELECT ?service WHERE { ?service rdf:type service:Service }";
    protected String corpusFile = "OWLSTCv2_Corpus.ser";
    private static Logger logger;

    static {
        logger = Logger.getLogger(SemanticSatisfactionMatchmaker.class);
    }

    public SemanticSatisfactionMatchmaker() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(this.corpusFile));
            ArrayList corpus = (ArrayList)in.readObject();
            in.close();
            TFIDF = new StringTFIDF((List)corpus);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void input(URL serviceURL) {
        this.model = this.getService(serviceURL);
    }

    public Hashtable<URL, Vector<URL>> query(URL queryURL) {
        Hashtable<URL, Vector<URL>> results = new Hashtable<URL, Vector<URL>>();
        File file = new File(queryURL.getFile());
        if (queryURL.getProtocol().equals("http")) {
            try {
                InputStream in = queryURL.openStream();
                this.matchmake(in, results);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.isFile()) {
            InputStream in = FileManager.get().open(file.toString());
            this.matchmake(in, results);
        } else {
            String[] files = file.list(this.filter);
            if (files == null) {
                logger.error((Object)("Error on readig " + file + " Aborting..."));
                System.exit(0);
            }
            int i = 0;
            while (i < files.length) {
                logger.debug((Object)("Read " + file + "/" + files[i]));
                InputStream in = FileManager.get().open(file + "/" + files[i]);
                this.matchmake(in, results);
                ++i;
            }
        }
        return results;
    }

    protected void matchmake(InputStream in, Hashtable<URL, Vector<URL>> results) {
        Model queryModel = this.getQueryModel(in);
        String realQueryURL = this.getQueryURL(queryModel);
        ResultSet rs = this.getResults(queryModel, realQueryURL, this.strategy);
        Vector<URL> thisResults = this.transformResults(rs);
        try {
            results.put(new URL(realQueryURL), thisResults);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    protected ResultSet getResults(Model queryModel, String queryURL, IStrategy strategy) {
        String queryString = strategy.getStrategy().replaceAll("<<<queryURL>>>", "<" + queryURL + ">");
        System.out.println(queryString);
        logger.debug((Object)queryString);
        Query query = QueryFactory.create((String)queryString);
        System.out.println(query.toString());
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
            System.out.println();
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)this.model);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)qexec.execSelect());
        qexec.close();
        if (logger.isDebugEnabled()) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs, (Query)query);
            System.out.println("Size of result set: " + ResultSetFormatter.consume((ResultSet)rs));
        }
        return rs;
    }

    protected Model getService(URL serviceURL) {
        InputStream in = null;
        File file = new File(serviceURL.getFile());
        if (serviceURL.getProtocol().equals("http")) {
            try {
                in = serviceURL.openStream();
                this.model.read(in, "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (file.isFile()) {
                in = FileManager.get().open(file.toString());
                this.model.read(in, "");
            } else {
                String[] files = file.list(this.filter);
                if (files == null) {
                    logger.error((Object)("Error on readig " + file + " Aborting..."));
                    System.exit(0);
                }
                int i = 0;
                while (i < files.length) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("[ADD] " + (i + 1) + "/" + files.length + " " + file + "/" + files[i]);
                    }
                    in = FileManager.get().open(file + "/" + files[i]);
                    this.model.read(in, "");
                    ++i;
                }
            }
            if (logger.isDebugEnabled()) {
                this.model.write((OutputStream)System.out);
            }
        }
        return this.model;
    }

    protected String getQueryURL(Model queryModel) {
        RDFNode queryNode = null;
        Resource queryResource = null;
        String queryString = this.queryStringQueryURL;
        Query query = QueryFactory.create((String)queryString);
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
            System.out.println();
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)queryModel);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            queryNode = rb.get("service");
            if (!queryNode.canAs(Resource.class)) continue;
            queryResource = (Resource)queryNode;
        }
        qexec.close();
        String queryResourceURI = queryResource.getURI().replaceAll("queries", "services");
        return queryResourceURI;
    }

    protected Model getQueryModel(InputStream in) {
        Model queryModel = ModelFactory.createDefaultModel();
        queryModel.read(in, "");
        return queryModel;
    }

    protected Vector<URL> transformResults(ResultSet rs) {
        Vector<URL> results = new Vector<URL>();
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            RDFNode service = rb.get("service");
            if (service.canAs(Resource.class)) {
                Resource res = (Resource)service;
                try {
                    results.add(new URL(res.getURI()));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                results.add(new URL("http://error.html"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return results;
    }
}

