/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Utils;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.util.FileManager;
import com.wcohen.ss.BasicStringWrapper;
import com.wcohen.ss.api.StringWrapper;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import simpack.util.corpus.StringUtils;

public class MITPHv1Corpus {
    private static Model model = ModelFactory.createDefaultModel();
    private static String qstr = "PREFIX ph: <http://www.ifi.unizh.ch/ddis/ph/2006/08/ProcessHandbook.owl#> PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  SELECT ?process ?name ?description WHERE { ?process rdf:type ph:Process . ?process ph:name ?name . ?process ph:description ?description . }";
    private static String inFileName = String.valueOf(Utils.userDir) + Utils.separator + "mitph-ontology-relevant_docs.owl";
    private static String outFileName = String.valueOf(Utils.userDir) + Utils.separator + "MITPHv1_Corpus-relevant_docs.ser";
    private static ArrayList<StringWrapper> corpus = new ArrayList();

    public static String clean(String textDescription) {
        Object a;
        int n;
        int n2;
        Object[] objectArray;
        if (textDescription.equals("")) {
            return textDescription;
        }
        textDescription = textDescription.toLowerCase();
        textDescription = textDescription.replaceAll("\\w+=\\w+(\\.\\w+)?", "");
        textDescription = textDescription.replaceAll("\\p{Punct}+", " ");
        String REAL_NUMBER = "\\d+";
        textDescription = textDescription.replaceAll(REAL_NUMBER, "");
        textDescription = textDescription.replaceAll("top", "");
        textDescription = textDescription.replaceAll("arial", "");
        textDescription = textDescription.replaceAll("htm", "");
        textDescription = textDescription.replaceAll("nbsp", "");
        HTML.Tag[] tags = HTML.getAllTags();
        CSS.Attribute[] cssAttributes = CSS.getAllAttributeKeys();
        HTML.Attribute[] htmlAttributes = HTML.getAllAttributeKeys();
        String[] items = textDescription.split("\\s+");
        int i = 0;
        while (i < items.length) {
            objectArray = tags;
            n2 = tags.length;
            n = 0;
            while (n < n2) {
                Object t = objectArray[n];
                if (items[i].equals(((HTML.Tag)t).toString())) {
                    items[i] = "";
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            objectArray = htmlAttributes;
            n2 = htmlAttributes.length;
            n = 0;
            while (n < n2) {
                a = objectArray[n];
                if (items[i].equals(((HTML.Attribute)a).toString())) {
                    items[i] = "";
                }
                ++n;
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            objectArray = cssAttributes;
            n2 = cssAttributes.length;
            n = 0;
            while (n < n2) {
                a = objectArray[n];
                if (items[i].equals(((CSS.Attribute)a).toString())) {
                    items[i] = "";
                }
                ++n;
            }
            ++i;
        }
        textDescription = "";
        String[] stringArray = items;
        n = items.length;
        int n3 = 0;
        while (n3 < n) {
            String str = stringArray[n3];
            textDescription = String.valueOf(textDescription) + str.trim() + " ";
            ++n3;
        }
        textDescription.trim();
        textDescription = StringUtils.clean((String)textDescription);
        items = textDescription.split("\\s+");
        i = 0;
        while (i < items.length) {
            if (items[i].length() == 1) {
                items[i] = "";
            }
            ++i;
        }
        textDescription = "";
        stringArray = items;
        n = items.length;
        n3 = 0;
        while (n3 < n) {
            String str = stringArray[n3];
            textDescription = String.valueOf(textDescription) + str.trim() + " ";
            ++n3;
        }
        textDescription.trim();
        if (textDescription.equals("") || textDescription.equals(" ") || textDescription.equals("  ")) {
            return "";
        }
        return textDescription;
    }

    private static void run(Model model, String qstr) {
        Query query = QueryFactory.create((String)qstr);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution qs = results.nextSolution();
            String textDescription = qs.get("description").asNode().getLiteralLexicalForm();
            String name = qs.get("name").asNode().getLiteralLexicalForm();
            String process = qs.get("process").asNode().getURI();
            if ((textDescription = MITPHv1Corpus.clean(textDescription)).equals("")) continue;
            System.out.println(String.valueOf(process) + ": " + textDescription);
            corpus.add((StringWrapper)new BasicStringWrapper(textDescription));
        }
        qe.close();
    }

    public static void main(String[] args) {
        try {
            InputStream in = FileManager.get().open(inFileName);
            model.read(in, "");
            MITPHv1Corpus.run(model, qstr);
            model.close();
            in.close();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outFileName));
            out.writeObject(corpus);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

