/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import SME2Plugin.MyS3Matchmaker;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.AbstractStrategy;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.MITPHv1Corpus;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Utils;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.wcohen.ss.BasicStringWrapper;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class OWLSTCv2Corpus {
    private static String outFileName = String.valueOf(Utils.userDir) + Utils.separator + "OWLSTCv2_Corpus.ser";
    private static String services = "file:///home/kiefer/workspace/S3-Competition/data/owls-tc2/services/1.1";

    public static void run() {
        ArrayList<BasicStringWrapper> corpus = new ArrayList<BasicStringWrapper>();
        URL serviceURL = null;
        try {
            serviceURL = new URL(services);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        MyS3Matchmaker mm = new MyS3Matchmaker();
        mm.input(serviceURL);
        Model model = mm.getModel();
        String queryString = String.valueOf(AbstractStrategy.prolog) + AbstractStrategy.NL + "SELECT ?service ?description WHERE { ?service service:presents ?profile ." + AbstractStrategy.NL + "?profile profile:textDescription ?description }";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            RDFNode queryNode = rb.get("description");
            String service = rb.get("service").asNode().getURI();
            if (!queryNode.isLiteral()) continue;
            Literal l = (Literal)queryNode;
            String textDescription = l.getLexicalForm();
            if ((textDescription = MITPHv1Corpus.clean(textDescription)).equals("")) continue;
            System.out.println(String.valueOf(service) + ": " + textDescription);
            corpus.add(new BasicStringWrapper(textDescription));
        }
        qexec.close();
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(outFileName));
            out.writeObject(corpus);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        OWLSTCv2Corpus.run();
    }
}

