/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.OWLSiMatcherMatchmakingTools;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.OWLSTCv3RelevanceSet;
import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.Pair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StatisticsObjectSme {
    private static Logger logger = Logger.getLogger(StatisticsObjectSme.class);
    public static double[] stdRecallLevels = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0};
    public static int numStdRecallLevels = 21;
    private String strategy;
    private URL query;
    private Vector<URL> services;
    private Vector<Double> similarities;
    private Vector<String> answerFromRelevanceSet;
    private double[] intPR = new double[numStdRecallLevels];
    private double[] retrievedRelevantDocs = new double[numStdRecallLevels];
    private double[] retrievedDocs = new double[numStdRecallLevels];
    private double relevantDocs;
    private double rPrecision;

    public StatisticsObjectSme(String strategy, Hashtable<URL, Vector<Pair>> results, OWLSTCv3RelevanceSet relevanceSet) {
        this.services = new Vector();
        this.similarities = new Vector();
        this.answerFromRelevanceSet = new Vector();
        this.strategy = strategy;
        if (results.keySet().size() == 1) {
            Set<Map.Entry<URL, Vector<Pair>>> set = results.entrySet();
            for (Map.Entry<URL, Vector<Pair>> entry : set) {
                this.query = entry.getKey();
                for (Pair pair : entry.getValue()) {
                    this.services.add(pair.getKey());
                    this.similarities.add(Double.valueOf(pair.getValue()));
                    if (relevanceSet.relevanceSetContainsID(this.query, pair.getKey())) {
                        this.answerFromRelevanceSet.add("Yes");
                        continue;
                    }
                    this.answerFromRelevanceSet.add("No");
                }
            }
            this.relevantDocs = relevanceSet.relevanceSetSize(this.query);
            logger.debug((Object)("#Relevant docs = " + this.relevantDocs));
            this.computeStatistics();
        } else {
            logger.error((Object)"Results table has more than one entry");
        }
    }

    public static void writeMacroAverage(Vector<StatisticsObjectSme> objects, PrintStream out) {
        double[][] precision = new double[numStdRecallLevels][objects.size()];
        double[][] recall = new double[numStdRecallLevels][objects.size()];
        int index = 0;
        for (StatisticsObjectSme info : objects) {
            double[] pr = info.getPrecision();
            double[] re = info.getRecall();
            int level = 0;
            while (level < pr.length) {
                precision[level][index] = pr[level];
                recall[level][index] = re[level];
                ++level;
            }
            ++index;
        }
        double[] avgPrecision = new double[numStdRecallLevels];
        double[] avgRecall = new double[numStdRecallLevels];
        int level = 0;
        while (level < numStdRecallLevels) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            int query = 0;
            while (query < objects.size()) {
                sum1 += precision[level][query];
                sum2 += recall[level][query];
                ++query;
            }
            avgPrecision[level] = sum1 / (double)objects.size();
            avgRecall[level] = sum2 / (double)objects.size();
            ++level;
        }
        out.print("#recall\tprecision\n-----------------");
        int i = 0;
        while (i < avgRecall.length) {
            out.print(String.valueOf(avgRecall[i]) + "\t" + avgPrecision[i] + "\n");
            ++i;
        }
    }

    public static void writeMacroAverage(Vector<StatisticsObjectSme> objects, BufferedWriter out) {
        double[][] precision = new double[numStdRecallLevels][objects.size()];
        double[][] recall = new double[numStdRecallLevels][objects.size()];
        int index = 0;
        for (StatisticsObjectSme info : objects) {
            double[] pr = info.getPrecision();
            double[] re = info.getRecall();
            int level = 0;
            while (level < pr.length) {
                precision[level][index] = pr[level];
                recall[level][index] = re[level];
                ++level;
            }
            ++index;
        }
        double[] avgPrecision = new double[numStdRecallLevels];
        double[] avgRecall = new double[numStdRecallLevels];
        int level = 0;
        while (level < numStdRecallLevels) {
            double sum1 = 0.0;
            double sum2 = 0.0;
            int query = 0;
            while (query < objects.size()) {
                sum1 += precision[level][query];
                sum2 += recall[level][query];
                ++query;
            }
            avgPrecision[level] = sum1 / (double)objects.size();
            avgRecall[level] = sum2 / (double)objects.size();
            ++level;
        }
        try {
            out.write("#recall\tprecision\n");
            int i = 0;
            while (i < avgRecall.length) {
                out.write(String.valueOf(avgRecall[i]) + "\t" + avgPrecision[i] + "\n");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeMicroAverage(Vector<StatisticsObjectSme> objects, PrintStream out) {
        double[] avgPrecision = new double[numStdRecallLevels];
        double[] avgRecall = new double[numStdRecallLevels];
        int level = 0;
        while (level < stdRecallLevels.length) {
            double sumRetrievedRelevantDocs = 0.0;
            double sumRetrievedDocs = 0.0;
            double sumRelevantDocs = 0.0;
            for (StatisticsObjectSme info : objects) {
                sumRetrievedRelevantDocs += info.getRetrievedRelevantDocs(level);
                sumRetrievedDocs += info.getRetrievedDocs(level);
                sumRelevantDocs += info.getRelevantDocs();
            }
            avgPrecision[level] = sumRetrievedRelevantDocs / sumRetrievedDocs;
            avgRecall[level] = sumRetrievedRelevantDocs / sumRelevantDocs;
            ++level;
        }
        out.print("#recall\tprecision\n+++++++++++++++++++++");
        int i = 0;
        while (i < avgRecall.length) {
            out.print(String.valueOf(avgRecall[i]) + "\t" + avgPrecision[i] + "\n");
            ++i;
        }
    }

    public static void writeMicroAverage(Vector<StatisticsObjectSme> objects, BufferedWriter out) {
        double[] avgPrecision = new double[numStdRecallLevels];
        double[] avgRecall = new double[numStdRecallLevels];
        int level = 0;
        while (level < stdRecallLevels.length) {
            double sumRetrievedRelevantDocs = 0.0;
            double sumRetrievedDocs = 0.0;
            double sumRelevantDocs = 0.0;
            for (StatisticsObjectSme info : objects) {
                sumRetrievedRelevantDocs += info.getRetrievedRelevantDocs(level);
                sumRetrievedDocs += info.getRetrievedDocs(level);
                sumRelevantDocs += info.getRelevantDocs();
            }
            avgPrecision[level] = sumRetrievedRelevantDocs / sumRetrievedDocs;
            avgRecall[level] = sumRetrievedRelevantDocs / sumRelevantDocs;
            ++level;
        }
        try {
            out.write("#recall\tprecision\n");
            int i = 0;
            while (i < avgRecall.length) {
                out.write(String.valueOf(avgRecall[i]) + "\t" + avgPrecision[i] + "\n");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        String str = "";
        str = String.valueOf(str) + this.query + "\n" + this.strategy + "\n";
        return str;
    }

    public void writeStatistics(PrintStream out) {
        out.print("#recall\tprecision\n");
        int i = 0;
        while (i < stdRecallLevels.length) {
            out.print(String.valueOf(stdRecallLevels[i]) + "\t" + this.intPR[i] + "\n");
            ++i;
        }
    }

    public void writeStatistics(BufferedWriter out) {
        try {
            out.write("#recall\tprecision\n");
            int i = 0;
            while (i < stdRecallLevels.length) {
                out.write(String.valueOf(stdRecallLevels[i]) + "\t" + this.intPR[i] + "\n");
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getRetrievedRelevantDocs(int level) {
        return this.retrievedRelevantDocs[level];
    }

    public double getRetrievedDocs(int level) {
        return this.retrievedDocs[level];
    }

    public double getRelevantDocs() {
        return this.relevantDocs;
    }

    public double[] getRecall() {
        return stdRecallLevels;
    }

    public double[] getPrecision() {
        return this.intPR;
    }

    public double getRPrecision() {
        return this.rPrecision;
    }

    private void computeStatistics() {
        Vector<Double> precision = new Vector<Double>();
        Vector<Double> recall = new Vector<Double>();
        Vector<Double> retrievedRelevant = new Vector<Double>();
        Vector<Double> retrieved = new Vector<Double>();
        int N = this.similarities.size();
        double retrievedRelevantDocs = 0.0;
        int i = 0;
        while (i < N) {
            if (this.answerFromRelevanceSet.get(i).equals("Yes")) {
                retrievedRelevant.add(retrievedRelevantDocs += 1.0);
                double retrievedDocs = (double)i + 1.0;
                retrieved.add(retrievedDocs);
                double pr = retrievedRelevantDocs / retrievedDocs;
                double re = retrievedRelevantDocs / this.relevantDocs;
                precision.add(pr);
                recall.add(re);
                logger.debug((Object)("#Retrieved docs = " + retrievedDocs));
                logger.debug((Object)("#RetrievedRelevant docs = " + retrievedRelevantDocs));
                logger.debug((Object)("Precision = " + pr));
                logger.debug((Object)("Recall = " + re));
            }
            if ((double)(i + 1) == this.relevantDocs) {
                this.rPrecision = retrievedRelevantDocs / this.relevantDocs;
            }
            ++i;
        }
        this.Recall_Precision(recall, precision, System.out);
        this.interpolatePR(precision, recall, retrievedRelevant, retrieved);
    }

    private void interpolatePR(Vector<Double> precision, Vector<Double> recall, Vector<Double> retRelDocs, Vector<Double> retDocs) {
        int i = 0;
        while (i < this.intPR.length) {
            this.intPR[i] = -1.0;
            ++i;
        }
        i = 0;
        while (i < stdRecallLevels.length - 1) {
            double rj = stdRecallLevels[i];
            double rj1 = stdRecallLevels[i + 1];
            logger.debug((Object)("Std recall level intervall " + rj + " <---> " + rj1));
            Vector<Integer> sLevels = new Vector<Integer>();
            String sLevelsStr = "";
            int k = 0;
            while (k < recall.size()) {
                double sLevel = recall.get(k);
                if (sLevel >= rj && sLevel <= rj1) {
                    sLevels.add(k);
                    sLevelsStr = String.valueOf(sLevelsStr) + sLevel + " ";
                }
                ++k;
            }
            logger.debug((Object)("Simple levels in intevall " + sLevelsStr));
            double max = -1.0;
            Iterator iterator = sLevels.iterator();
            while (iterator.hasNext()) {
                int sLevel = (Integer)iterator.next();
                if (!(precision.get(sLevel) >= max)) continue;
                max = precision.get(sLevel);
                this.retrievedRelevantDocs[i] = retRelDocs.get(sLevel);
                this.retrievedDocs[i] = retDocs.get(sLevel);
            }
            logger.debug((Object)("Maximum known precision at simple levels " + max));
            this.intPR[i] = max;
            ++i;
        }
        i = 0;
        while (i < this.intPR.length - 1) {
            if (this.intPR[i] < this.intPR[i + 1]) {
                this.intPR[i] = this.intPR[i + 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.intPR.length - 1) {
            if (this.intPR[i + 1] == -1.0) {
                this.intPR[i + 1] = this.intPR[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.retrievedRelevantDocs.length - 1) {
            if (this.retrievedRelevantDocs[i] < this.retrievedRelevantDocs[i + 1]) {
                this.retrievedRelevantDocs[i] = this.retrievedRelevantDocs[i + 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.retrievedDocs.length - 1) {
            if (this.retrievedDocs[i] < this.retrievedDocs[i + 1]) {
                this.retrievedDocs[i] = this.retrievedDocs[i + 1];
            }
            ++i;
        }
        i = 0;
        while (i < this.retrievedRelevantDocs.length - 1) {
            if (this.retrievedRelevantDocs[i + 1] == 0.0) {
                this.retrievedRelevantDocs[i + 1] = this.retrievedRelevantDocs[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.retrievedDocs.length - 1) {
            if (this.retrievedDocs[i + 1] == 0.0) {
                this.retrievedDocs[i + 1] = this.retrievedDocs[i];
            }
            ++i;
        }
        if (logger.isDebugEnabled()) {
            for (double pr : precision) {
                System.out.print(String.valueOf(pr) + " ");
            }
            System.out.println();
            for (double re : recall) {
                System.out.print(String.valueOf(re) + " ");
            }
            System.out.println();
            i = 0;
            while (i < this.intPR.length) {
                System.out.print(String.valueOf(this.intPR[i]) + " ");
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < stdRecallLevels.length) {
                System.out.print(String.valueOf(stdRecallLevels[i]) + " ");
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.retrievedRelevantDocs.length) {
                System.out.print(String.valueOf(this.retrievedRelevantDocs[i]) + " ");
                ++i;
            }
            System.out.println();
            i = 0;
            while (i < this.retrievedDocs.length) {
                System.out.print(String.valueOf(this.retrievedDocs[i]) + " ");
                ++i;
            }
            System.out.println();
        }
    }

    public void Recall_Precision(Vector<Double> recall, Vector<Double> precision, PrintStream out) {
        Iterator<Double> recIt = recall.iterator();
        Iterator<Double> preIt = precision.iterator();
        out.print("#recall\tprecision\n");
        while (recIt.hasNext()) {
            out.println(String.valueOf(recIt.next().toString()) + "\t" + preIt.next().toString());
        }
    }
}

