/*
 * Decompiled with CFR 0.152.
 */
package ch.uzh.ifi.isparql.apf.simpack;

import ch.uzh.ifi.OWLSiMatcherMatchmakingTools.ReasoningTools;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.core.Var;
import com.hp.hpl.jena.query.engine.Binding;
import com.hp.hpl.jena.query.engine.Binding1;
import com.hp.hpl.jena.query.engine.QueryIterator;
import com.hp.hpl.jena.query.engine1.ExecutionContext;
import com.hp.hpl.jena.query.engine1.iterator.QueryIterSingleton;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.pfunction.PropFuncArg;
import com.hp.hpl.jena.query.pfunction.PropertyFunctionBase;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import owlsmx.tokenizer.PrimitiveConceptTokenizer;
import simpack.api.impl.FeatureVectorSimilarityMeasure;
import simpack.measure.vector.Alignment;
import simpack.measure.vector.Manhattan;

public class manhattanOutputs
extends PropertyFunctionBase {
    private static Log logger = LogFactory.getLog(manhattanOutputs.class);

    public QueryIterator exec(Binding binding, PropFuncArg subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        subject = subject.evalIfExists(binding);
        Node s = subject.getArg();
        object = object.evalIfExists(binding);
        Node arg1 = object.getArg(0);
        Node arg2 = object.getArg(1);
        boolean doInfer = false;
        if (object.getArgList().size() >= 3) {
            Node arg3 = object.getArg(2);
            if (arg3.getLiteralLexicalForm().equals("true")) {
                doInfer = true;
            } else if (arg3.getLiteralLexicalForm().equals("false")) {
                doInfer = false;
            }
        }
        double threshold = 0.0;
        if (object.getArgList().size() >= 4) {
            Node arg4 = object.getArg(3);
            threshold = Double.valueOf(arg4.getLiteralLexicalForm());
        }
        String a = null;
        String b = null;
        if (arg1.isLiteral() && arg2.isLiteral()) {
            a = arg1.getLiteralLexicalForm();
            b = arg2.getLiteralLexicalForm();
        } else if (arg1.isURI() && arg2.isURI()) {
            a = arg1.getURI();
            b = arg2.getURI();
        } else {
            System.out.println("Error: Node types unequal.");
            System.out.println(arg1.toString());
            System.out.println(arg2.toString());
        }
        if (logger.isDebugEnabled()) {
            System.out.println(String.valueOf(a) + " <==> " + b);
        }
        String unfoldedInputs1 = ReasoningTools.unfoldConcepts(a.substring(0, a.lastIndexOf("#")), "output", doInfer);
        String unfoldedInputs2 = ReasoningTools.unfoldConcepts(b.substring(0, b.lastIndexOf("#")), "output", doInfer);
        PrimitiveConceptTokenizer tokenizer = new PrimitiveConceptTokenizer();
        Map pc1 = tokenizer.getTokenFrequencies(unfoldedInputs1);
        Map pc2 = tokenizer.getTokenFrequencies(unfoldedInputs2);
        Set keys1 = pc1.keySet();
        Set keys2 = pc2.keySet();
        Vector<String> inputs1 = new Vector<String>();
        Vector<String> inputs2 = new Vector<String>();
        for (Object o : keys1) {
            inputs1.add(o.toString());
        }
        for (Object o : keys2) {
            inputs2.add(o.toString());
        }
        Alignment al = new Alignment(inputs1, inputs2, (FeatureVectorSimilarityMeasure)new Manhattan());
        double sim = 0.0;
        sim = al.getSimilarity();
        if (sim < threshold) {
            sim = 0.0;
        }
        Locale.setDefault(Locale.US);
        DecimalFormat formatter = new DecimalFormat("0.000000000");
        String sim2 = formatter.format(sim);
        if (logger.isDebugEnabled()) {
            System.out.println(keys1);
            System.out.println(keys2);
            System.out.println(sim);
        }
        NodeValue nv = NodeValue.makeString((String)sim2);
        Binding1 bind = new Binding1(binding, Var.alloc((Node)s), nv.asNode());
        return new QueryIterSingleton((Binding)bind, execCxt);
    }
}

