/*
 * Decompiled with CFR 0.152.
 */
import SME2Plugin.S3Matchmaker;
import ch.uzh.ifi.OWLSiMatcherMatchmakingStrategies.api.AbstractStrategy;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import com.hp.hpl.jena.query.util.IndentedWriter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class getOWLSServiceName {
    public static Hashtable<String, Set<String>> serviceURLandName = new Hashtable();
    public static String owlsServiceURLandName = "owlsServiceURLandName.ser";
    private String NL = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger(getOWLSServiceName.class);
    public String queryString = String.valueOf(AbstractStrategy.prolog) + AbstractStrategy.NL + "SELECT ?service" + AbstractStrategy.NL + "WHERE { " + "?service service:presents ?serviceProfile . }";
    private S3Matchmaker matcher = new S3Matchmaker();

    public ResultSet getResult(Model queryModel) {
        System.out.println(this.queryString);
        Query query = QueryFactory.create((String)this.queryString);
        System.out.println(query.toString());
        if (logger.isDebugEnabled()) {
            query.serialize(new IndentedWriter((OutputStream)System.out, true));
            System.out.println();
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)queryModel);
        ResultSetRewindable rs = ResultSetFactory.makeRewindable((ResultSet)qexec.execSelect());
        qexec.close();
        if (logger.isDebugEnabled()) {
            ResultSetFormatter.out((OutputStream)System.out, (ResultSet)rs, (Query)query);
            System.out.println("Size of result set: " + ResultSetFormatter.consume((ResultSet)rs));
        }
        return rs;
    }

    protected Vector<String> transformResults2(ResultSet rs) {
        Vector<String> results = new Vector<String>();
        URL serURL = null;
        while (rs.hasNext()) {
            QuerySolution rb = rs.nextSolution();
            RDFNode service = rb.get("service");
            if (!service.isURIResource()) continue;
            Resource ser = (Resource)service;
            try {
                serURL = new URL(ser.getURI());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        results.add(serURL.toString());
        return results;
    }

    protected Model getService(File serviceURL, Model model) {
        InputStream in = null;
        File file = serviceURL;
        if (file.isFile()) {
            in = FileManager.get().open(file.toString());
            model.read(in, "");
        }
        if (logger.isDebugEnabled()) {
            model.write((OutputStream)System.out);
        }
        return model;
    }

    public static void main(String[] args) {
        Hashtable table = new Hashtable();
        getOWLSServiceName getservice = new getOWLSServiceName();
        String serviceURL = ".\\data\\owls-tc3\\htdocs\\services\\1.1\\";
        File file = new File(serviceURL);
        File[] files = null;
        if (file.isDirectory()) {
            files = file.listFiles();
        }
        int i = 0;
        while (i < files.length) {
            Model model = ModelFactory.createDefaultModel();
            model = getservice.getService(files[i], model);
            ResultSet rs = getservice.getResult(model);
            Vector<String> vector = getservice.transformResults2(rs);
            ++i;
        }
    }
}

