/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.IllegalDateTimeFieldException;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.test.Rational;
import com.hp.hpl.jena.graph.test.RationalType;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.impl.JenaParameters;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.impl.dv.util.HexBin;

public class TestTypedLiterals
extends TestCase {
    private Model m = ModelFactory.createDefaultModel();

    public TestTypedLiterals(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestTypedLiterals.class);
    }

    public void testUnknown() {
        String typeURI = "urn:x-hp-dt:unknown";
        String typeURI2 = "urn:x-hp-dt:unknown2";
        boolean originalFlag = JenaParameters.enableSilentAcceptanceOfUnknownDatatypes;
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = true;
        Literal l1 = this.m.createTypedLiteral("foo", typeURI);
        Literal l3 = this.m.createTypedLiteral("15", typeURI);
        Literal l5 = this.m.createTypedLiteral("foo", typeURI2);
        Literal l6 = this.m.createLiteral("foo", "lang1");
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = originalFlag;
        TestTypedLiterals.assertNotNull((Object)l1);
        TestTypedLiterals.assertNotNull((Object)l3);
        TestTypedLiterals.assertNotNull((Object)l5);
        this.assertDiffer("datatype sensitive", l1, l5);
        this.assertDiffer("value sensitive", l1, l3);
        this.assertDiffer("typed and plain differ", l1, l6);
        try {
            l3.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException e) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract value", (Object)l1.getValue(), (Object)new BaseDatatype.TypedValue("foo", typeURI));
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)l1.isWellFormedXML(), (boolean)false);
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = false;
        boolean foundException = false;
        try {
            this.m.createTypedLiteral("food", typeURI + "3");
        }
        catch (DatatypeFormatException e2) {
            foundException = true;
        }
        JenaParameters.enableSilentAcceptanceOfUnknownDatatypes = originalFlag;
        TestTypedLiterals.assertTrue((String)"Detected unknown datatype", (boolean)foundException);
        Date foo = new Date(123456L);
        LiteralLabel ll = new LiteralLabel((Object)foo);
        TestTypedLiterals.assertEquals((String)ll.getLexicalForm(), (String)((Object)foo).toString());
    }

    public void testUserDef() {
        RDFDatatype rtype = RationalType.theRationalType;
        TypeMapper.getInstance().registerDatatype(rtype);
        Literal l1 = this.m.createTypedLiteral("3/5", rtype);
        Literal l3 = this.m.createTypedLiteral("7/5", rtype);
        TestTypedLiterals.assertNotNull((Object)l1);
        TestTypedLiterals.assertNotNull((Object)l3);
        this.assertDiffer("values should be tested!", l1, l3);
        TestTypedLiterals.assertSame((String)"Datatype incorrect", (Object)l1.getDatatype(), (Object)rtype);
        TestTypedLiterals.assertEquals((String)"Datatype uri incorrect", (String)l1.getDatatypeURI(), (String)"urn:x-hp-dt:rational");
        Object val = l1.getValue();
        TestTypedLiterals.assertTrue((String)"Value space check", (boolean)(val instanceof Rational));
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)val).getNumerator() == 3 ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"Value check", (((Rational)val).getDenominator() == 5 ? 1 : 0) != 0);
        try {
            l1.getInt();
            TestTypedLiterals.assertTrue((String)"Allowed int conversion", (boolean)false);
        }
        catch (DatatypeFormatException e) {
            // empty catch block
        }
        TestTypedLiterals.assertEquals((String)"Extract xml tag", (boolean)l1.isWellFormedXML(), (boolean)false);
    }

    public void testXMLLiteral() {
        Literal ll = this.m.createLiteral("<bad", true);
        TestTypedLiterals.assertTrue((String)"Error checking must be off.", (boolean)((EnhNode)ll).asNode().getLiteralIsXML());
        ll = this.m.createTypedLiteral("<bad/>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertFalse((String)"Error checking must be on.", (boolean)((EnhNode)ll).asNode().getLiteralIsXML());
        ll = this.m.createTypedLiteral("<good></good>", XMLLiteralType.theXMLLiteralType);
        TestTypedLiterals.assertTrue((String)"Well-formed XMLLiteral.", (boolean)((EnhNode)ll).asNode().getLiteralIsXML());
    }

    public void testXSDbasics() {
        String xsdIntURI = "http://www.w3.org/2001/XMLSchema#int";
        Literal l1 = this.m.createTypedLiteral(42);
        Literal l2 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDint);
        Literal l4 = this.m.createTypedLiteral("63");
        this.assertSameValueAs("Default map failed", l1, l2);
        TestTypedLiterals.assertEquals((String)"Value wrong", (Object)l1.getValue(), (Object)new Integer(42));
        TestTypedLiterals.assertEquals((String)"class wrong", l1.getValue().getClass(), (Object)Integer.class);
        TestTypedLiterals.assertEquals((String)"Value accessor problem", (int)l1.getInt(), (int)42);
        TestTypedLiterals.assertEquals((String)"wrong type name", (String)l2.getDatatypeURI(), (String)xsdIntURI);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)l2.getDatatype(), (Object)XSDDatatype.XSDint);
        this.assertDiffer("Not value sensitive", l1, l4);
        this.checkIllegalLiteral("zap", (RDFDatatype)XSDDatatype.XSDint);
        this.checkIllegalLiteral("42.1", (RDFDatatype)XSDDatatype.XSDint);
        Literal l5 = this.m.createTypedLiteral("42", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("type coercion", l2, l5);
        l1 = this.m.createTypedLiteral(42.42);
        l2 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal l3 = this.m.createTypedLiteral("42.42", (RDFDatatype)XSDDatatype.XSDdouble);
        TestTypedLiterals.assertEquals((String)"class wrong", l1.getValue().getClass(), (Object)Double.class);
        this.assertFloatEquals("value wrong", ((Double)l1.getValue()).floatValue(), 42.42);
        TestTypedLiterals.assertEquals((String)"class wrong", l2.getValue().getClass(), (Object)Float.class);
        this.assertFloatEquals("value wrong", ((Float)l2.getValue()).floatValue(), 42.42);
        this.assertFloatEquals("Value accessor problem", l1.getFloat(), 42.42);
        TestTypedLiterals.assertEquals((String)"wrong type", (Object)l2.getDatatype(), (Object)XSDDatatype.XSDfloat);
        this.assertSameValueAs("equality fn", l1, l3);
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDlong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDlong, Integer.class, new Integer(-12345));
        this.checkIllegalLiteral("2.3", (RDFDatatype)XSDDatatype.XSDlong);
        this.checkLegalLiteral("1234", (RDFDatatype)XSDDatatype.XSDshort, Integer.class, new Integer(1234));
        this.checkLegalLiteral("-1234", (RDFDatatype)XSDDatatype.XSDshort, Integer.class, new Integer(-1234));
        this.checkLegalLiteral("32767", (RDFDatatype)XSDDatatype.XSDshort, Integer.class, new Integer(Short.MAX_VALUE));
        this.checkLegalLiteral("-32768", (RDFDatatype)XSDDatatype.XSDshort, Integer.class, new Integer(Short.MIN_VALUE));
        this.checkIllegalLiteral("32769", (RDFDatatype)XSDDatatype.XSDshort);
        this.checkIllegalLiteral("2.3", (RDFDatatype)XSDDatatype.XSDshort);
        this.checkLegalLiteral("42", (RDFDatatype)XSDDatatype.XSDbyte, Integer.class, new Integer(42));
        this.checkLegalLiteral("-42", (RDFDatatype)XSDDatatype.XSDbyte, Integer.class, new Integer(-42));
        this.checkLegalLiteral("127", (RDFDatatype)XSDDatatype.XSDbyte, Integer.class, new Integer(127));
        this.checkLegalLiteral("-128", (RDFDatatype)XSDDatatype.XSDbyte, Integer.class, new Integer(-128));
        this.checkIllegalLiteral("32769", (RDFDatatype)XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("128", (RDFDatatype)XSDDatatype.XSDbyte);
        this.checkIllegalLiteral("2.3", (RDFDatatype)XSDDatatype.XSDbyte);
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDunsignedLong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("+12345", (RDFDatatype)XSDDatatype.XSDunsignedLong, Integer.class, new Integer(12345));
        this.checkLegalLiteral("9223372036854775808", (RDFDatatype)XSDDatatype.XSDunsignedLong, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkIllegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDunsignedLong);
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDunsignedInt, Integer.class, new Integer(12345));
        this.checkLegalLiteral("2147483648", (RDFDatatype)XSDDatatype.XSDunsignedInt, Long.class, new Long(0x80000000L));
        this.checkIllegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDunsignedInt);
        this.checkLegalLiteral("1234", (RDFDatatype)XSDDatatype.XSDunsignedShort, Integer.class, new Integer(1234));
        this.checkLegalLiteral("32679", (RDFDatatype)XSDDatatype.XSDunsignedShort, Integer.class, new Integer(32679));
        this.checkIllegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDunsignedShort);
        this.checkLegalLiteral("123", (RDFDatatype)XSDDatatype.XSDunsignedByte, Integer.class, new Integer(123));
        this.checkLegalLiteral("129", (RDFDatatype)XSDDatatype.XSDunsignedByte, Integer.class, new Integer(129));
        this.checkIllegalLiteral("-123", (RDFDatatype)XSDDatatype.XSDunsignedByte);
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDinteger, Integer.class, new Integer(12345));
        this.checkLegalLiteral("0", (RDFDatatype)XSDDatatype.XSDinteger, Integer.class, new Integer(0));
        this.checkLegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDinteger, Integer.class, new Integer(-12345));
        this.checkLegalLiteral("9223372036854775808", (RDFDatatype)XSDDatatype.XSDinteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDpositiveInteger, Integer.class, new Integer(12345));
        this.checkIllegalLiteral("0", (RDFDatatype)XSDDatatype.XSDpositiveInteger);
        this.checkIllegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDpositiveInteger);
        this.checkLegalLiteral("9223372036854775808", (RDFDatatype)XSDDatatype.XSDpositiveInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger, Integer.class, new Integer(12345));
        this.checkLegalLiteral("0", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger, Integer.class, new Integer(0));
        this.checkIllegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.checkLegalLiteral("9223372036854775808", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger, BigInteger.class, new BigInteger("9223372036854775808"));
        this.checkLegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDnegativeInteger, Integer.class, new Integer(-12345));
        this.checkIllegalLiteral("0", (RDFDatatype)XSDDatatype.XSDnegativeInteger);
        this.checkIllegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDnegativeInteger);
        this.checkLegalLiteral("-9223372036854775808", (RDFDatatype)XSDDatatype.XSDnegativeInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("-12345", (RDFDatatype)XSDDatatype.XSDnonPositiveInteger, Integer.class, new Integer(-12345));
        this.checkLegalLiteral("0", (RDFDatatype)XSDDatatype.XSDnonPositiveInteger, Integer.class, new Integer(0));
        this.checkIllegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDnonPositiveInteger);
        this.checkLegalLiteral("-9223372036854775808", (RDFDatatype)XSDDatatype.XSDnonPositiveInteger, BigInteger.class, new BigInteger("-9223372036854775808"));
        this.checkLegalLiteral("12345", (RDFDatatype)XSDDatatype.XSDdecimal, Integer.class, new Integer("12345"));
        this.checkLegalLiteral("0.0", (RDFDatatype)XSDDatatype.XSDdecimal, Integer.class, new Integer("0"));
        this.checkLegalLiteral("42.45", (RDFDatatype)XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("42.45"));
        this.checkLegalLiteral("9223372036854775808.1234", (RDFDatatype)XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("9223372036854775808.1234"));
        this.checkLegalLiteral("123.4", (RDFDatatype)XSDDatatype.XSDdecimal, BigDecimal.class, new BigDecimal("123.4"));
        this.checkIllegalLiteral("123,4", (RDFDatatype)XSDDatatype.XSDdecimal);
        this.checkLegalLiteral("true", (RDFDatatype)XSDDatatype.XSDboolean, Boolean.class, new Boolean(true));
        this.checkLegalLiteral("false", (RDFDatatype)XSDDatatype.XSDboolean, Boolean.class, new Boolean(false));
        l1 = this.m.createTypedLiteral(true);
        TestTypedLiterals.assertEquals((String)"boolean mapping", (Object)XSDDatatype.XSDboolean, (Object)l1.getDatatype());
        this.checkLegalLiteral("hello world", (RDFDatatype)XSDDatatype.XSDstring, String.class, "hello world");
        l1 = this.m.createTypedLiteral("foo bar");
        TestTypedLiterals.assertEquals((String)"string mapping", (Object)XSDDatatype.XSDstring, (Object)l1.getDatatype());
    }

    public void testMiscEquality() {
        Literal l1 = this.m.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l3 = this.m.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("Int lex form", l1, l3);
        l1 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDint);
        l3 = this.m.createTypedLiteral("1", (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        this.assertSameValueAs("numeric comparisons", l1, l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverloads() {
        boolean old = JenaParameters.enableEagerLiteralValidation;
        try {
            JenaParameters.enableEagerLiteralValidation = true;
            boolean test1 = false;
            try {
                this.m.createTypedLiteral("foo", "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException e1) {
                test1 = true;
            }
            TestTypedLiterals.assertTrue((String)"detected illegal string, direct", (boolean)test1);
            boolean test2 = false;
            try {
                String foo = "foo";
                this.m.createTypedLiteral((Object)foo, "http://www.w3.org/2001/XMLSchema#integer");
            }
            catch (DatatypeFormatException e2) {
                test2 = true;
            }
            TestTypedLiterals.assertTrue((String)"detected illegal string, overloaded", (boolean)test2);
            GregorianCalendar testCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            testCal.set(1999, 4, 30, 15, 9, 32);
            testCal.set(14, 0);
            Literal lc = this.m.createTypedLiteral((Object)testCal);
            TestTypedLiterals.assertEquals((String)"calendar overloading test", (Object)this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), (Object)lc);
        }
        finally {
            JenaParameters.enableEagerLiteralValidation = old;
        }
    }

    public void testPlainSameValueAs() {
        Literal lString = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDstring);
        Literal lPlain = this.m.createTypedLiteral("10", (RDFDatatype)null);
        Literal lPlain3 = this.m.createTypedLiteral("10", (String)null);
        Literal lPlain2 = this.m.createLiteral("10");
        Literal lInt = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("Null type = plain literal", lPlain, lPlain2);
        this.assertSameValueAs("Null type = plain literal", lPlain, lPlain3);
        this.assertSameValueAs("Null type = plain literal", lPlain2, lPlain3);
        TestTypedLiterals.assertTrue((String)"null type", (lPlain3.getDatatype() == null ? 1 : 0) != 0);
        this.assertDiffer("String != int", lString, lInt);
        this.assertDiffer("Plain != int", lPlain, lInt);
        this.assertDiffer("Plain != int", lPlain2, lInt);
        if (JenaParameters.enablePlainLiteralSameAsString) {
            this.assertSameValueAs("String != plain??", lString, lPlain);
            this.assertSameValueAs("String != plain??", lString, lPlain2);
        } else {
            this.assertDiffer("String != plain??", lString, lPlain);
            this.assertDiffer("String != plain??", lString, lPlain2);
        }
    }

    public void testNumberSameValueAs() {
        Literal lDouble = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lDouble2 = this.m.createTypedLiteral("5.5", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lDouble3 = this.m.createTypedLiteral("5.5", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lDouble4 = this.m.createTypedLiteral("5.6", (RDFDatatype)XSDDatatype.XSDdouble);
        Literal lFloat = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDfloat);
        Literal lint = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDint);
        Literal linteger = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDinteger);
        Literal lbyte = this.m.createTypedLiteral("5", (RDFDatatype)XSDDatatype.XSDbyte);
        this.assertSameValueAs("integer subclasses equal", lint, linteger);
        this.assertSameValueAs("integer subclasses equal", lint, lbyte);
        this.assertSameValueAs("integer subclasses equal", linteger, lbyte);
        this.assertSameValueAs("double equality", lDouble2, lDouble3);
        this.assertDiffer("float/double/int distinct", lDouble, lDouble2);
        this.assertDiffer("float/double/int distinct", lDouble, lFloat);
        this.assertDiffer("float/double/int distinct", lDouble, lint);
        this.assertDiffer("float/double/int distinct", lDouble, linteger);
        this.assertDiffer("float/double/int distinct", lDouble2, lint);
        this.assertDiffer("float/double/int distinct", lDouble2, lbyte);
        this.assertDiffer("float/double/int distinct", lint, lDouble);
        this.assertDiffer("float/double/int distinct", lbyte, lDouble);
        this.assertDiffer("float/double/int distinct", lint, lDouble2);
        this.assertDiffer("float/double/int distinct", lbyte, lDouble2);
        this.assertDiffer("double inequality", lDouble3, lDouble4);
        this.assertDiffer("double inequality", lDouble2, lDouble);
        Literal lDecimal = this.m.createTypedLiteral("5.5", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal lDecimal2 = this.m.createTypedLiteral("5.6", (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertDiffer("decimal inequality", lDecimal, lDecimal2);
    }

    public void testBigNums() {
        Literal l1 = this.m.createTypedLiteral("12345678901234567890", (RDFDatatype)XSDDatatype.XSDinteger);
        Literal l2 = this.m.createTypedLiteral("12345678901234567891", (RDFDatatype)XSDDatatype.XSDinteger);
        this.assertDiffer("Big integer equality", l1, l2);
        BigInteger bigint1 = new BigInteger("12345678901234567890");
        Literal lb1 = this.m.createTypedLiteral((Object)bigint1, (RDFDatatype)XSDDatatype.XSDinteger);
        this.assertSameValueAs("big integer creation equality", l1, lb1);
        BigDecimal bigdec1 = new BigDecimal("12345678901234567890.00");
        Literal ld1 = this.m.createTypedLiteral((Object)bigdec1, (RDFDatatype)XSDDatatype.XSDdecimal);
        BigDecimal bigdec1b = new BigDecimal("12345678901234567890.0");
        Literal ld1b = this.m.createTypedLiteral((Object)bigdec1b, (RDFDatatype)XSDDatatype.XSDdecimal);
        BigDecimal bigdec2 = new BigDecimal("12345678901234567890.1");
        Literal ld2 = this.m.createTypedLiteral((Object)bigdec2, (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertSameValueAs("big decimal equality check", ld1, ld1b);
        this.assertSameValueAs("big decimal equality check", ld1, lb1);
        this.assertDiffer("Decimal equality", ld1, ld2);
        BigDecimal bigdecF = new BigDecimal("12345678901234567890.1");
        Literal ldF = this.m.createTypedLiteral((Object)bigdecF, (RDFDatatype)XSDDatatype.XSDdecimal);
        BigDecimal bigdecFb = new BigDecimal("12345678901234567890.10");
        Literal ldFb = this.m.createTypedLiteral((Object)bigdecFb, (RDFDatatype)XSDDatatype.XSDdecimal);
        BigDecimal bigdecF2 = new BigDecimal("12345678901234567890.2");
        Literal ldF2 = this.m.createTypedLiteral((Object)bigdecF2, (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertSameValueAs("big decimal equality check", ldF, ldFb);
        this.assertDiffer("Decimal equality", ldF, ldF2);
    }

    public void testDecimalFind() {
        XSDDatatype dt = XSDDatatype.XSDdecimal;
        Node ns = Node.createURI((String)"x");
        Node np = Node.createURI((String)"p");
        Node nx1 = Node.createLiteral((String)"0.50", null, (RDFDatatype)dt);
        Node nx2 = Node.createLiteral((String)"0.500", null, (RDFDatatype)dt);
        Graph graph = Factory.createDefaultGraph();
        graph.add(new Triple(ns, np, nx1));
        TestTypedLiterals.assertTrue((boolean)graph.find(Node.ANY, Node.ANY, nx2).hasNext());
    }

    public void testDecimalCanonicalize() {
        this.doTestDecimalCanonicalize("0.500", "0.5", BigDecimal.class);
        this.doTestDecimalCanonicalize("0.50", "0.5", BigDecimal.class);
        this.doTestDecimalCanonicalize("0.5", "0.5", BigDecimal.class);
        this.doTestDecimalCanonicalize("0.0", "0", Integer.class);
        this.doTestDecimalCanonicalize("5.0", "5", Integer.class);
        this.doTestDecimalCanonicalize("500.0", "500", Integer.class);
        this.doTestDecimalCanonicalize("5.00100", "5.001", BigDecimal.class);
    }

    private void doTestDecimalCanonicalize(String value, String expected, Class expectedClass) {
        Object normalized = XSDDatatype.XSDdecimal.cannonicalise((Object)new BigDecimal(value));
        TestTypedLiterals.assertEquals((String)expected, (String)normalized.toString());
        TestTypedLiterals.assertEquals((Object)expectedClass, normalized.getClass());
    }

    public void testUserDefined() throws IOException {
        String uri = "http://www.daml.org/2001/03/daml+oil-ex-dt";
        String filename = "testing/xsd/daml+oil-ex-dt.xsd";
        TypeMapper tm = TypeMapper.getInstance();
        List typenames = XSDDatatype.loadUserDefined((String)uri, (Reader)new FileReader(filename), null, (TypeMapper)tm);
        this.assertIteratorValues(typenames.iterator(), new Object[]{uri + "#XSDEnumerationHeight", uri + "#over12", uri + "#over17", uri + "#over59", uri + "#clothingsize"});
        RDFDatatype heightType = tm.getSafeTypeByName(uri + "#XSDEnumerationHeight");
        this.checkLegalLiteral("short", heightType, String.class, "short");
        this.checkLegalLiteral("tall", heightType, String.class, "tall");
        this.checkIllegalLiteral("shortish", heightType);
        RDFDatatype over12Type = tm.getSafeTypeByName(uri + "#over12");
        this.checkLegalLiteral("15", over12Type, Integer.class, new Integer(15));
        this.checkIllegalLiteral("12", over12Type);
        RDFDatatype clothingsize = tm.getSafeTypeByName(uri + "#clothingsize");
        this.checkLegalLiteral("42", clothingsize, Integer.class, new Integer(42));
        this.checkLegalLiteral("short", clothingsize, String.class, "short");
        LiteralLabel iOver12 = this.m.createTypedLiteral("13", over12Type).asNode().getLiteral();
        LiteralLabel iDecimal14 = this.m.createTypedLiteral("14", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel iDecimal10 = this.m.createTypedLiteral("10", (RDFDatatype)XSDDatatype.XSDdecimal).asNode().getLiteral();
        LiteralLabel iString = this.m.createTypedLiteral("15", (RDFDatatype)XSDDatatype.XSDstring).asNode().getLiteral();
        LiteralLabel iPlain = this.m.createLiteral("foo").asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)over12Type.isValidLiteral(iOver12));
        TestTypedLiterals.assertTrue((boolean)over12Type.isValidLiteral(iDecimal14));
        TestTypedLiterals.assertTrue((!over12Type.isValidLiteral(iDecimal10) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!over12Type.isValidLiteral(iString) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!over12Type.isValidLiteral(iPlain) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(iOver12));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(iDecimal14));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(iDecimal10));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(iString) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(iPlain) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(iString));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(iPlain));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(iOver12) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(iDecimal10) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(iDecimal14) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDateTime() {
        Literal l1 = this.m.createTypedLiteral("P1Y2M3DT5H6M7.50S", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals((String)"duration data type", (Object)XSDDatatype.XSDduration, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"duration java type", (Object)XSDDuration.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"duration value", (int)1, (int)((XSDDuration)l1.getValue()).getYears());
        TestTypedLiterals.assertEquals((String)"duration value", (int)2, (int)((XSDDuration)l1.getValue()).getMonths());
        TestTypedLiterals.assertEquals((String)"duration value", (int)3, (int)((XSDDuration)l1.getValue()).getDays());
        TestTypedLiterals.assertEquals((String)"duration value", (int)5, (int)((XSDDuration)l1.getValue()).getHours());
        TestTypedLiterals.assertEquals((String)"duration value", (int)6, (int)((XSDDuration)l1.getValue()).getMinutes());
        TestTypedLiterals.assertEquals((String)"duration value", (int)7, (int)((XSDDuration)l1.getValue()).getFullSeconds());
        TestTypedLiterals.assertEquals((String)"duration value", (Object)BigDecimal.valueOf(75L, 1), (Object)((XSDDuration)l1.getValue()).getBigSeconds());
        this.assertFloatEquals("duration value", 18367.5, ((XSDDuration)l1.getValue()).getTimePart());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"P1Y2M3DT5H6M7.5S", (String)l1.getValue().toString());
        TestTypedLiterals.assertTrue((String)"equality test", (boolean)l1.sameValueAs(this.m.createTypedLiteral("P1Y2M3DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration)));
        TestTypedLiterals.assertTrue((String)"inequality test", (l1 != this.m.createTypedLiteral("P1Y2M2DT5H6M7.5S", (RDFDatatype)XSDDatatype.XSDduration) ? 1 : 0) != 0);
        l1 = this.m.createTypedLiteral("P1Y2M3DT5H0M", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals((String)"serialization", (String)"P1Y2M3DT5H", (String)l1.getValue().toString());
        l1 = this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration);
        TestTypedLiterals.assertEquals((String)"duration data type", (Object)XSDDatatype.XSDduration, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"duration java type", (Object)XSDDuration.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"duration value", (int)1, (int)((XSDDuration)l1.getValue()).getYears());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"P1Y", (String)l1.getValue().toString());
        TestTypedLiterals.assertTrue((String)"equality test", (boolean)l1.sameValueAs(this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration)));
        TestTypedLiterals.assertTrue((String)"inequality test", (l1 != this.m.createTypedLiteral("P1Y", (RDFDatatype)XSDDatatype.XSDduration) ? 1 : 0) != 0);
        l1 = this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        XSDDateTime xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdateTime, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xdt.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xdt.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xdt.getDays());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)2, (int)xdt.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)9, (int)xdt.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xdt.getFullSeconds());
        TestTypedLiterals.assertEquals((String)"serialization", (String)"1999-05-31T02:09:32Z", (String)l1.getValue().toString());
        Calendar cal = xdt.asCalendar();
        GregorianCalendar testCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal.set(1999, 4, 31, 2, 9, 32);
        testCal.set(14, 0);
        TestTypedLiterals.assertEquals((String)"calendar value", (Object)cal, (Object)testCal);
        TestTypedLiterals.assertEquals((String)"equality test", (Object)l1, (Object)this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        TestTypedLiterals.assertTrue((String)"inequality test", (l1 != this.m.createTypedLiteral("1999-04-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime) ? 1 : 0) != 0);
        GregorianCalendar testCal2 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal2.set(1999, 4, 30, 15, 9, 32);
        testCal2.set(14, 0);
        Literal lc = this.m.createTypedLiteral((Calendar)testCal2);
        TestTypedLiterals.assertEquals((String)"calendar 24 hour test", (Object)this.m.createTypedLiteral("1999-05-30T15:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime), (Object)lc);
        TestTypedLiterals.assertEquals((String)"calendar value", (Object)cal, (Object)testCal);
        TestTypedLiterals.assertEquals((String)"equality test", (Object)l1, (Object)this.m.createTypedLiteral("1999-05-31T02:09:32Z", (RDFDatatype)XSDDatatype.XSDdateTime));
        GregorianCalendar testCal3 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal3.clear();
        testCal3.set(1999, 0, 30, 15, 9, 32);
        lc = this.m.createTypedLiteral((Calendar)testCal3);
        TestTypedLiterals.assertEquals((String)"1999-01-30T15:09:32Z", (String)lc.getLexicalForm());
        String urib = "rdf://test.com#";
        String uri1 = urib + "1";
        String urip = urib + "prop";
        String testN3 = "<" + uri1 + "> <" + urip + "> \"" + lc.getLexicalForm() + "\"^^<" + lc.getDatatypeURI() + "> .";
        StringReader sr = new StringReader(testN3);
        this.m.read((Reader)sr, urib, "N3");
        TestTypedLiterals.assertTrue((boolean)this.m.contains(this.m.getResource(uri1), this.m.getProperty(urip)));
        Resource r1 = this.m.getResource(uri1);
        Property p = this.m.getProperty(urip);
        XSDDateTime returnedDateTime = (XSDDateTime)r1.getProperty(p).getLiteral().getValue();
        TestTypedLiterals.assertEquals((String)"deserialized calendar value", (Object)testCal3, (Object)returnedDateTime.asCalendar());
        GregorianCalendar testCal4 = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        testCal4.set(1999, 4, 30, 15, 9, 32);
        testCal4.set(14, 25);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.025Z", 32.025);
        testCal4.set(14, 250);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.25Z", 32.25);
        testCal4.set(14, 2);
        this.doDateTimeTest(testCal4, "1999-05-30T15:09:32.002Z", 32.002);
        boolean ok = false;
        boolean old = JenaParameters.enableEagerLiteralValidation;
        try {
            JenaParameters.enableEagerLiteralValidation = true;
            l1 = this.m.createTypedLiteral((Object)new java.util.Date(12345656L), (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        catch (DatatypeFormatException e) {
            ok = true;
        }
        finally {
            JenaParameters.enableEagerLiteralValidation = old;
        }
        TestTypedLiterals.assertTrue((String)"Early detection of invalid literals", (boolean)ok);
        l1 = this.m.createTypedLiteral("1999-05-31", (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDdate, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xdt.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xdt.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)31, (int)xdt.getDays());
        try {
            xdt.getHours();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("12:56:32", (RDFDatatype)XSDDatatype.XSDtime);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDtime, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)12, (int)xdt.getHours());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)56, (int)xdt.getMinutes());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)32, (int)xdt.getFullSeconds());
        try {
            xdt.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("1999-05", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYearMonth, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xdt.getYears());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xdt.getMonths());
        try {
            xdt.getDays();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("1999", (RDFDatatype)XSDDatatype.XSDgYear);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgYear, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)1999, (int)xdt.getYears());
        try {
            xdt.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("--05--", (RDFDatatype)XSDDatatype.XSDgMonth);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonth, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xdt.getMonths());
        try {
            xdt.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("--05-25", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgMonthDay, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)5, (int)xdt.getMonths());
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xdt.getDays());
        try {
            xdt.getYears();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        l1 = this.m.createTypedLiteral("---25", (RDFDatatype)XSDDatatype.XSDgDay);
        TestTypedLiterals.assertEquals((String)"dateTime data type", (Object)XSDDatatype.XSDgDay, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"dateTime java type", (Object)XSDDateTime.class, l1.getValue().getClass());
        xdt = (XSDDateTime)l1.getValue();
        TestTypedLiterals.assertEquals((String)"dateTime value", (int)25, (int)xdt.getDays());
        try {
            xdt.getMonths();
            TestTypedLiterals.assertTrue((String)"Failed to prevent illegal access", (boolean)false);
        }
        catch (IllegalDateTimeFieldException e) {
            // empty catch block
        }
        GregorianCalendar ncal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        ncal.set(2003, 11, 8, 10, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral((Calendar)ncal);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2003-12-08T10:50:42Z", (String)l1.getValue().toString());
        SimpleTimeZone pdt = new SimpleTimeZone(-28800000, "America/Los_Angeles");
        pdt.setStartRule(3, 1, 1, 0x6DDD00);
        pdt.setEndRule(9, -1, 1, 0x6DDD00);
        ncal = new GregorianCalendar(pdt);
        ncal.set(2004, 2, 21, 12, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral((Calendar)ncal);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2004-03-21T20:50:42Z", (String)l1.getValue().toString());
        ncal = new GregorianCalendar(pdt);
        ncal.set(2004, 3, 21, 12, 50, 42);
        ncal.set(14, 0);
        l1 = this.m.createTypedLiteral((Calendar)ncal);
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDatatype.XSDdateTime, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (Object)XSDDateTime.class, l1.getValue().getClass());
        TestTypedLiterals.assertEquals((String)"DateTime from date", (String)"2004-04-21T19:50:42Z", (String)l1.getValue().toString());
    }

    private void doDateTimeTest(Calendar cal, String lex, double time) {
        Literal lc4 = this.m.createTypedLiteral(cal);
        TestTypedLiterals.assertEquals((String)"serialization", (String)lex, (String)lc4.getValue().toString());
        TestTypedLiterals.assertEquals((String)"calendar ms test", (Object)this.m.createTypedLiteral(lex, (RDFDatatype)XSDDatatype.XSDdateTime), (Object)lc4);
        XSDDateTime dt4 = (XSDDateTime)lc4.getValue();
        TestTypedLiterals.assertTrue((String)"Fraction time check", (Math.abs(dt4.getSeconds() - time) < 1.0E-4 ? 1 : 0) != 0);
        TestTypedLiterals.assertEquals((Object)dt4.asCalendar(), (Object)cal);
    }

    public void testTypedContains() {
        Model model = ModelFactory.createDefaultModel();
        Property p = model.createProperty("urn:x-eg/p");
        Literal l1 = model.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l2 = model.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("sameas test", l1, l2);
        Resource a = model.createResource("urn:x-eg/a");
        a.addProperty(p, (RDFNode)l1);
        TestTypedLiterals.assertTrue((boolean)model.getGraph().contains(a.asNode(), p.asNode(), l1.asNode()));
        TestTypedLiterals.assertTrue((boolean)model.getGraph().contains(a.asNode(), p.asNode(), l2.asNode()));
    }

    public void testTypedQueries() {
        Model model = ModelFactory.createDefaultModel();
        Property p = model.createProperty("urn:x-eg/p");
        Literal l1 = model.createTypedLiteral("10", "http://www.w3.org/2001/XMLSchema#integer");
        Literal l2 = model.createTypedLiteral("010", "http://www.w3.org/2001/XMLSchema#integer");
        this.assertSameValueAs("sameas test", l1, l2);
        Resource a = model.createResource("urn:x-eg/a");
        a.addProperty(p, (RDFNode)l1);
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(null, p.asNode(), l1.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(null, p.asNode(), l2.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)model.getGraph().find(a.asNode(), p.asNode(), l2.asNode()).hasNext());
        TestTypedLiterals.assertTrue((boolean)model.getGraph().contains(a.asNode(), p.asNode(), l2.asNode()));
        Query q = new Query();
        q.addMatch(a.asNode(), p.asNode(), l2.asNode());
        ExtendedIterator qi = model.getGraph().queryHandler().prepareBindings(q, new Node[0]).executeBindings();
        TestTypedLiterals.assertTrue((boolean)qi.hasNext());
        TestTypedLiterals.assertTrue((boolean)model.listStatements(a, p, (RDFNode)l2).hasNext());
    }

    public void testIsValidLiteral() {
        Literal l = this.m.createTypedLiteral("1000", (RDFDatatype)XSDDatatype.XSDinteger);
        LiteralLabel ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedInt.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedLong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDunsignedShort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDpositiveInteger.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDbyte.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnegativeInteger.isValidLiteral(ll) ? 1 : 0) != 0);
        l = this.m.createTypedLiteral("-2", (RDFDatatype)XSDDatatype.XSDinteger);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDlong.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDint.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDshort.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedInt.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedLong.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDunsignedShort.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdecimal.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDpositiveInteger.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDstring.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDbyte.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnegativeInteger.isValidLiteral(ll));
        l = this.m.createTypedLiteral("4.5", (RDFDatatype)XSDDatatype.XSDfloat);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdouble.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDdecimal.isValidLiteral(ll) ? 1 : 0) != 0);
        Literal l2 = this.m.createTypedLiteral("foo", (RDFDatatype)XSDDatatype.XSDstring);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(l2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnormalizedString.isValidLiteral(l2.asNode().getLiteral()));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(l2.asNode().getLiteral()) ? 1 : 0) != 0);
        l = this.m.createTypedLiteral("foo bar");
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(ll) ? 1 : 0) != 0);
        l = this.m.createTypedLiteral("12");
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDstring.isValidLiteral(ll));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDint.isValidLiteral(ll) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue((Object)new Integer(10)));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDnonNegativeInteger.isValidValue((Object)new Integer(10)));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue((Object)new Integer(-10)) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDnonNegativeInteger.isValidValue((Object)"10") ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDfloat.isValidValue((Object)new Float("2.3")));
        TestTypedLiterals.assertTrue((boolean)XSDDatatype.XSDdouble.isValidValue((Object)new Double("2.3")));
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDfloat.isValidValue((Object)new Integer("2")) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((!XSDDatatype.XSDfloat.isValidValue((Object)new Double("2.3")) ? 1 : 0) != 0);
    }

    public void testBinary() {
        byte[] data = new byte[]{12, 42, 99};
        Literal l = this.m.createTypedLiteral((Object)data);
        LiteralLabel ll = l.asNode().getLiteral();
        TestTypedLiterals.assertEquals((String)"binary test 1", (Object)ll.getDatatype(), (Object)XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertEquals((String)"binary test 2", (String)"DCpj", (String)ll.getLexicalForm());
        LiteralLabel l2 = this.m.createTypedLiteral(ll.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        Object data2 = l2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3", (boolean)(data2 instanceof byte[]));
        byte[] data2b = (byte[])data2;
        TestTypedLiterals.assertEquals((String)"binary test 4", (int)data2b[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5", (int)data2b[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6", (int)data2b[2], (int)99);
        TestTypedLiterals.assertEquals((Object)l2, (Object)ll);
        l2 = this.m.createTypedLiteral("DCpj", (RDFDatatype)XSDDatatype.XSDbase64Binary).asNode().getLiteral();
        data2 = l2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3", (boolean)(data2 instanceof byte[]));
        data2b = (byte[])data2;
        TestTypedLiterals.assertEquals((String)"binary test 4", (int)data2b[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5", (int)data2b[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6", (int)data2b[2], (int)99);
        l = this.m.createTypedLiteral((Object)data, (RDFDatatype)XSDDatatype.XSDhexBinary);
        ll = l.asNode().getLiteral();
        TestTypedLiterals.assertEquals((String)"binary test 1b", (Object)ll.getDatatype(), (Object)XSDDatatype.XSDhexBinary);
        TestTypedLiterals.assertEquals((String)"binary test 2b", (String)HexBin.encode((byte[])data), (String)ll.getLexicalForm());
        l2 = this.m.createTypedLiteral(ll.getLexicalForm(), (RDFDatatype)XSDDatatype.XSDhexBinary).asNode().getLiteral();
        data2 = l2.getValue();
        TestTypedLiterals.assertTrue((String)"binary test 3b", (boolean)(data2 instanceof byte[]));
        data2b = (byte[])data2;
        TestTypedLiterals.assertEquals((String)"binary test 4b", (int)data2b[0], (int)12);
        TestTypedLiterals.assertEquals((String)"binary test 5b", (int)data2b[1], (int)42);
        TestTypedLiterals.assertEquals((String)"binary test 6b", (int)data2b[2], (int)99);
        TestTypedLiterals.assertEquals((Object)l2, (Object)ll);
        Literal la = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        Literal lb = this.m.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        TestTypedLiterals.assertTrue((String)"equality test", (boolean)la.sameValueAs(lb));
        data = new byte[]{15, -73};
        l = this.m.createTypedLiteral((Object)data, (RDFDatatype)XSDDatatype.XSDhexBinary);
        TestTypedLiterals.assertEquals((String)"hexBinary encoding", (String)"0FB7", (String)l.getLexicalForm());
    }

    public void XXtestBinaryBug() throws IOException {
        Model orig = ModelFactory.createDefaultModel();
        Resource r = orig.createResource("http://jena.hpl.hp.com/test#r");
        Property p = orig.createProperty("http://jena.hpl.hp.com/test#p");
        Literal l = orig.createTypedLiteral("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary);
        orig.add(r, p, (RDFNode)l);
        for (int i = 0; i < 150; ++i) {
            l = orig.createTypedLiteral((Object)new byte[]{(byte)i, (byte)i, (byte)i});
            orig.add(orig.createResource("urn:x-hp:" + i), p, (RDFNode)l);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        orig.write((OutputStream)out, "RDF/XML-ABBREV");
        out.close();
        ByteArrayInputStream ins = new ByteArrayInputStream(out.toByteArray());
        Model m2 = ModelFactory.createDefaultModel();
        m2.read((InputStream)ins, null);
        ((InputStream)ins).close();
        TestTypedLiterals.assertTrue((boolean)orig.isIsomorphicWith(m2));
    }

    public void testDateTimeBug() {
        String XSDDateURI = XSD.date.getURI();
        TypeMapper typeMapper = TypeMapper.getInstance();
        RDFDatatype dt = typeMapper.getSafeTypeByName(XSDDateURI);
        Object obj = dt.parse("2003-05-21");
        Literal literal = this.m.createTypedLiteral(obj, dt);
        literal.toString();
        Object value2 = dt.parse(obj.toString());
        TestTypedLiterals.assertEquals((Object)obj, (Object)value2);
        XSDDatatype dateType = XSDDatatype.XSDdate;
        this.m.createTypedLiteral("2003-05-21", (RDFDatatype)dateType);
        this.checkSerialization("2003-05-21", (RDFDatatype)XSDDatatype.XSDdate);
        this.checkSerialization("2003-05-21T12:56:10Z", (RDFDatatype)XSDDatatype.XSDdateTime);
        this.checkSerialization("2003-05", (RDFDatatype)XSDDatatype.XSDgYearMonth);
        this.checkSerialization("2003", (RDFDatatype)XSDDatatype.XSDgYear);
        this.checkSerialization("--05", (RDFDatatype)XSDDatatype.XSDgMonth);
        this.checkSerialization("--05-12", (RDFDatatype)XSDDatatype.XSDgMonthDay);
        this.checkSerialization("---12", (RDFDatatype)XSDDatatype.XSDgDay);
    }

    public void testFlags() {
        boolean originalFlag = JenaParameters.enableEagerLiteralValidation;
        JenaParameters.enableEagerLiteralValidation = true;
        boolean foundException = false;
        try {
            this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException e1) {
            foundException = true;
        }
        JenaParameters.enableEagerLiteralValidation = originalFlag;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)foundException);
        JenaParameters.enableEagerLiteralValidation = false;
        foundException = false;
        Literal l = null;
        try {
            l = this.m.createTypedLiteral("fool", (RDFDatatype)XSDDatatype.XSDint);
        }
        catch (DatatypeFormatException e1) {
            JenaParameters.enableEagerLiteralValidation = originalFlag;
            TestTypedLiterals.assertTrue((String)"Delayed datatype format validation", (boolean)false);
        }
        try {
            l.getValue();
        }
        catch (DatatypeFormatException e2) {
            foundException = true;
        }
        JenaParameters.enableEagerLiteralValidation = originalFlag;
        TestTypedLiterals.assertTrue((String)"Early datatype format exception", (boolean)foundException);
        originalFlag = JenaParameters.enablePlainLiteralSameAsString;
        Literal l1 = this.m.createLiteral("test string");
        Literal l2 = this.m.createTypedLiteral("test string", (RDFDatatype)XSDDatatype.XSDstring);
        JenaParameters.enablePlainLiteralSameAsString = true;
        boolean ok1 = l1.sameValueAs(l2);
        JenaParameters.enablePlainLiteralSameAsString = false;
        boolean ok2 = !l1.sameValueAs(l2);
        JenaParameters.enablePlainLiteralSameAsString = originalFlag;
        TestTypedLiterals.assertTrue((boolean)ok1);
        TestTypedLiterals.assertTrue((boolean)ok2);
    }

    public void testLexicalDistinction() {
        Literal l1 = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal l2 = this.m.createTypedLiteral("3.00", (RDFDatatype)XSDDatatype.XSDdecimal);
        Literal l3 = this.m.createTypedLiteral("3.0", (RDFDatatype)XSDDatatype.XSDdecimal);
        this.assertSameValueAs("lexical form does not affect value", l1, l2);
        this.assertSameValueAs("lexical form does not affect value", l3, l2);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (!l1.equals(l2) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (boolean)l1.equals(l3));
        l1 = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        l2 = this.m.createTypedLiteral(" 3 ", (RDFDatatype)XSDDatatype.XSDint);
        l3 = this.m.createTypedLiteral("3", (RDFDatatype)XSDDatatype.XSDint);
        this.assertSameValueAs("lexical form does not affect value", l1, l2);
        this.assertSameValueAs("lexical form does not affect value", l3, l2);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (!l1.equals(l2) ? 1 : 0) != 0);
        TestTypedLiterals.assertTrue((String)"lexical form affects equality", (boolean)l1.equals(l3));
    }

    public void testRoundTrip() {
        this.doTestRoundTrip("13:20:00.000", (RDFDatatype)XSDDatatype.XSDtime, false);
        this.doTestRoundTrip("GpM7", (RDFDatatype)XSDDatatype.XSDbase64Binary, true);
        this.doTestRoundTrip("0FB7", (RDFDatatype)XSDDatatype.XSDhexBinary, true);
        this.doTestValueRoundTrip("2005-06-27", (RDFDatatype)XSDDatatype.XSDdate, true);
        this.doTestValueRoundTrip("2005", (RDFDatatype)XSDDatatype.XSDgYear, true);
        this.doTestValueRoundTrip("2005-06", (RDFDatatype)XSDDatatype.XSDgYearMonth, true);
        this.doTestValueRoundTrip("13:20:00.000", (RDFDatatype)XSDDatatype.XSDtime, true);
    }

    public void doTestRoundTrip(String lex, RDFDatatype dt, boolean testeq) {
        LiteralLabel ll = LiteralLabel.createLiteralLabel((String)lex, (String)"", (RDFDatatype)dt);
        String lex2 = dt.unparse(ll.getValue());
        if (testeq) {
            TestTypedLiterals.assertEquals((String)lex, (String)lex2);
        }
        LiteralLabel ll2 = LiteralLabel.createLiteralLabel((String)lex2, (String)"", (RDFDatatype)dt);
        TestTypedLiterals.assertTrue((boolean)ll2.isWellFormed());
    }

    public void doTestValueRoundTrip(String lex, RDFDatatype dt, boolean testType) {
        Literal l1 = this.m.createTypedLiteral(lex, dt);
        Object o1 = l1.getValue();
        Literal l2 = this.m.createTypedLiteral(o1);
        TestTypedLiterals.assertTrue((String)"value round trip", (boolean)l1.sameValueAs(l2));
        Object o2 = l2.getValue();
        TestTypedLiterals.assertTrue((String)"value round trip2", (boolean)o1.equals(o2));
        if (testType) {
            TestTypedLiterals.assertEquals((String)"Datatype round trip", (Object)dt, (Object)l2.getDatatype());
        }
    }

    public void testDateOverride() {
        GregorianCalendar date = new GregorianCalendar(2007, 3, 4);
        ((Calendar)date).setTimeZone(TimeZone.getTimeZone("GMT+0"));
        XSDDateTime xsdDate = new XSDDateTime((Calendar)date);
        Literal l1 = this.m.createTypedLiteral((Object)xsdDate, (RDFDatatype)XSDDatatype.XSDdate);
        TestTypedLiterals.assertEquals((Object)XSDDatatype.XSDdate, (Object)l1.getDatatype());
        TestTypedLiterals.assertEquals((String)"2007-04-04Z", (String)l1.getLexicalForm());
    }

    private void assertDiffer(String title, Literal x, Literal y) {
        TestTypedLiterals.assertTrue((String)title, (!x.sameValueAs(y) ? 1 : 0) != 0);
    }

    private void assertSameValueAs(String title, Literal x, Literal y) {
        TestTypedLiterals.assertTrue((String)title, (boolean)x.sameValueAs(y));
    }

    private void assertFloatEquals(String title, double x, double y) {
        TestTypedLiterals.assertTrue((String)title, (Math.abs(x - y) < 0.001 ? 1 : 0) != 0);
    }

    public void checkIllegalLiteral(String lex, RDFDatatype dtype) {
        try {
            Literal l = this.m.createTypedLiteral(lex, dtype);
            l.getValue();
            TestTypedLiterals.assertTrue((String)("Failed to catch '" + lex + "' as an illegal " + dtype), (boolean)false);
        }
        catch (DatatypeFormatException datatypeFormatException) {
            // empty catch block
        }
    }

    public void checkLegalLiteral(String lex, RDFDatatype dtype, Class jtype, Object value) {
        Literal l = this.m.createTypedLiteral(lex, dtype);
        TestTypedLiterals.assertEquals(l.getValue().getClass(), (Object)jtype);
        TestTypedLiterals.assertEquals((Object)l.getValue(), (Object)value);
        TestTypedLiterals.assertEquals((Object)l.getDatatype(), (Object)dtype);
    }

    public void checkSerialization(String lex, RDFDatatype dtype) {
        Literal l = this.m.createTypedLiteral(lex, dtype);
        TestTypedLiterals.assertEquals((String)l.getValue().toString(), (String)lex);
    }

    public void assertIteratorValues(Iterator it, Object[] vals) {
        int i;
        boolean[] found = new boolean[vals.length];
        for (i = 0; i < vals.length; ++i) {
            found[i] = false;
        }
        while (it.hasNext()) {
            Object n = it.next();
            boolean gotit = false;
            for (int i2 = 0; i2 < vals.length; ++i2) {
                if (!n.equals(vals[i2])) continue;
                gotit = true;
                found[i2] = true;
            }
            TestTypedLiterals.assertTrue((boolean)gotit);
        }
        for (i = 0; i < vals.length; ++i) {
            TestTypedLiterals.assertTrue((boolean)found[i]);
        }
    }
}

