/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.abstract_syntax;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.io.abstract_syntax.ANTLRParserTokenTypes;
import org.semanticweb.owl.io.abstract_syntax.MalformedOWLPropertyURIException;
import org.semanticweb.owl.io.abstract_syntax.MalformedOWLURIException;
import org.semanticweb.owl.io.abstract_syntax.SomeUndefinedOWLPropertyException;
import org.semanticweb.owl.io.abstract_syntax.SomeUndefinedOWLPropertyHandler;
import org.semanticweb.owl.io.abstract_syntax.SomeUndefinedOWLPropertyLaxHandler;
import org.semanticweb.owl.io.abstract_syntax.UndefinedOWLPropertyException;
import org.semanticweb.owl.io.abstract_syntax.UndefinedOWLPropertyTypeException;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDeprecatableObject;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLRestriction;
import org.semanticweb.owl.model.helper.OWLBuilder;

public class ANTLRParser
extends LLkParser
implements ANTLRParserTokenTypes {
    static Logger logger = Logger.getLogger("ANTLRParser");
    public OWLBuilder builder;
    public static final String DATA_PROPERTY = "Data Property";
    public static final String OBJ_PROP = "Object Property";
    public static final String ANN_PROP = "Annotation Property";
    public static final String ONTO_PROP = "Ontology Property";
    Map idsTable = new HashMap();
    Map namespaceTable = new HashMap();
    public static final URI RDFS_LIT_URI = URI.create("http://www.w3.org/2000/01/rdf-schema#Literal");
    public static final int DATA_PROP_INT = 1;
    public static final int OBJ_PROP_INT = 2;
    public static final int ANN_PROP_INT = 3;
    public static final int ONT_PROP_INT = 4;
    SomeUndefinedOWLPropertyHandler propertyHandler = new SomeUndefinedOWLPropertyLaxHandler();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "EQUAL", "UNDERSCORE", "PLUS", "DASH", "QUOTE", "AT", "COLON", "LPAREN", "RPAREN", "LANGLE", "RANGLE", "DOUBLE_CARET", "WS", "ORDER_ENFORCING_DUMMY_TOKEN", "NAMESPACE", "ONTOLOGY_PROPERTY", "ONTOLOGY", "ANNOTATION_PROPERTY", "ANNOTATION", "CLASS", "ENUMERATED_CLASS", "DISJOINT_CLASSES", "EQUIVALENT_CLASSES", "SUB_CLASS_OF", "DATATYPE_PROPERTY", "DATATYPE", "SUPER", "DOMAIN", "RANGE", "OBJECT_PROPERTY", "INVERSE_OF", "SYMMETRIC", "FUNCTIONAL", "INVERSE_FUNCTIONAL", "TRANSITIVE", "EQUIVALENT_PROPERTIES", "SUB_PROPERTY_OF", "RESTRICTION", "UNION_OF", "INTERSECTION_OF", "COMPLEMENT_OF", "ONE_OF", "ALL_VALUES_FROM", "SOME_VALUES_FROM", "VALUE", "MIN_CARDINALITY", "MAX_CARDINALITY", "CARDINALITY", "SAME_INDIVIDUAL", "DIFFERENT_INDIVIDUALS", "INDIVIDUAL", "TYPE", "ANNOTATION_LOWER", "RDFSLITERAL", "DEPRECATED", "PARTIAL", "COMPLETE", "CARD", "URI_ID", "LOWER_ROMAN", "LETTER", "ARABIC_DIGIT", "DIGIT_NON_ARABIC", "QUOTED_STRING", "ESC", "SL_COMMENT", "ML_COMMENT", "REF_PREFIX", "PREFIX", "LANGUAGE", "LOCAL_NAME", "VOCAB"};
    public static final BitSet _tokenSet_0 = new BitSet(ANTLRParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(ANTLRParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(ANTLRParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(ANTLRParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(ANTLRParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(ANTLRParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(ANTLRParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(ANTLRParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(ANTLRParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(ANTLRParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(ANTLRParser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(ANTLRParser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(ANTLRParser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(ANTLRParser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(ANTLRParser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(ANTLRParser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(ANTLRParser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(ANTLRParser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(ANTLRParser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(ANTLRParser.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(ANTLRParser.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(ANTLRParser.mk_tokenSet_21());
    public static final BitSet _tokenSet_22 = new BitSet(ANTLRParser.mk_tokenSet_22());
    public static final BitSet _tokenSet_23 = new BitSet(ANTLRParser.mk_tokenSet_23());
    public static final BitSet _tokenSet_24 = new BitSet(ANTLRParser.mk_tokenSet_24());
    public static final BitSet _tokenSet_25 = new BitSet(ANTLRParser.mk_tokenSet_25());

    public Map getIdsTable() {
        return this.idsTable;
    }

    public void setIdsTable(Map newIdsTable) {
        this.idsTable = newIdsTable;
    }

    public Map getNamespaceTable() {
        return this.namespaceTable;
    }

    public void setNamespaceTable(Map newNamespaceTable) {
        this.namespaceTable = newNamespaceTable;
    }

    public void setPropertyHandler(SomeUndefinedOWLPropertyHandler handler) {
        this.propertyHandler = handler;
    }

    public int inferPropertyType(Set ids) throws UndefinedOWLPropertyException, UndefinedOWLPropertyTypeException, SomeUndefinedOWLPropertyException {
        boolean isSomeUndefined = false;
        Iterator i = ids.iterator();
        while (i.hasNext()) {
            String idType = (String)this.idsTable.get((String)i.next());
            if (idType == null) {
                isSomeUndefined = true;
                continue;
            }
            if (isSomeUndefined) {
                this.propertyHandler.handle(new SomeUndefinedOWLPropertyException(ANTLRParser.getIntValue(idType)));
            }
            return ANTLRParser.getIntValue(idType);
        }
        throw new UndefinedOWLPropertyException(ids);
    }

    static int getIntValue(String propertyType) throws UndefinedOWLPropertyTypeException {
        if (propertyType.equals(DATA_PROPERTY)) {
            return 1;
        }
        if (propertyType.equals(OBJ_PROP)) {
            return 2;
        }
        if (propertyType.equals(ANN_PROP)) {
            return 3;
        }
        if (propertyType.equals(ONTO_PROP)) {
            return 4;
        }
        throw new UndefinedOWLPropertyTypeException(propertyType);
    }

    static URI createURI(String uriString) throws MalformedOWLURIException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new MalformedOWLURIException(uriString, e);
        }
    }

    static String removeHeadAndTail(String s) {
        return s.substring(1, s.length() - 1);
    }

    static String removeTail(String s) {
        return s.substring(0, s.length() - 1);
    }

    protected ANTLRParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public ANTLRParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected ANTLRParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public ANTLRParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public ANTLRParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final OWLOntology ontology(URI physicalURI, OWLBuilder builder) throws RecognitionException, TokenStreamException, OWLException {
        this.builder = builder;
        this.idsTable = new HashMap();
        OWLOntology owlOntology = null;
        URI id = null;
        try {
            while (this.LA(1) == 18) {
                this.namespace();
            }
            this.match(20);
            switch (this.LA(1)) {
                case 62: 
                case 71: {
                    id = this.ontologyID();
                    break;
                }
                case 12: 
                case 19: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 33: 
                case 39: 
                case 40: 
                case 52: 
                case 53: 
                case 54: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            builder.createOntology(id, physicalURI);
            while (_tokenSet_0.member(this.LA(1))) {
                this.directive();
            }
            this.match(12);
            owlOntology = builder.getOntology();
            logger.fine(this.namespaceTable.toString());
            logger.fine(this.idsTable.toString());
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_1);
        }
        return owlOntology;
    }

    public final void namespace() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token u = null;
        try {
            this.match(18);
            p = this.LT(1);
            this.match(72);
            String prefix = p.getText();
            this.match(4);
            u = this.LT(1);
            this.match(62);
            String uri = ANTLRParser.removeHeadAndTail(u.getText());
            this.match(12);
            this.namespaceTable.put(prefix, uri);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_2);
        }
    }

    public final URI ontologyID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return uri;
    }

    public final void directive() throws RecognitionException, TokenStreamException, OWLException {
        try {
            switch (this.LA(1)) {
                case 22: {
                    URI content;
                    this.match(22);
                    URI id = this.annotationPropertyID();
                    OWLAnnotationProperty prop = this.builder.addAnnotationProperty(id);
                    switch (this.LA(1)) {
                        case 62: 
                        case 71: {
                            content = this.uriReference();
                            break;
                        }
                        case 54: {
                            OWLIndividual indiv = this.individual();
                            content = indiv;
                            break;
                        }
                        case 67: {
                            OWLDataValue dLit = this.dataLiteral();
                            content = dLit;
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    OWLBuilder.AnnotationComponent annComponent = new OWLBuilder.AnnotationComponent(prop, (Object)content);
                    this.builder.addOntologyAnnotationInstance(annComponent);
                    this.match(12);
                    break;
                }
                case 52: 
                case 53: 
                case 54: {
                    this.fact();
                    break;
                }
                case 19: 
                case 21: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 33: 
                case 39: 
                case 40: {
                    this.axiom();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final URI annotationPropertyID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_4);
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    public final URI uriReference() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        Token u = null;
        URI uri = null;
        try {
            void var3_3;
            switch (this.LA(1)) {
                case 62: {
                    u = this.LT(1);
                    this.match(62);
                    String id = ANTLRParser.removeHeadAndTail(u.getText());
                    break;
                }
                case 71: {
                    String[] qn = this.qname();
                    String id = this.namespaceTable.get(qn[0]) + qn[1];
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            uri = ANTLRParser.createURI((String)var3_3);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_5);
        }
        return uri;
    }

    public final OWLIndividual individual() throws RecognitionException, TokenStreamException, OWLException {
        URI id = null;
        OWLIndividual indiv = null;
        try {
            this.match(54);
            switch (this.LA(1)) {
                case 62: 
                case 71: {
                    id = this.individualID();
                    break;
                }
                case 12: 
                case 48: 
                case 55: 
                case 56: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            indiv = this.builder.addIndividual(id);
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)indiv, annComponent);
            }
            while (this.LA(1) == 55) {
                this.match(55);
                OWLDescription descr = this.type();
                this.builder.addDescriptionToIndividual(descr, indiv);
                this.match(12);
            }
            while (this.LA(1) == 48) {
                OWLBuilder.PropertyValue val = this.value();
                this.builder.addPropertyValue(indiv, val);
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return indiv;
    }

    public final OWLDataValue dataLiteral() throws RecognitionException, TokenStreamException, OWLException {
        OWLDataValue literal = null;
        try {
            literal = this.datatypeString();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_6);
        }
        return literal;
    }

    public final void fact() throws RecognitionException, TokenStreamException, OWLException {
        HashSet<URI> individuals = new HashSet<URI>();
        try {
            switch (this.LA(1)) {
                case 54: {
                    this.individual();
                    break;
                }
                case 52: {
                    this.match(52);
                    URI id = this.individualID();
                    individuals.add(id);
                    int _cnt13 = 0;
                    while (true) {
                        if (this.LA(1) != 62 && this.LA(1) != 71) {
                            if (_cnt13 >= 1) break;
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        id = this.individualID();
                        individuals.add(id);
                        ++_cnt13;
                    }
                    this.match(12);
                    this.builder.addSameIndividualsAxiom(individuals);
                    break;
                }
                case 53: {
                    this.match(53);
                    URI id = this.individualID();
                    individuals.add(id);
                    int _cnt15 = 0;
                    while (true) {
                        if (this.LA(1) != 62 && this.LA(1) != 71) {
                            if (_cnt15 >= 1) break;
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                        id = this.individualID();
                        individuals.add(id);
                        ++_cnt15;
                    }
                    this.match(12);
                    this.builder.addDifferentIndividualsAxiom(individuals);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final void axiom() throws RecognitionException, TokenStreamException, OWLException {
        try {
            switch (this.LA(1)) {
                case 23: {
                    this.owlClass();
                    break;
                }
                case 24: {
                    this.enumeratedClass();
                    break;
                }
                case 25: {
                    this.disjointClasses();
                    break;
                }
                case 26: {
                    this.equivalentClasses();
                    break;
                }
                case 27: {
                    this.subClass();
                    break;
                }
                case 29: {
                    this.dataType();
                    break;
                }
                case 28: {
                    this.dataTypeProperty();
                    break;
                }
                case 33: {
                    this.objectProperty();
                    break;
                }
                case 21: {
                    this.annotationProperty();
                    break;
                }
                case 19: {
                    this.ontologyProperty();
                    break;
                }
                case 39: {
                    this.equivalentProperties();
                    break;
                }
                case 40: {
                    this.subprop();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final URI individualID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_7);
        }
        return uri;
    }

    /*
     * WARNING - void declaration
     */
    public final OWLBuilder.AnnotationComponent annotation() throws RecognitionException, TokenStreamException, OWLException {
        OWLBuilder.AnnotationComponent aComponent = null;
        try {
            void var3_4;
            this.match(56);
            URI id = this.annotationPropertyID();
            OWLAnnotationProperty annProp = this.builder.addAnnotationProperty(id);
            switch (this.LA(1)) {
                case 62: 
                case 71: {
                    URI content = this.uriReference();
                    break;
                }
                case 67: {
                    URI content = this.dataLiteral();
                    break;
                }
                case 54: {
                    URI content = this.individual();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.match(12);
            aComponent = new OWLBuilder.AnnotationComponent(annProp, (Object)var3_4);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_8);
        }
        return aComponent;
    }

    public final OWLDescription type() throws RecognitionException, TokenStreamException, OWLException {
        OWLDescription result = null;
        try {
            result = this.description();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_9);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final OWLBuilder.PropertyValue value() throws RecognitionException, TokenStreamException, OWLException {
        OWLBuilder.DataPropertyValue val = null;
        try {
            this.match(48);
            URI propId = this.uriReference();
            String id = propId.toString();
            String idType = (String)this.idsTable.get(id);
            if (idType == null) {
                throw new UndefinedOWLPropertyException(id);
            }
            if (this.LA(1) == 67 && idType.equals(DATA_PROPERTY)) {
                OWLDataValue dLit = this.dataLiteral();
                OWLDataProperty dProp = this.builder.addDataProperty(propId);
                val = new OWLBuilder.DataPropertyValue(dProp, dLit);
            } else if (this.LA(1) == 54 || this.LA(1) == 62 || this.LA(1) == 71) {
                void var4_9;
                OWLObjectProperty prop = this.builder.addObjectProperty(propId);
                switch (this.LA(1)) {
                    case 54: {
                        OWLIndividual indiv = this.individual();
                        break;
                    }
                    case 62: 
                    case 71: {
                        URI indId = this.individualID();
                        OWLIndividual indiv = this.builder.addIndividual(indId);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                val = new OWLBuilder.ObjectPropertyValue(prop, (OWLIndividual)var4_9);
            } else {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_10);
        }
        return val;
    }

    public final OWLDescription description() throws RecognitionException, TokenStreamException, OWLException {
        OWLRestriction result = null;
        HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
        HashSet<URI> individuals = new HashSet<URI>();
        try {
            switch (this.LA(1)) {
                case 62: 
                case 71: {
                    URI id = this.classID();
                    result = this.builder.getClass(id);
                    break;
                }
                case 41: {
                    result = this.restriction();
                    break;
                }
                case 42: {
                    this.match(42);
                    while (_tokenSet_11.member(this.LA(1))) {
                        OWLDescription descr = this.description();
                        descriptions.add(descr);
                    }
                    this.match(12);
                    result = this.builder.unionOf(descriptions);
                    break;
                }
                case 43: {
                    this.match(43);
                    while (_tokenSet_11.member(this.LA(1))) {
                        OWLDescription descr = this.description();
                        descriptions.add(descr);
                    }
                    this.match(12);
                    result = this.builder.intersectionOf(descriptions);
                    break;
                }
                case 44: {
                    this.match(44);
                    OWLDescription descr = this.description();
                    this.match(12);
                    result = this.builder.complementOf(descr);
                    break;
                }
                case 45: {
                    this.match(45);
                    while (this.LA(1) == 62 || this.LA(1) == 71) {
                        URI id = this.individualID();
                        individuals.add(id);
                    }
                    this.match(12);
                    result = this.builder.oneOf(individuals);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_12);
        }
        return result;
    }

    public final OWLClass owlClass() throws RecognitionException, TokenStreamException, OWLException {
        boolean isPartial = false;
        HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
        OWLClass oClass = null;
        try {
            this.match(23);
            URI id = this.classID();
            oClass = this.builder.addClass(id);
            switch (this.LA(1)) {
                case 58: {
                    this.match(58);
                    this.builder.setDeprecatedObject((OWLDeprecatableObject)oClass);
                    break;
                }
                case 59: 
                case 60: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            isPartial = this.modality();
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent aComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)oClass, aComponent);
            }
            while (_tokenSet_11.member(this.LA(1))) {
                OWLDescription descr = this.description();
                descriptions.add(descr);
            }
            if (!descriptions.isEmpty()) {
                if (isPartial) {
                    this.builder.addSuperClass(oClass, descriptions);
                } else {
                    this.builder.addEquivalentClass(oClass, descriptions);
                }
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return oClass;
    }

    public final OWLClass enumeratedClass() throws RecognitionException, TokenStreamException, OWLException {
        HashSet<URI> individuals = new HashSet<URI>();
        OWLClass eClass = null;
        try {
            this.match(24);
            URI id = this.classID();
            eClass = this.builder.addClass(id);
            switch (this.LA(1)) {
                case 58: {
                    this.match(58);
                    this.builder.setDeprecatedObject((OWLDeprecatableObject)eClass);
                    break;
                }
                case 12: 
                case 56: 
                case 62: 
                case 71: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)eClass, annComponent);
            }
            while (this.LA(1) == 62 || this.LA(1) == 71) {
                URI iid = this.individualID();
                individuals.add(iid);
            }
            this.match(12);
            this.builder.addEnumeration(eClass, individuals);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return eClass;
    }

    public final void disjointClasses() throws RecognitionException, TokenStreamException, OWLException {
        HashSet<OWLDescription> disjuncts = new HashSet<OWLDescription>();
        try {
            this.match(25);
            OWLDescription owlDescription = this.description();
            disjuncts.add(owlDescription);
            owlDescription = this.description();
            disjuncts.add(owlDescription);
            while (_tokenSet_11.member(this.LA(1))) {
                owlDescription = this.description();
                disjuncts.add(owlDescription);
            }
            this.match(12);
            this.builder.addDisjointClassesAxiom(disjuncts);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final void equivalentClasses() throws RecognitionException, TokenStreamException, OWLException {
        HashSet<OWLDescription> equivalents = new HashSet<OWLDescription>();
        try {
            this.match(26);
            OWLDescription owlDescription = this.description();
            equivalents.add(owlDescription);
            while (_tokenSet_11.member(this.LA(1))) {
                owlDescription = this.description();
                equivalents.add(owlDescription);
            }
            this.match(12);
            this.builder.addEquivalentClassesAxiom(equivalents);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final void subClass() throws RecognitionException, TokenStreamException, OWLException {
        try {
            this.match(27);
            OWLDescription owlDescription1 = this.description();
            OWLDescription owlDescription2 = this.description();
            this.match(12);
            this.builder.addSubClassAxiom(owlDescription1, owlDescription2);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final OWLDataType dataType() throws RecognitionException, TokenStreamException, OWLException {
        OWLDataType type = null;
        try {
            this.match(29);
            URI id = this.datatypeID();
            type = this.builder.addDataType(id);
            switch (this.LA(1)) {
                case 58: {
                    this.match(58);
                    this.builder.setDeprecatedObject((OWLDeprecatableObject)type);
                    break;
                }
                case 12: 
                case 56: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)type, annComponent);
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return type;
    }

    public final OWLDataProperty dataTypeProperty() throws RecognitionException, TokenStreamException, OWLException {
        OWLDataProperty prop = null;
        try {
            this.match(28);
            URI id = this.datavaluedPropertyID();
            this.idsTable.put(id.toString(), DATA_PROPERTY);
            prop = this.builder.addDataProperty(id);
            switch (this.LA(1)) {
                case 58: {
                    this.match(58);
                    this.builder.setDeprecatedObject((OWLDeprecatableObject)prop);
                    break;
                }
                case 12: 
                case 30: 
                case 31: 
                case 32: 
                case 36: 
                case 56: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)prop, annComponent);
            }
            while (this.LA(1) == 30) {
                this.match(30);
                URI superId = this.datavaluedPropertyID();
                this.idsTable.put(superId.toString(), DATA_PROPERTY);
                OWLDataProperty superProp = this.builder.addDataProperty(superId);
                this.builder.addSuperProperty((OWLProperty)prop, (OWLProperty)superProp);
                this.match(12);
            }
            switch (this.LA(1)) {
                case 36: {
                    this.match(36);
                    this.builder.setDataPropertyFunctional(prop);
                    break;
                }
                case 12: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 31) {
                this.match(31);
                OWLDescription descr = this.description();
                this.builder.addPropertyDomain((OWLProperty)prop, descr);
                this.match(12);
            }
            while (this.LA(1) == 32) {
                this.match(32);
                OWLDataRange dRange = this.dataRange();
                this.builder.addDataPropertyRange(prop, dRange);
                this.match(12);
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return prop;
    }

    public final OWLObjectProperty objectProperty() throws RecognitionException, TokenStreamException, OWLException {
        OWLObjectProperty prop = null;
        try {
            OWLDescription descr;
            this.match(33);
            URI id = this.individualvaluedPropertyID();
            this.idsTable.put(id.toString(), OBJ_PROP);
            prop = this.builder.addObjectProperty(id);
            switch (this.LA(1)) {
                case 58: {
                    this.match(58);
                    this.builder.setDeprecatedObject((OWLDeprecatableObject)prop);
                    break;
                }
                case 12: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 56: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)prop, annComponent);
            }
            while (this.LA(1) == 30) {
                this.match(30);
                URI superId = this.individualvaluedPropertyID();
                this.idsTable.put(superId.toString(), OBJ_PROP);
                OWLObjectProperty superProp = this.builder.addObjectProperty(superId);
                this.builder.addSuperProperty((OWLProperty)prop, (OWLProperty)superProp);
                this.match(12);
            }
            switch (this.LA(1)) {
                case 34: {
                    this.match(34);
                    URI inverseId = this.individualvaluedPropertyID();
                    this.idsTable.put(inverseId.toString(), OBJ_PROP);
                    this.builder.addInverse(prop, inverseId);
                    this.match(12);
                    break;
                }
                case 12: 
                case 31: 
                case 32: 
                case 35: 
                case 36: 
                case 37: 
                case 38: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 35: {
                    this.match(35);
                    this.builder.setPropertyType(prop, 11);
                    break;
                }
                case 12: 
                case 31: 
                case 32: 
                case 36: 
                case 37: 
                case 38: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            switch (this.LA(1)) {
                case 36: {
                    this.match(36);
                    this.builder.setPropertyType(prop, 12);
                    break;
                }
                case 37: {
                    this.match(37);
                    this.builder.setPropertyType(prop, 13);
                    break;
                }
                case 38: {
                    this.match(38);
                    this.builder.setPropertyType(prop, 14);
                    break;
                }
                case 12: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            while (this.LA(1) == 31) {
                this.match(31);
                descr = this.description();
                this.builder.addPropertyDomain((OWLProperty)prop, descr);
                this.match(12);
            }
            while (this.LA(1) == 32) {
                this.match(32);
                descr = this.description();
                this.builder.addObjectPropertyRange(prop, descr);
                this.match(12);
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return prop;
    }

    public final OWLAnnotationProperty annotationProperty() throws RecognitionException, TokenStreamException, OWLException {
        OWLAnnotationProperty prop = null;
        try {
            this.match(21);
            URI id = this.annotationPropertyID();
            this.idsTable.put(id.toString(), ANN_PROP);
            prop = this.builder.addAnnotationProperty(id);
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
                this.builder.addAnnotationInstance((OWLObject)prop, annComponent);
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
        return prop;
    }

    public final void ontologyProperty() throws RecognitionException, TokenStreamException, OWLException {
        try {
            this.match(19);
            URI id = this.ontologyPropertyID();
            while (this.LA(1) == 56) {
                OWLBuilder.AnnotationComponent annComponent = this.annotation();
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final void equivalentProperties() throws RecognitionException, TokenStreamException, OWLException {
        HashSet<String> ids = new HashSet<String>();
        try {
            this.match(39);
            URI uri = this.uriReference();
            ids.add(uri.toString());
            int _cnt84 = 0;
            while (true) {
                if (this.LA(1) != 62 && this.LA(1) != 71) {
                    if (_cnt84 >= 1) break;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                uri = this.uriReference();
                ids.add(uri.toString());
                ++_cnt84;
            }
            this.match(12);
            switch (this.inferPropertyType(ids)) {
                case 1: {
                    try {
                        this.builder.addEquivalentDataPropertiesAxiom(OWLBuilder.toURIs(ids));
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new MalformedOWLPropertyURIException(ids, (Exception)e);
                    }
                }
                case 2: {
                    try {
                        this.builder.addEquivalentObjectPropertiesAxiom(OWLBuilder.toURIs(ids));
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new MalformedOWLPropertyURIException(ids, (Exception)e);
                    }
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final void subprop() throws RecognitionException, TokenStreamException, OWLException {
        try {
            this.match(40);
            URI subUri = this.uriReference();
            URI supUri = this.uriReference();
            this.match(12);
            HashSet<String> ids = new HashSet<String>();
            ids.add(subUri.toString());
            ids.add(supUri.toString());
            switch (this.inferPropertyType(ids)) {
                case 1: {
                    this.builder.addDataSubPropertyAxiom(subUri, supUri);
                    break;
                }
                case 2: {
                    this.builder.addObjectSubPropertyAxiom(subUri, supUri);
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_3);
        }
    }

    public final URI classID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_13);
        }
        return uri;
    }

    public final boolean modality() throws RecognitionException, TokenStreamException {
        boolean isPartial = false;
        try {
            switch (this.LA(1)) {
                case 60: {
                    this.match(60);
                    break;
                }
                case 59: {
                    this.match(59);
                    isPartial = true;
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_14);
        }
        return isPartial;
    }

    public final URI datatypeID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_15);
        }
        return uri;
    }

    public final URI datavaluedPropertyID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_16);
        }
        return uri;
    }

    public final OWLDataRange dataRange() throws RecognitionException, TokenStreamException, OWLException {
        OWLDataType dataRange = null;
        try {
            switch (this.LA(1)) {
                case 62: 
                case 71: {
                    URI id = this.datatypeID();
                    dataRange = this.builder.getConcreteDataType(id);
                    break;
                }
                case 57: {
                    this.match(57);
                    dataRange = this.builder.getConcreteDataType(RDFS_LIT_URI);
                    break;
                }
                case 45: {
                    HashSet<OWLDataValue> literals = new HashSet<OWLDataValue>();
                    this.match(45);
                    while (this.LA(1) == 67) {
                        OWLDataValue literal = this.dataLiteral();
                        literals.add(literal);
                    }
                    dataRange = this.builder.getDataEnumeration(literals);
                    this.match(12);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_9);
        }
        return dataRange;
    }

    public final URI individualvaluedPropertyID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_17);
        }
        return uri;
    }

    public final URI ontologyPropertyID() throws RecognitionException, TokenStreamException, MalformedOWLURIException {
        URI uri = null;
        try {
            uri = this.uriReference();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_18);
        }
        return uri;
    }

    public final OWLDescription externalDescription(OWLBuilder newBuilder, Map newIdsTable, Map newNamespaceTable) throws RecognitionException, TokenStreamException, OWLException {
        this.builder = newBuilder;
        this.idsTable = newIdsTable;
        this.namespaceTable = newNamespaceTable;
        OWLDescription descr = null;
        try {
            descr = this.description();
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_1);
        }
        return descr;
    }

    public final OWLRestriction restriction() throws RecognitionException, TokenStreamException, OWLException {
        OWLRestriction result = null;
        try {
            block11: {
                this.match(41);
                URI id = this.uriReference();
                String idString = id.toString();
                String idType = (String)this.idsTable.get(idString);
                if (idType == null) {
                    throw new UndefinedOWLPropertyException(idString);
                }
                if (this.LA(1) >= 46 && this.LA(1) <= 51 && _tokenSet_19.member(this.LA(2)) && _tokenSet_20.member(this.LA(3)) && _tokenSet_21.member(this.LA(4)) && idType.equals(DATA_PROPERTY)) {
                    OWLDataProperty dataProp = this.builder.addDataProperty(id);
                    int _cnt100 = 0;
                    while (true) {
                        if (this.LA(1) < 46 || this.LA(1) > 51) {
                            if (_cnt100 < 1) {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            break block11;
                        }
                        OWLBuilder.RestrictionComponent restr = this.dataRestrictionComponent();
                        result = this.builder.getRestriction(dataProp, restr);
                        ++_cnt100;
                    }
                }
                if (this.LA(1) >= 46 && this.LA(1) <= 51 && _tokenSet_22.member(this.LA(2)) && _tokenSet_23.member(this.LA(3)) && _tokenSet_24.member(this.LA(4))) {
                    OWLObjectProperty objectProp = this.builder.addObjectProperty(id);
                    int _cnt102 = 0;
                    while (true) {
                        if (this.LA(1) < 46 || this.LA(1) > 51) {
                            if (_cnt102 < 1) {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                            break block11;
                        }
                        OWLBuilder.RestrictionComponent restr = this.individualRestrictionComponent();
                        result = this.builder.getRestriction(objectProp, restr);
                        ++_cnt102;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(12);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_12);
        }
        return result;
    }

    public final OWLBuilder.RestrictionComponent dataRestrictionComponent() throws RecognitionException, TokenStreamException, OWLException {
        OWLBuilder.CardinalityComponent restr = null;
        try {
            switch (this.LA(1)) {
                case 46: {
                    this.match(46);
                    OWLDataRange dRange = this.dataRange();
                    restr = new OWLBuilder.DataRangeComponent(dRange, 1);
                    this.match(12);
                    break;
                }
                case 47: {
                    this.match(47);
                    OWLDataRange dRange = this.dataRange();
                    restr = new OWLBuilder.DataRangeComponent(dRange, 2);
                    this.match(12);
                    break;
                }
                case 48: {
                    this.match(48);
                    OWLDataValue dLit = this.dataLiteral();
                    restr = new OWLBuilder.DataLiteralValueComponent(dLit);
                    this.match(12);
                    break;
                }
                case 49: 
                case 50: 
                case 51: {
                    restr = this.cardinality();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_25);
        }
        return restr;
    }

    public final OWLBuilder.RestrictionComponent individualRestrictionComponent() throws RecognitionException, TokenStreamException, OWLException {
        OWLBuilder.CardinalityComponent restr = null;
        try {
            switch (this.LA(1)) {
                case 46: {
                    this.match(46);
                    OWLDescription descr = this.description();
                    this.match(12);
                    restr = this.builder.createDescriptionComponent(descr, 1);
                    break;
                }
                case 47: {
                    this.match(47);
                    OWLDescription descr = this.description();
                    this.match(12);
                    restr = this.builder.createDescriptionComponent(descr, 2);
                    break;
                }
                case 48: {
                    this.match(48);
                    URI id = this.individualID();
                    this.match(12);
                    restr = new OWLBuilder.IndividualValueComponent(id);
                    break;
                }
                case 49: 
                case 50: 
                case 51: {
                    restr = this.cardinality();
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_25);
        }
        return restr;
    }

    public final OWLBuilder.CardinalityComponent cardinality() throws RecognitionException, TokenStreamException {
        Token c = null;
        OWLBuilder.CardinalityComponent card = null;
        try {
            switch (this.LA(1)) {
                case 49: {
                    this.match(49);
                    card = this.builder.createCardinalityComponent(2);
                    break;
                }
                case 50: {
                    this.match(50);
                    card = this.builder.createCardinalityComponent(1);
                    break;
                }
                case 51: {
                    this.match(51);
                    card = this.builder.createCardinalityComponent(3);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            c = this.LT(1);
            this.match(61);
            card.setCardinality(ANTLRParser.removeTail(c.getText()));
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_25);
        }
        return card;
    }

    public final OWLDataValue datatypeString() throws RecognitionException, TokenStreamException, OWLException {
        Token q = null;
        Token l = null;
        OWLDataValue literal = null;
        URI uri = null;
        String lang = null;
        try {
            q = this.LT(1);
            this.match(67);
            String val = ANTLRParser.removeHeadAndTail(q.getText());
            switch (this.LA(1)) {
                case 15: {
                    this.match(15);
                    uri = this.uriReference();
                    break;
                }
                case 9: {
                    this.match(9);
                    l = this.LT(1);
                    this.match(73);
                    lang = l.getText();
                    break;
                }
                case 12: 
                case 67: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            literal = this.builder.getConcreteData(uri, lang, (Object)val);
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_6);
        }
        return literal;
    }

    public final String[] qname() throws RecognitionException, TokenStreamException {
        Token p = null;
        Token i = null;
        String[] s = null;
        try {
            p = this.LT(1);
            this.match(71);
            i = this.LT(1);
            this.match(74);
            s = new String[]{ANTLRParser.removeTail(p.getText()), i.getText()};
        }
        catch (RecognitionException ex) {
            this.reportError(ex);
            this.consume();
            this.consumeUntil(_tokenSet_5);
        }
        return s;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{31526856321138688L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{2L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{0x140000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{31526856321142784L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{0x4140000000001000L, 136L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{6773413839563657218L, 136L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{4096L, 8L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{4720053884460994560L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{4720122594274054144L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{4096L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{0x1000000001000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{4611754188148310016L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{4611754188148314114L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{6701424415248224258L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[]{4683811782186242048L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[]{0x500000000001000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[]{360288046425313280L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{360288510281781248L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{0x100000000001000L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{0x6200200000000000L, 136L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[]{4433230883230208L, 1032L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[]{7066145616321090050L, 648L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_22() {
        long[] data = new long[]{6917597197362003968L, 128L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_23() {
        long[] data = new long[]{4616187419031506944L, 1152L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_24() {
        long[] data = new long[]{6922030428245200898L, 1152L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_25() {
        long[] data = new long[]{4433230883196928L, 0L};
        return data;
    }
}

