/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.control;

import com.fujitsu.fla.upnp.Service;
import com.fujitsu.fla.upnp.http.HTTP;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.soap.SOAPRequest;
import java.net.MalformedURLException;
import java.net.URL;

public class ControlRequest
extends SOAPRequest {
    public ControlRequest() {
    }

    public ControlRequest(HTTPRequest httpReq) {
        this.set(httpReq);
    }

    public boolean isQueryControl() {
        return this.isSOAPAction("urn:schemas-upnp-org:control-1-0#QueryStateVariable");
    }

    public boolean isActionControl() {
        return !this.isQueryControl();
    }

    protected void setRequestHost(Service service) {
        String ctrlURL = service.getControlURL();
        String urlBase = service.getRootDevice().getURLBase();
        if (urlBase != null && urlBase.length() > 0) {
            try {
                URL url = new URL(urlBase);
                String basePath = url.getPath();
                int baseLen = basePath.length();
                if (baseLen > 0 && (1 < baseLen || basePath.charAt(0) != '/')) {
                    ctrlURL = String.valueOf(basePath) + ctrlURL;
                }
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        this.setURI(ctrlURL, true);
        String postURL = "";
        if (HTTP.isAbsoluteURL(ctrlURL)) {
            postURL = ctrlURL;
        }
        if (postURL == null || postURL.length() <= 0) {
            postURL = service.getRootDevice().getURLBase();
        }
        if (postURL == null || postURL.length() <= 0) {
            postURL = service.getRootDevice().getLocation();
        }
        String reqHost = HTTP.getHost(postURL);
        int reqPort = HTTP.getPort(postURL);
        this.setHost(reqHost, reqPort);
        this.setRequestHost(reqHost);
        this.setRequestPort(reqPort);
    }
}

