/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.ssdp;

import com.fujitsu.fla.upnp.ControlPoint;
import com.fujitsu.fla.upnp.http.HTTPRequest;
import com.fujitsu.fla.upnp.ssdp.HTTPMUSocket;
import com.fujitsu.fla.upnp.ssdp.SSDPNotifyRequest;
import com.fujitsu.fla.upnp.ssdp.SSDPPacket;
import java.net.InetAddress;

public class SSDPNotifySocket
extends HTTPMUSocket
implements Runnable {
    private ControlPoint controlPoint = null;
    private Thread deviceNotifyThread = null;

    public SSDPNotifySocket(String bindAddr) {
        String addr = "239.255.255.250";
        this.open(addr, 1900, bindAddr);
        this.setControlPoint(null);
    }

    public void setControlPoint(ControlPoint ctrlp) {
        this.controlPoint = ctrlp;
    }

    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public boolean post(SSDPNotifyRequest req) {
        String ssdpAddr = "239.255.255.250";
        req.setHost(ssdpAddr, 1900);
        return this.post((HTTPRequest)req);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        ControlPoint ctrlPoint = this.getControlPoint();
        while (this.deviceNotifyThread == thisThread) {
            Thread.yield();
            SSDPPacket packet = this.receive();
            InetAddress maddr = this.getMulticastInetAddress();
            InetAddress pmaddr = packet.getHostInetAddress();
            if (!maddr.equals(pmaddr) || ctrlPoint == null) continue;
            ctrlPoint.notifyReceived(packet);
        }
    }

    public void start() {
        this.deviceNotifyThread = new Thread(this);
        this.deviceNotifyThread.start();
    }

    public void stop() {
        this.deviceNotifyThread = null;
    }
}

