/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.fla.upnp.xml;

import com.fujitsu.fla.upnp.xml.Attribute;
import com.fujitsu.fla.upnp.xml.AttributeList;
import com.fujitsu.fla.upnp.xml.NodeList;
import com.fujitsu.fla.upnp.xml.XML;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class Node {
    protected Node parentNode = null;
    private Object userData = null;
    private String name = new String();
    private String value = new String();
    private AttributeList attrList = new AttributeList();
    private NodeList nodeList = new NodeList();

    public Node() {
        this.setUserData(null);
        this.setParentNode(null);
    }

    public Node(String name) {
        this();
        this.setName(name);
    }

    public Node(String ns, String name) {
        this();
        this.setName(ns, name);
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public Node getRootNode() {
        Node rootNode = null;
        Node parentNode = this.getParentNode();
        while (parentNode != null) {
            rootNode = parentNode;
            parentNode = rootNode.getParentNode();
        }
        return rootNode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setName(String ns, String name) {
        this.name = String.valueOf(ns) + ":" + name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isName(String value) {
        return this.name.equals(value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public String getValue() {
        return this.value;
    }

    public int getNAttributes() {
        return this.attrList.size();
    }

    public Attribute getAttribute(int index) {
        return this.attrList.getAttribute(index);
    }

    public Attribute getAttribute(String name) {
        return this.attrList.getAttribute(name);
    }

    public void addAttribute(Attribute attr) {
        this.attrList.add(attr);
    }

    public void insertAttributeAt(Attribute attr, int index) {
        this.attrList.insertElementAt(attr, index);
    }

    public void addAttribute(String name, String value) {
        Attribute attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public boolean removeAttribute(Attribute attr) {
        return this.attrList.remove(attr);
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(this.getAttribute(name));
    }

    public boolean hasAttributes() {
        return this.getNAttributes() > 0;
    }

    public void setAttribute(String name, String value) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            attr.setValue(value);
            return;
        }
        attr = new Attribute(name, value);
        this.addAttribute(attr);
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, Integer.toString(value));
    }

    public String getAttributeValue(String name) {
        Attribute attr = this.getAttribute(name);
        if (attr != null) {
            return attr.getValue();
        }
        return "";
    }

    public int getAttributeIntegerValue(String name) {
        String val = this.getAttributeValue(name);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setNameSpace(String ns, String value) {
        this.setAttribute("xmlns:" + ns, value);
    }

    public int getNNodes() {
        return this.nodeList.size();
    }

    public Node getNode(int index) {
        return this.nodeList.getNode(index);
    }

    public Node getNode(String name) {
        return this.nodeList.getNode(name);
    }

    public Node getNodeEndsWith(String name) {
        return this.nodeList.getEndsWith(name);
    }

    public void addNode(Node node) {
        node.setParentNode(this);
        this.nodeList.add(node);
    }

    public void insertNode(Node node, int index) {
        node.setParentNode(this);
        this.nodeList.insertElementAt(node, index);
    }

    public boolean removeNode(Node node) {
        node.setParentNode(null);
        return this.nodeList.remove(node);
    }

    public boolean removeNode(String name) {
        return this.nodeList.remove(this.getNode(name));
    }

    public void removeAllNodes() {
        this.nodeList.clear();
    }

    public boolean hasNodes() {
        return this.getNNodes() > 0;
    }

    public void setNode(String name, String value) {
        Node node = this.getNode(name);
        if (node != null) {
            node.setValue(value);
            return;
        }
        node = new Node(name);
        node.setValue(value);
        this.addNode(node);
    }

    public String getNodeValue(String name) {
        Node node = this.getNode(name);
        if (node != null) {
            return node.getValue();
        }
        return "";
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public Object getUserData() {
        return this.userData;
    }

    public String getIndentLevelString(int nIndentLevel) {
        char[] indentString = new char[nIndentLevel];
        int n = 0;
        while (n < nIndentLevel) {
            indentString[n] = 9;
            ++n;
        }
        return new String(indentString);
    }

    public void outputAttributes(PrintWriter ps) {
        int nAttributes = this.getNAttributes();
        int n = 0;
        while (n < nAttributes) {
            Attribute attr = this.getAttribute(n);
            ps.print(" " + attr.getName() + "=\"" + XML.escapeXMLChars(attr.getValue()) + "\"");
            ++n;
        }
    }

    public void output(PrintWriter ps, int indentLevel, boolean hasChildNode) {
        String indentString = this.getIndentLevelString(indentLevel);
        String name = this.getName();
        String value = this.getValue();
        if (!this.hasNodes() || !hasChildNode) {
            ps.print(String.valueOf(indentString) + "<" + name);
            this.outputAttributes(ps);
            if (value == null || value.length() == 0) {
                ps.println(" />");
            } else {
                ps.println(">" + XML.escapeXMLChars(value) + "</" + name + ">");
            }
            return;
        }
        ps.print(String.valueOf(indentString) + "<" + name);
        this.outputAttributes(ps);
        ps.println(">");
        int nChildNodes = this.getNNodes();
        int n = 0;
        while (n < nChildNodes) {
            Node cnode = this.getNode(n);
            cnode.output(ps, indentLevel + 1, true);
            ++n;
        }
        ps.println(String.valueOf(indentString) + "</" + name + ">");
    }

    public String toString(boolean hasChildNode) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PrintWriter pr = new PrintWriter(byteOut);
        this.output(pr, 0, hasChildNode);
        pr.flush();
        return byteOut.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toXMLString(boolean hasChildNode) {
        String xmlStr = this.toString();
        xmlStr = xmlStr.replaceAll("<", "&lt;");
        xmlStr = xmlStr.replaceAll(">", "&gt;");
        xmlStr = xmlStr.replaceAll("&", "&amp;");
        xmlStr = xmlStr.replaceAll("\"", "&quot;");
        xmlStr = xmlStr.replaceAll("\\", "&apos;");
        return xmlStr;
    }

    public String toXMLString() {
        return this.toXMLString(true);
    }

    public void print(boolean hasChildNode) {
        PrintWriter pr = new PrintWriter(System.out);
        this.output(pr, 0, hasChildNode);
        pr.flush();
    }

    public void print() {
        this.print(true);
    }
}

