/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;

public final class Jaro
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 4.12E-5f;

    public String getShortDescriptionString() {
        return "Jaro";
    }

    public String getLongDescriptionString() {
        return "Implements the Jaro algorithm providing a similarity measure between two strings allowing character transpositions to a degree";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return str1Length * str2Length * 4.12E-5f;
    }

    public float getSimilarity(String string1, String string2) {
        int halflen = Math.min(string1.length(), string2.length()) / 2 + 1;
        StringBuffer common1 = Jaro.getCommonCharacters(string1, string2, halflen);
        StringBuffer common2 = Jaro.getCommonCharacters(string2, string1, halflen);
        if (common1.length() == 0 || common2.length() == 0) {
            return 0.0f;
        }
        if (common1.length() != common2.length()) {
            return 0.0f;
        }
        int transpositions = 0;
        for (int i = 0; i < common1.length(); ++i) {
            if (common1.charAt(i) == common2.charAt(i)) continue;
            ++transpositions;
        }
        transpositions = (int)((float)transpositions / 2.0f);
        return ((float)common1.length() / (float)string1.length() + (float)common2.length() / (float)string2.length() + (float)(common1.length() - transpositions) / (float)common1.length()) / 3.0f;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        return this.getSimilarity(string1, string2);
    }

    private static StringBuffer getCommonCharacters(String string1, String string2, int distanceSep) {
        StringBuffer returnCommons = new StringBuffer();
        StringBuffer copy = new StringBuffer(string2);
        for (int i = 0; i < string1.length(); ++i) {
            char ch = string1.charAt(i);
            boolean foundIt = false;
            for (int j = Math.max(0, i - distanceSep); !foundIt && j < Math.min(i + distanceSep, string2.length()); ++j) {
                if (copy.charAt(j) != ch) continue;
                foundIt = true;
                returnCommons.append(ch);
                copy.setCharAt(j, '\u0000');
            }
        }
        return returnCommons;
    }
}

