/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.owlapi.ConceptConverter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyRange;
import org.semanticweb.owl.model.SWRLAtom;
import org.semanticweb.owl.model.SWRLAtomDObject;
import org.semanticweb.owl.model.SWRLAtomIObject;
import org.semanticweb.owl.model.SWRLClassAtom;
import org.semanticweb.owl.vocab.SWRLBuiltInsVocabulary;

public class AxiomConverter {
    public static Logger log = Logger.getLogger(ABox.class.getName());
    private ConceptConverter conceptConverter;
    private OWLDataFactory factory;
    private KnowledgeBase kb;

    public AxiomConverter(KnowledgeBase kb, OWLDataFactory factory) {
        if (kb == null) {
            throw new NullPointerException("KnowledgeBase is null");
        }
        if (factory == null) {
            throw new NullPointerException("OWLDataFactory is null");
        }
        this.kb = kb;
        this.factory = factory;
        this.conceptConverter = new ConceptConverter(kb, factory);
    }

    public OWLAxiom convert(ATermAppl term) {
        Object axiom = null;
        if (term.getAFun().equals(ATermUtils.EQCLASSFUN)) {
            OWLDescription c1 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLEquivalentClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.SUBFUN)) {
            OWLDescription c1 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLSubClassAxiom(c1, c2);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTSFUN)) {
            ATermAppl concept;
            OWLDescription c;
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            ATermList concepts = (ATermList)term.getArgument(0);
            while (!concepts.isEmpty() && (c = (OWLDescription)this.conceptConverter.convert(concept = (ATermAppl)concepts.getFirst())) != null) {
                descriptions.add(c);
                concepts = concepts.getNext();
            }
            if (concepts.isEmpty()) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTFUN)) {
            OWLDescription c1 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c2 = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            HashSet<OWLDescription> descriptions = new HashSet<OWLDescription>();
            descriptions.add(c1);
            descriptions.add(c2);
            if (c1 != null && c2 != null) {
                axiom = this.factory.getOWLDisjointClassesAxiom(descriptions);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPSFUN)) {
            boolean isObjectProp;
            OWLObject p;
            HashSet<OWLProperty> properties = new HashSet<OWLProperty>();
            Boolean isObjectProps = null;
            ATermList props = (ATermList)term.getArgument(0);
            while (!props.isEmpty() && (p = this.conceptConverter.convert((ATermAppl)term.getArgument(0))) != null && ((isObjectProp = p instanceof OWLObjectProperty) || p instanceof OWLDataProperty)) {
                if (isObjectProps == null) {
                    isObjectProps = isObjectProp;
                } else if (isObjectProps != isObjectProp) break;
                properties.add((OWLProperty)p);
                props = props.getNext();
            }
            if (props.isEmpty()) {
                axiom = isObjectProps.booleanValue() ? this.factory.getOWLDisjointObjectPropertiesAxiom(properties) : this.factory.getOWLDisjointDataPropertiesAxiom(properties);
            }
        } else if (term.getAFun().equals(ATermUtils.DISJOINTPROPFUN)) {
            OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLDisjointObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{(OWLObjectProperty)p1, (OWLObjectProperty)p2}));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLDisjointDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{(OWLDataProperty)p1, (OWLDataProperty)p2}));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SUBPROPFUN)) {
            if (term.getArgument(0) instanceof ATermList) {
                ArrayList<OWLObjectPropertyExpression> subs = new ArrayList<OWLObjectPropertyExpression>();
                ATermList list = (ATermList)term.getArgument(0);
                while (!list.isEmpty()) {
                    OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)this.conceptConverter.convert((ATermAppl)list.getFirst());
                    if (p == null) {
                        subs = null;
                        break;
                    }
                    subs.add(p);
                    list = list.getNext();
                }
                OWLObjectProperty sup = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (subs != null && sup != null) {
                    axiom = this.factory.getOWLObjectPropertyChainSubPropertyAxiom(subs, (OWLObjectPropertyExpression)sup);
                }
            } else {
                OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
                if (p1 != null && p2 != null) {
                    if (p1 instanceof OWLObjectPropertyExpression && p2 instanceof OWLObjectPropertyExpression) {
                        axiom = this.factory.getOWLSubObjectPropertyAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
                    } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                        axiom = this.factory.getOWLSubDataPropertyAxiom((OWLDataPropertyExpression)((OWLDataProperty)p1), (OWLDataPropertyExpression)((OWLDataProperty)p2));
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.EQPROPFUN)) {
            OWLObject p1 = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObject p2 = this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                if (p1 instanceof OWLObjectProperty && p2 instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLEquivalentObjectPropertiesAxiom(SetUtils.create((Object[])new OWLObjectProperty[]{(OWLObjectProperty)p1, (OWLObjectProperty)p2}));
                } else if (p1 instanceof OWLDataProperty && p2 instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLEquivalentDataPropertiesAxiom(SetUtils.create((Object[])new OWLDataProperty[]{(OWLDataProperty)p1, (OWLDataProperty)p2}));
                }
            }
        } else if (term.getAFun().equals(ATermUtils.DOMAINFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLDescription c = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (c != null && p != null) {
                axiom = p instanceof OWLObjectProperty ? this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, c) : this.factory.getOWLDataPropertyDomainAxiom((OWLDataPropertyExpression)p, c);
            }
        } else if (term.getAFun().equals(ATermUtils.RANGEFUN)) {
            OWLPropertyRange e = (OWLPropertyRange)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (e != null) {
                if (e instanceof OWLDescription) {
                    OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p, (OWLDescription)e);
                    }
                } else {
                    OWLDataProperty p = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                    if (p != null) {
                        axiom = this.factory.getOWLDataPropertyRangeAxiom((OWLDataPropertyExpression)p, (OWLDataRange)e);
                    }
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVPROPFUN)) {
            OWLObjectProperty p1 = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            OWLObjectProperty p2 = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (p1 != null && p2 != null) {
                axiom = this.factory.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)p1, (OWLObjectPropertyExpression)p2);
            }
        } else if (term.getAFun().equals(ATermUtils.TRANSITIVEFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this.factory.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.FUNCTIONALFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                if (p instanceof OWLObjectProperty) {
                    axiom = this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p);
                } else if (p instanceof OWLDataProperty) {
                    axiom = this.factory.getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.INVFUNCTIONALFUN)) {
            OWLObjectProperty p = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null) {
                axiom = this.factory.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.SYMMETRICFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.ASYMMETRICFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLAntiSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.REFLEXIVEFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.IRREFLEXIVEFUN)) {
            OWLObject p = this.conceptConverter.convert((ATermAppl)term.getArgument(0));
            if (p != null && p instanceof OWLObjectPropertyExpression) {
                axiom = this.factory.getOWLIrreflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p);
            }
        } else if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            OWLIndividual i = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(0)).getName()));
            OWLDescription c = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            if (i != null && c != null) {
                axiom = this.factory.getOWLClassAssertionAxiom(i, c);
            }
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(1)).getName()));
            if (subj == null) {
                axiom = null;
            } else if (ATermUtils.isLiteral((ATermAppl)((ATermAppl)term.getArgument(2)))) {
                OWLDataProperty pred = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLConstant obj = (OWLConstant)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLDataPropertyAssertionAxiom(subj, (OWLDataPropertyExpression)pred, obj);
                }
            } else {
                OWLObjectProperty pred = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLIndividual obj = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(2)).getName()));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLObjectPropertyAssertionAxiom(subj, (OWLObjectPropertyExpression)pred, obj);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.NOTFUN) && ((ATermAppl)term.getArgument(0)).getAFun().equals(ATermUtils.PROPFUN)) {
            OWLIndividual subj = this.factory.getOWLIndividual(URI.create(((ATermAppl)(term = (ATermAppl)term.getArgument(0)).getArgument(1)).getName()));
            if (subj == null) {
                axiom = null;
            } else if (ATermUtils.isLiteral((ATermAppl)((ATermAppl)term.getArgument(2)))) {
                OWLDataProperty pred = (OWLDataProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLConstant obj = (OWLConstant)this.conceptConverter.convert((ATermAppl)term.getArgument(2));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLNegativeDataPropertyAssertionAxiom(subj, (OWLDataPropertyExpression)pred, obj);
                }
            } else {
                OWLObjectProperty pred = (OWLObjectProperty)this.conceptConverter.convert((ATermAppl)term.getArgument(0));
                OWLIndividual obj = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(2)).getName()));
                if (pred != null && obj != null) {
                    axiom = this.factory.getOWLNegativeObjectPropertyAssertionAxiom(subj, (OWLObjectPropertyExpression)pred, obj);
                }
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            OWLIndividual ind1 = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(0)).getName()));
            OWLIndividual ind2 = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(1)).getName()));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this.factory.getOWLSameIndividualsAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            OWLIndividual ind1 = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(0)).getName()));
            OWLIndividual ind2 = this.factory.getOWLIndividual(URI.create(((ATermAppl)term.getArgument(1)).getName()));
            HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
            inds.add(ind1);
            inds.add(ind2);
            if (ind1 != null && ind2 != null) {
                axiom = this.factory.getOWLDifferentIndividualsAxiom(inds);
            }
        } else if (term.getAFun().equals(ATermUtils.ALLDIFFERENTFUN)) {
            ATermAppl ind;
            OWLIndividual i;
            HashSet<OWLIndividual> individuals = new HashSet<OWLIndividual>();
            ATermList list = (ATermList)term.getArgument(0);
            while (!list.isEmpty() && (i = this.factory.getOWLIndividual(URI.create((ind = (ATermAppl)list.getFirst()).getName()))) != null) {
                individuals.add(i);
                list = list.getNext();
            }
            if (list.isEmpty()) {
                axiom = this.factory.getOWLDifferentIndividualsAxiom(individuals);
            }
        } else if (term.getAFun().equals(ATermUtils.RULEFUN)) {
            HashSet<SWRLAtom> antecedent = new HashSet<SWRLAtom>();
            HashSet<SWRLAtom> consequent = new HashSet<SWRLAtom>();
            ATermList head = (ATermList)term.getArgument(1);
            ATermList body = (ATermList)term.getArgument(2);
            while (!body.isEmpty()) {
                antecedent.add(this.parseToSWRLAtom((ATermAppl)body.getFirst()));
                body = body.getNext();
            }
            while (!head.isEmpty()) {
                consequent.add(this.parseToSWRLAtom((ATermAppl)head.getFirst()));
                head = head.getNext();
            }
            if (!antecedent.contains(null) && !consequent.contains(null)) {
                ATermAppl name = (ATermAppl)term.getArgument(0);
                if (name == ATermUtils.EMPTY) {
                    axiom = this.factory.getSWRLRule(antecedent, consequent);
                } else if (ATermUtils.isBnode((ATermAppl)name)) {
                    URI uri = URI.create(((ATermAppl)name.getArgument(0)).getName());
                    axiom = this.factory.getSWRLRule(uri, true, antecedent, consequent);
                } else {
                    axiom = this.factory.getSWRLRule(URI.create(name.getName()), antecedent, consequent);
                }
            }
        }
        if (axiom == null) {
            log.warning("Cannot convert to OWLAPI: " + term);
        }
        return axiom;
    }

    private SWRLAtom parseToSWRLAtom(ATermAppl term) {
        SWRLClassAtom atom = null;
        if (term.getAFun().equals(ATermUtils.TYPEFUN)) {
            ATermAppl i = (ATermAppl)term.getArgument(0);
            SWRLAtomIObject io = this.parseToAtomIObject(i);
            OWLDescription c = (OWLDescription)this.conceptConverter.convert((ATermAppl)term.getArgument(1));
            atom = this.factory.getSWRLClassAtom(c, io);
        } else if (term.getAFun().equals(ATermUtils.PROPFUN)) {
            ATermAppl p = (ATermAppl)term.getArgument(0);
            ATermAppl i1 = (ATermAppl)term.getArgument(1);
            ATermAppl i2 = (ATermAppl)term.getArgument(2);
            SWRLAtomIObject io1 = this.parseToAtomIObject(i1);
            if (this.kb.isObjectProperty((ATerm)p)) {
                SWRLAtomIObject io2 = this.parseToAtomIObject(i2);
                OWLObjectProperty op = this.factory.getOWLObjectProperty(URI.create(p.getName()));
                atom = this.factory.getSWRLObjectPropertyAtom((OWLObjectPropertyExpression)op, io1, io2);
            } else if (this.kb.isDatatypeProperty((ATerm)p)) {
                SWRLAtomDObject do2 = this.parseToAtomDObject(i2);
                OWLDataProperty dp = this.factory.getOWLDataProperty(URI.create(p.getName()));
                atom = this.factory.getSWRLDataValuedPropertyAtom((OWLDataPropertyExpression)dp, io1, do2);
            }
        } else if (term.getAFun().equals(ATermUtils.SAMEASFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLAtomIObject io1 = this.parseToAtomIObject(i1);
            SWRLAtomIObject io2 = this.parseToAtomIObject(i2);
            atom = this.factory.getSWRLSameAsAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.DIFFERENTFUN)) {
            ATermAppl i1 = (ATermAppl)term.getArgument(0);
            ATermAppl i2 = (ATermAppl)term.getArgument(1);
            SWRLAtomIObject io1 = this.parseToAtomIObject(i1);
            SWRLAtomIObject io2 = this.parseToAtomIObject(i2);
            atom = this.factory.getSWRLDifferentFromAtom(io1, io2);
        } else if (term.getAFun().equals(ATermUtils.BUILTINFUN)) {
            ATermList args = (ATermList)term.getArgument(0);
            ATermAppl builtin = (ATermAppl)args.getFirst();
            ArrayList<SWRLAtomDObject> list = new ArrayList<SWRLAtomDObject>();
            args = args.getNext();
            while (!args.isEmpty()) {
                ATermAppl arg = (ATermAppl)args.getFirst();
                list.add(this.parseToAtomDObject(arg));
                args = args.getNext();
            }
            atom = this.factory.getSWRLBuiltInAtom(SWRLBuiltInsVocabulary.getBuiltIn((URI)URI.create(builtin.toString())), list);
        }
        if (atom == null) {
            log.warning("Cannot convert to SWRLAtom: " + term);
        }
        return atom;
    }

    private SWRLAtomIObject parseToAtomIObject(ATermAppl t) {
        if (ATermUtils.isVar((ATermAppl)t)) {
            return this.factory.getSWRLAtomIVariable(URI.create(((ATermAppl)t.getArgument(0)).getName()));
        }
        if (this.kb.isIndividual((ATerm)t)) {
            return this.factory.getSWRLAtomIndividualObject(this.factory.getOWLIndividual(URI.create(t.getName())));
        }
        if (ATermUtils.isAnon((ATermAppl)t)) {
            return this.factory.getSWRLAtomIndividualObject(this.factory.getOWLAnonymousIndividual(URI.create(t.getName())));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }

    private SWRLAtomDObject parseToAtomDObject(ATermAppl t) {
        if (ATermUtils.isVar((ATermAppl)t)) {
            return this.factory.getSWRLAtomDVariable(URI.create(((ATermAppl)t.getArgument(0)).getName()));
        }
        if (ATermUtils.isLiteral((ATermAppl)t)) {
            return this.factory.getSWRLAtomConstantObject((OWLConstant)this.conceptConverter.convert(t));
        }
        throw new InternalReasonerException("Unrecognized term: " + t);
    }
}

